/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.ConsensusConfig;

public class ConsensusConfigV4
implements ConsensusConfig,
Serializable {
    int magic;
    int flags;
    boolean newCatchainIds;
    int roundCandidates;
    long nextCandidateDelayMs;
    long consensusTimeoutMs;
    long fastAttempts;
    long attemptDuration;
    long catchainNaxDeps;
    long maxBlockBytes;
    long maxCollatedBytes;
    int protoVersion;
    long catchainMaxBlocksCoeff;

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(216, 8).storeUint(this.flags, 7).storeBit(Boolean.valueOf(this.newCatchainIds)).storeUint(this.roundCandidates, 8).storeUint(this.nextCandidateDelayMs, 32).storeUint(this.consensusTimeoutMs, 32).storeUint(this.fastAttempts, 32).storeUint(this.attemptDuration, 32).storeUint(this.catchainNaxDeps, 32).storeUint(this.maxBlockBytes, 32).storeUint(this.maxCollatedBytes, 32).storeUint(this.protoVersion, 16).storeUint(this.catchainMaxBlocksCoeff, 32).endCell();
    }

    public static ConsensusConfigV4 deserialize(CellSlice cs) {
        return ConsensusConfigV4.builder().magic(cs.loadUint(8).intValue()).flags(cs.loadUint(7).intValue()).newCatchainIds(cs.loadBit()).roundCandidates(cs.loadUint(8).intValue()).nextCandidateDelayMs(cs.loadUint(32).longValue()).consensusTimeoutMs(cs.loadUint(32).longValue()).fastAttempts(cs.loadUint(32).longValue()).attemptDuration(cs.loadUint(32).longValue()).catchainNaxDeps(cs.loadUint(32).longValue()).maxBlockBytes(cs.loadUint(32).longValue()).maxCollatedBytes(cs.loadUint(32).longValue()).protoVersion(cs.loadUint(16).intValue()).catchainMaxBlocksCoeff(cs.loadUint(32).longValue()).build();
    }

    ConsensusConfigV4(int magic, int flags, boolean newCatchainIds, int roundCandidates, long nextCandidateDelayMs, long consensusTimeoutMs, long fastAttempts, long attemptDuration, long catchainNaxDeps, long maxBlockBytes, long maxCollatedBytes, int protoVersion, long catchainMaxBlocksCoeff) {
        this.magic = magic;
        this.flags = flags;
        this.newCatchainIds = newCatchainIds;
        this.roundCandidates = roundCandidates;
        this.nextCandidateDelayMs = nextCandidateDelayMs;
        this.consensusTimeoutMs = consensusTimeoutMs;
        this.fastAttempts = fastAttempts;
        this.attemptDuration = attemptDuration;
        this.catchainNaxDeps = catchainNaxDeps;
        this.maxBlockBytes = maxBlockBytes;
        this.maxCollatedBytes = maxCollatedBytes;
        this.protoVersion = protoVersion;
        this.catchainMaxBlocksCoeff = catchainMaxBlocksCoeff;
    }

    public static ConsensusConfigV4Builder builder() {
        return new ConsensusConfigV4Builder();
    }

    public int getMagic() {
        return this.magic;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isNewCatchainIds() {
        return this.newCatchainIds;
    }

    public int getRoundCandidates() {
        return this.roundCandidates;
    }

    public long getNextCandidateDelayMs() {
        return this.nextCandidateDelayMs;
    }

    public long getConsensusTimeoutMs() {
        return this.consensusTimeoutMs;
    }

    public long getFastAttempts() {
        return this.fastAttempts;
    }

    public long getAttemptDuration() {
        return this.attemptDuration;
    }

    public long getCatchainNaxDeps() {
        return this.catchainNaxDeps;
    }

    public long getMaxBlockBytes() {
        return this.maxBlockBytes;
    }

    public long getMaxCollatedBytes() {
        return this.maxCollatedBytes;
    }

    public int getProtoVersion() {
        return this.protoVersion;
    }

    public long getCatchainMaxBlocksCoeff() {
        return this.catchainMaxBlocksCoeff;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void setNewCatchainIds(boolean newCatchainIds) {
        this.newCatchainIds = newCatchainIds;
    }

    public void setRoundCandidates(int roundCandidates) {
        this.roundCandidates = roundCandidates;
    }

    public void setNextCandidateDelayMs(long nextCandidateDelayMs) {
        this.nextCandidateDelayMs = nextCandidateDelayMs;
    }

    public void setConsensusTimeoutMs(long consensusTimeoutMs) {
        this.consensusTimeoutMs = consensusTimeoutMs;
    }

    public void setFastAttempts(long fastAttempts) {
        this.fastAttempts = fastAttempts;
    }

    public void setAttemptDuration(long attemptDuration) {
        this.attemptDuration = attemptDuration;
    }

    public void setCatchainNaxDeps(long catchainNaxDeps) {
        this.catchainNaxDeps = catchainNaxDeps;
    }

    public void setMaxBlockBytes(long maxBlockBytes) {
        this.maxBlockBytes = maxBlockBytes;
    }

    public void setMaxCollatedBytes(long maxCollatedBytes) {
        this.maxCollatedBytes = maxCollatedBytes;
    }

    public void setProtoVersion(int protoVersion) {
        this.protoVersion = protoVersion;
    }

    public void setCatchainMaxBlocksCoeff(long catchainMaxBlocksCoeff) {
        this.catchainMaxBlocksCoeff = catchainMaxBlocksCoeff;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsensusConfigV4)) {
            return false;
        }
        ConsensusConfigV4 other = (ConsensusConfigV4)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        if (this.getFlags() != other.getFlags()) {
            return false;
        }
        if (this.isNewCatchainIds() != other.isNewCatchainIds()) {
            return false;
        }
        if (this.getRoundCandidates() != other.getRoundCandidates()) {
            return false;
        }
        if (this.getNextCandidateDelayMs() != other.getNextCandidateDelayMs()) {
            return false;
        }
        if (this.getConsensusTimeoutMs() != other.getConsensusTimeoutMs()) {
            return false;
        }
        if (this.getFastAttempts() != other.getFastAttempts()) {
            return false;
        }
        if (this.getAttemptDuration() != other.getAttemptDuration()) {
            return false;
        }
        if (this.getCatchainNaxDeps() != other.getCatchainNaxDeps()) {
            return false;
        }
        if (this.getMaxBlockBytes() != other.getMaxBlockBytes()) {
            return false;
        }
        if (this.getMaxCollatedBytes() != other.getMaxCollatedBytes()) {
            return false;
        }
        if (this.getProtoVersion() != other.getProtoVersion()) {
            return false;
        }
        return this.getCatchainMaxBlocksCoeff() == other.getCatchainMaxBlocksCoeff();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConsensusConfigV4;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        result = result * 59 + this.getFlags();
        result = result * 59 + (this.isNewCatchainIds() ? 79 : 97);
        result = result * 59 + this.getRoundCandidates();
        long $nextCandidateDelayMs = this.getNextCandidateDelayMs();
        result = result * 59 + (int)($nextCandidateDelayMs >>> 32 ^ $nextCandidateDelayMs);
        long $consensusTimeoutMs = this.getConsensusTimeoutMs();
        result = result * 59 + (int)($consensusTimeoutMs >>> 32 ^ $consensusTimeoutMs);
        long $fastAttempts = this.getFastAttempts();
        result = result * 59 + (int)($fastAttempts >>> 32 ^ $fastAttempts);
        long $attemptDuration = this.getAttemptDuration();
        result = result * 59 + (int)($attemptDuration >>> 32 ^ $attemptDuration);
        long $catchainNaxDeps = this.getCatchainNaxDeps();
        result = result * 59 + (int)($catchainNaxDeps >>> 32 ^ $catchainNaxDeps);
        long $maxBlockBytes = this.getMaxBlockBytes();
        result = result * 59 + (int)($maxBlockBytes >>> 32 ^ $maxBlockBytes);
        long $maxCollatedBytes = this.getMaxCollatedBytes();
        result = result * 59 + (int)($maxCollatedBytes >>> 32 ^ $maxCollatedBytes);
        result = result * 59 + this.getProtoVersion();
        long $catchainMaxBlocksCoeff = this.getCatchainMaxBlocksCoeff();
        result = result * 59 + (int)($catchainMaxBlocksCoeff >>> 32 ^ $catchainMaxBlocksCoeff);
        return result;
    }

    public String toString() {
        return "ConsensusConfigV4(magic=" + this.getMagic() + ", flags=" + this.getFlags() + ", newCatchainIds=" + this.isNewCatchainIds() + ", roundCandidates=" + this.getRoundCandidates() + ", nextCandidateDelayMs=" + this.getNextCandidateDelayMs() + ", consensusTimeoutMs=" + this.getConsensusTimeoutMs() + ", fastAttempts=" + this.getFastAttempts() + ", attemptDuration=" + this.getAttemptDuration() + ", catchainNaxDeps=" + this.getCatchainNaxDeps() + ", maxBlockBytes=" + this.getMaxBlockBytes() + ", maxCollatedBytes=" + this.getMaxCollatedBytes() + ", protoVersion=" + this.getProtoVersion() + ", catchainMaxBlocksCoeff=" + this.getCatchainMaxBlocksCoeff() + ")";
    }

    public static class ConsensusConfigV4Builder {
        private int magic;
        private int flags;
        private boolean newCatchainIds;
        private int roundCandidates;
        private long nextCandidateDelayMs;
        private long consensusTimeoutMs;
        private long fastAttempts;
        private long attemptDuration;
        private long catchainNaxDeps;
        private long maxBlockBytes;
        private long maxCollatedBytes;
        private int protoVersion;
        private long catchainMaxBlocksCoeff;

        ConsensusConfigV4Builder() {
        }

        public ConsensusConfigV4Builder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public ConsensusConfigV4Builder flags(int flags) {
            this.flags = flags;
            return this;
        }

        public ConsensusConfigV4Builder newCatchainIds(boolean newCatchainIds) {
            this.newCatchainIds = newCatchainIds;
            return this;
        }

        public ConsensusConfigV4Builder roundCandidates(int roundCandidates) {
            this.roundCandidates = roundCandidates;
            return this;
        }

        public ConsensusConfigV4Builder nextCandidateDelayMs(long nextCandidateDelayMs) {
            this.nextCandidateDelayMs = nextCandidateDelayMs;
            return this;
        }

        public ConsensusConfigV4Builder consensusTimeoutMs(long consensusTimeoutMs) {
            this.consensusTimeoutMs = consensusTimeoutMs;
            return this;
        }

        public ConsensusConfigV4Builder fastAttempts(long fastAttempts) {
            this.fastAttempts = fastAttempts;
            return this;
        }

        public ConsensusConfigV4Builder attemptDuration(long attemptDuration) {
            this.attemptDuration = attemptDuration;
            return this;
        }

        public ConsensusConfigV4Builder catchainNaxDeps(long catchainNaxDeps) {
            this.catchainNaxDeps = catchainNaxDeps;
            return this;
        }

        public ConsensusConfigV4Builder maxBlockBytes(long maxBlockBytes) {
            this.maxBlockBytes = maxBlockBytes;
            return this;
        }

        public ConsensusConfigV4Builder maxCollatedBytes(long maxCollatedBytes) {
            this.maxCollatedBytes = maxCollatedBytes;
            return this;
        }

        public ConsensusConfigV4Builder protoVersion(int protoVersion) {
            this.protoVersion = protoVersion;
            return this;
        }

        public ConsensusConfigV4Builder catchainMaxBlocksCoeff(long catchainMaxBlocksCoeff) {
            this.catchainMaxBlocksCoeff = catchainMaxBlocksCoeff;
            return this;
        }

        public ConsensusConfigV4 build() {
            return new ConsensusConfigV4(this.magic, this.flags, this.newCatchainIds, this.roundCandidates, this.nextCandidateDelayMs, this.consensusTimeoutMs, this.fastAttempts, this.attemptDuration, this.catchainNaxDeps, this.maxBlockBytes, this.maxCollatedBytes, this.protoVersion, this.catchainMaxBlocksCoeff);
        }

        public String toString() {
            return "ConsensusConfigV4.ConsensusConfigV4Builder(magic=" + this.magic + ", flags=" + this.flags + ", newCatchainIds=" + this.newCatchainIds + ", roundCandidates=" + this.roundCandidates + ", nextCandidateDelayMs=" + this.nextCandidateDelayMs + ", consensusTimeoutMs=" + this.consensusTimeoutMs + ", fastAttempts=" + this.fastAttempts + ", attemptDuration=" + this.attemptDuration + ", catchainNaxDeps=" + this.catchainNaxDeps + ", maxBlockBytes=" + this.maxBlockBytes + ", maxCollatedBytes=" + this.maxCollatedBytes + ", protoVersion=" + this.protoVersion + ", catchainMaxBlocksCoeff=" + this.catchainMaxBlocksCoeff + ")";
        }
    }
}

