/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;

public class ConfigParams5
implements Serializable {
    long magic;
    BigInteger blackholeAddr;
    long feeBurnNum;
    long feeBurnDenom;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(1, 8).storeBit(Boolean.valueOf(true)).storeUint(this.blackholeAddr, 256).storeUint(this.feeBurnNum, 32).storeUint(this.feeBurnDenom, 32).endCell();
    }

    public static ConfigParams5 deserialize(CellSlice cs) {
        return ConfigParams5.builder().magic(cs.loadUint(8).longValue()).blackholeAddr(cs.loadBit() ? cs.loadUint(256) : null).feeBurnNum(cs.loadUint(32).longValue()).feeBurnDenom(cs.loadUint(32).longValue()).build();
    }

    ConfigParams5(long magic, BigInteger blackholeAddr, long feeBurnNum, long feeBurnDenom) {
        this.magic = magic;
        this.blackholeAddr = blackholeAddr;
        this.feeBurnNum = feeBurnNum;
        this.feeBurnDenom = feeBurnDenom;
    }

    public static ConfigParams5Builder builder() {
        return new ConfigParams5Builder();
    }

    public long getMagic() {
        return this.magic;
    }

    public BigInteger getBlackholeAddr() {
        return this.blackholeAddr;
    }

    public long getFeeBurnNum() {
        return this.feeBurnNum;
    }

    public long getFeeBurnDenom() {
        return this.feeBurnDenom;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setBlackholeAddr(BigInteger blackholeAddr) {
        this.blackholeAddr = blackholeAddr;
    }

    public void setFeeBurnNum(long feeBurnNum) {
        this.feeBurnNum = feeBurnNum;
    }

    public void setFeeBurnDenom(long feeBurnDenom) {
        this.feeBurnDenom = feeBurnDenom;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigParams5)) {
            return false;
        }
        ConfigParams5 other = (ConfigParams5)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        if (this.getFeeBurnNum() != other.getFeeBurnNum()) {
            return false;
        }
        if (this.getFeeBurnDenom() != other.getFeeBurnDenom()) {
            return false;
        }
        BigInteger this$blackholeAddr = this.getBlackholeAddr();
        BigInteger other$blackholeAddr = other.getBlackholeAddr();
        return !(this$blackholeAddr == null ? other$blackholeAddr != null : !((Object)this$blackholeAddr).equals(other$blackholeAddr));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigParams5;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $magic = this.getMagic();
        result = result * 59 + (int)($magic >>> 32 ^ $magic);
        long $feeBurnNum = this.getFeeBurnNum();
        result = result * 59 + (int)($feeBurnNum >>> 32 ^ $feeBurnNum);
        long $feeBurnDenom = this.getFeeBurnDenom();
        result = result * 59 + (int)($feeBurnDenom >>> 32 ^ $feeBurnDenom);
        BigInteger $blackholeAddr = this.getBlackholeAddr();
        result = result * 59 + ($blackholeAddr == null ? 43 : ((Object)$blackholeAddr).hashCode());
        return result;
    }

    public String toString() {
        return "ConfigParams5(magic=" + this.getMagic() + ", blackholeAddr=" + String.valueOf(this.getBlackholeAddr()) + ", feeBurnNum=" + this.getFeeBurnNum() + ", feeBurnDenom=" + this.getFeeBurnDenom() + ")";
    }

    public static class ConfigParams5Builder {
        private long magic;
        private BigInteger blackholeAddr;
        private long feeBurnNum;
        private long feeBurnDenom;

        ConfigParams5Builder() {
        }

        public ConfigParams5Builder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public ConfigParams5Builder blackholeAddr(BigInteger blackholeAddr) {
            this.blackholeAddr = blackholeAddr;
            return this;
        }

        public ConfigParams5Builder feeBurnNum(long feeBurnNum) {
            this.feeBurnNum = feeBurnNum;
            return this;
        }

        public ConfigParams5Builder feeBurnDenom(long feeBurnDenom) {
            this.feeBurnDenom = feeBurnDenom;
            return this;
        }

        public ConfigParams5 build() {
            return new ConfigParams5(this.magic, this.blackholeAddr, this.feeBurnNum, this.feeBurnDenom);
        }

        public String toString() {
            return "ConfigParams5.ConfigParams5Builder(magic=" + this.magic + ", blackholeAddr=" + String.valueOf(this.blackholeAddr) + ", feeBurnNum=" + this.feeBurnNum + ", feeBurnDenom=" + this.feeBurnDenom + ")";
        }
    }
}

