/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;

public class ConfigParams14
implements Serializable {
    long magic;
    BigInteger masterchainBlockFee;
    BigInteger basechainBlockFee;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(107, 8).storeCoins(this.masterchainBlockFee).storeCoins(this.basechainBlockFee).endCell();
    }

    public static ConfigParams14 deserialize(CellSlice cs) {
        return ConfigParams14.builder().magic(cs.loadUint(8).longValue()).masterchainBlockFee(cs.loadCoins()).basechainBlockFee(cs.loadCoins()).build();
    }

    ConfigParams14(long magic, BigInteger masterchainBlockFee, BigInteger basechainBlockFee) {
        this.magic = magic;
        this.masterchainBlockFee = masterchainBlockFee;
        this.basechainBlockFee = basechainBlockFee;
    }

    public static ConfigParams14Builder builder() {
        return new ConfigParams14Builder();
    }

    public long getMagic() {
        return this.magic;
    }

    public BigInteger getMasterchainBlockFee() {
        return this.masterchainBlockFee;
    }

    public BigInteger getBasechainBlockFee() {
        return this.basechainBlockFee;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setMasterchainBlockFee(BigInteger masterchainBlockFee) {
        this.masterchainBlockFee = masterchainBlockFee;
    }

    public void setBasechainBlockFee(BigInteger basechainBlockFee) {
        this.basechainBlockFee = basechainBlockFee;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigParams14)) {
            return false;
        }
        ConfigParams14 other = (ConfigParams14)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        BigInteger this$masterchainBlockFee = this.getMasterchainBlockFee();
        BigInteger other$masterchainBlockFee = other.getMasterchainBlockFee();
        if (this$masterchainBlockFee == null ? other$masterchainBlockFee != null : !((Object)this$masterchainBlockFee).equals(other$masterchainBlockFee)) {
            return false;
        }
        BigInteger this$basechainBlockFee = this.getBasechainBlockFee();
        BigInteger other$basechainBlockFee = other.getBasechainBlockFee();
        return !(this$basechainBlockFee == null ? other$basechainBlockFee != null : !((Object)this$basechainBlockFee).equals(other$basechainBlockFee));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigParams14;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $magic = this.getMagic();
        result = result * 59 + (int)($magic >>> 32 ^ $magic);
        BigInteger $masterchainBlockFee = this.getMasterchainBlockFee();
        result = result * 59 + ($masterchainBlockFee == null ? 43 : ((Object)$masterchainBlockFee).hashCode());
        BigInteger $basechainBlockFee = this.getBasechainBlockFee();
        result = result * 59 + ($basechainBlockFee == null ? 43 : ((Object)$basechainBlockFee).hashCode());
        return result;
    }

    public String toString() {
        return "ConfigParams14(magic=" + this.getMagic() + ", masterchainBlockFee=" + String.valueOf(this.getMasterchainBlockFee()) + ", basechainBlockFee=" + String.valueOf(this.getBasechainBlockFee()) + ")";
    }

    public static class ConfigParams14Builder {
        private long magic;
        private BigInteger masterchainBlockFee;
        private BigInteger basechainBlockFee;

        ConfigParams14Builder() {
        }

        public ConfigParams14Builder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public ConfigParams14Builder masterchainBlockFee(BigInteger masterchainBlockFee) {
            this.masterchainBlockFee = masterchainBlockFee;
            return this;
        }

        public ConfigParams14Builder basechainBlockFee(BigInteger basechainBlockFee) {
            this.basechainBlockFee = basechainBlockFee;
            return this;
        }

        public ConfigParams14 build() {
            return new ConfigParams14(this.magic, this.masterchainBlockFee, this.basechainBlockFee);
        }

        public String toString() {
            return "ConfigParams14.ConfigParams14Builder(magic=" + this.magic + ", masterchainBlockFee=" + String.valueOf(this.masterchainBlockFee) + ", basechainBlockFee=" + String.valueOf(this.basechainBlockFee) + ")";
        }
    }
}

