/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;

public class ConfigParams13
implements Serializable {
    long magic;
    BigInteger deposit;
    BigInteger bitPrice;
    BigInteger cellPrice;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(26, 8).storeCoins(this.deposit).storeCoins(this.bitPrice).storeCoins(this.cellPrice).endCell();
    }

    public static ConfigParams13 deserialize(CellSlice cs) {
        return ConfigParams13.builder().magic(cs.loadUint(8).longValue()).deposit(cs.loadCoins()).bitPrice(cs.loadCoins()).cellPrice(cs.loadCoins()).build();
    }

    ConfigParams13(long magic, BigInteger deposit, BigInteger bitPrice, BigInteger cellPrice) {
        this.magic = magic;
        this.deposit = deposit;
        this.bitPrice = bitPrice;
        this.cellPrice = cellPrice;
    }

    public static ConfigParams13Builder builder() {
        return new ConfigParams13Builder();
    }

    public long getMagic() {
        return this.magic;
    }

    public BigInteger getDeposit() {
        return this.deposit;
    }

    public BigInteger getBitPrice() {
        return this.bitPrice;
    }

    public BigInteger getCellPrice() {
        return this.cellPrice;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setDeposit(BigInteger deposit) {
        this.deposit = deposit;
    }

    public void setBitPrice(BigInteger bitPrice) {
        this.bitPrice = bitPrice;
    }

    public void setCellPrice(BigInteger cellPrice) {
        this.cellPrice = cellPrice;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigParams13)) {
            return false;
        }
        ConfigParams13 other = (ConfigParams13)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        BigInteger this$deposit = this.getDeposit();
        BigInteger other$deposit = other.getDeposit();
        if (this$deposit == null ? other$deposit != null : !((Object)this$deposit).equals(other$deposit)) {
            return false;
        }
        BigInteger this$bitPrice = this.getBitPrice();
        BigInteger other$bitPrice = other.getBitPrice();
        if (this$bitPrice == null ? other$bitPrice != null : !((Object)this$bitPrice).equals(other$bitPrice)) {
            return false;
        }
        BigInteger this$cellPrice = this.getCellPrice();
        BigInteger other$cellPrice = other.getCellPrice();
        return !(this$cellPrice == null ? other$cellPrice != null : !((Object)this$cellPrice).equals(other$cellPrice));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigParams13;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $magic = this.getMagic();
        result = result * 59 + (int)($magic >>> 32 ^ $magic);
        BigInteger $deposit = this.getDeposit();
        result = result * 59 + ($deposit == null ? 43 : ((Object)$deposit).hashCode());
        BigInteger $bitPrice = this.getBitPrice();
        result = result * 59 + ($bitPrice == null ? 43 : ((Object)$bitPrice).hashCode());
        BigInteger $cellPrice = this.getCellPrice();
        result = result * 59 + ($cellPrice == null ? 43 : ((Object)$cellPrice).hashCode());
        return result;
    }

    public String toString() {
        return "ConfigParams13(magic=" + this.getMagic() + ", deposit=" + String.valueOf(this.getDeposit()) + ", bitPrice=" + String.valueOf(this.getBitPrice()) + ", cellPrice=" + String.valueOf(this.getCellPrice()) + ")";
    }

    public static class ConfigParams13Builder {
        private long magic;
        private BigInteger deposit;
        private BigInteger bitPrice;
        private BigInteger cellPrice;

        ConfigParams13Builder() {
        }

        public ConfigParams13Builder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public ConfigParams13Builder deposit(BigInteger deposit) {
            this.deposit = deposit;
            return this;
        }

        public ConfigParams13Builder bitPrice(BigInteger bitPrice) {
            this.bitPrice = bitPrice;
            return this;
        }

        public ConfigParams13Builder cellPrice(BigInteger cellPrice) {
            this.cellPrice = cellPrice;
            return this;
        }

        public ConfigParams13 build() {
            return new ConfigParams13(this.magic, this.deposit, this.bitPrice, this.cellPrice);
        }

        public String toString() {
            return "ConfigParams13.ConfigParams13Builder(magic=" + this.magic + ", deposit=" + String.valueOf(this.deposit) + ", bitPrice=" + String.valueOf(this.bitPrice) + ", cellPrice=" + String.valueOf(this.cellPrice) + ")";
        }
    }
}

