/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.cell.TonHashMap;

public class ConfigParams
implements Serializable {
    Address configAddr;
    TonHashMap config;

    public Cell toCell() {
        return CellBuilder.beginCell().storeAddress(this.configAddr).storeDict(this.config.serialize(k -> CellBuilder.beginCell().storeUint((BigInteger)k, 32).endCell().getBits(), v -> CellBuilder.beginCell().storeRef((Cell)v).endCell())).endCell();
    }

    public static ConfigParams deserialize(CellSlice cs) {
        return ConfigParams.builder().configAddr(Address.of((byte[])cs.loadBits(256).toByteArray())).config(CellSlice.beginParse((Cell)cs.loadRef()).loadDict(32, k -> k.readUint(32), v -> v)).build();
    }

    ConfigParams(Address configAddr, TonHashMap config) {
        this.configAddr = configAddr;
        this.config = config;
    }

    public static ConfigParamsBuilder builder() {
        return new ConfigParamsBuilder();
    }

    public Address getConfigAddr() {
        return this.configAddr;
    }

    public TonHashMap getConfig() {
        return this.config;
    }

    public void setConfigAddr(Address configAddr) {
        this.configAddr = configAddr;
    }

    public void setConfig(TonHashMap config) {
        this.config = config;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigParams)) {
            return false;
        }
        ConfigParams other = (ConfigParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Address this$configAddr = this.getConfigAddr();
        Address other$configAddr = other.getConfigAddr();
        if (this$configAddr == null ? other$configAddr != null : !this$configAddr.equals(other$configAddr)) {
            return false;
        }
        TonHashMap this$config = this.getConfig();
        TonHashMap other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !this$config.equals(other$config));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Address $configAddr = this.getConfigAddr();
        result = result * 59 + ($configAddr == null ? 43 : $configAddr.hashCode());
        TonHashMap $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        return result;
    }

    public String toString() {
        return "ConfigParams(configAddr=" + String.valueOf(this.getConfigAddr()) + ", config=" + String.valueOf(this.getConfig()) + ")";
    }

    public static class ConfigParamsBuilder {
        private Address configAddr;
        private TonHashMap config;

        ConfigParamsBuilder() {
        }

        public ConfigParamsBuilder configAddr(Address configAddr) {
            this.configAddr = configAddr;
            return this;
        }

        public ConfigParamsBuilder config(TonHashMap config) {
            this.config = config;
            return this;
        }

        public ConfigParams build() {
            return new ConfigParams(this.configAddr, this.config);
        }

        public String toString() {
            return "ConfigParams.ConfigParamsBuilder(configAddr=" + String.valueOf(this.configAddr) + ", config=" + String.valueOf(this.config) + ")";
        }
    }
}

