/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.ComputePhase;
import org.ton.java.tlb.ComputePhaseVMDetails;

public class ComputePhaseVM
implements ComputePhase,
Serializable {
    int magic;
    boolean success;
    boolean msgStateUsed;
    boolean accountActivated;
    BigInteger gasFees;
    ComputePhaseVMDetails details;

    private String getMagic() {
        return Integer.toHexString(this.magic);
    }

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeBit(Boolean.valueOf(true)).storeBit(Boolean.valueOf(this.success)).storeBit(Boolean.valueOf(this.msgStateUsed)).storeBit(Boolean.valueOf(this.accountActivated)).storeCoins(this.gasFees).storeRef(this.details.toCell()).endCell();
    }

    public static ComputePhase deserialize(CellSlice cs) {
        return ComputePhaseVM.builder().magic(1).success(cs.loadBit()).msgStateUsed(cs.loadBit()).accountActivated(cs.loadBit()).gasFees(cs.loadCoins()).details(ComputePhaseVMDetails.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).build();
    }

    ComputePhaseVM(int magic, boolean success, boolean msgStateUsed, boolean accountActivated, BigInteger gasFees, ComputePhaseVMDetails details) {
        this.magic = magic;
        this.success = success;
        this.msgStateUsed = msgStateUsed;
        this.accountActivated = accountActivated;
        this.gasFees = gasFees;
        this.details = details;
    }

    public static ComputePhaseVMBuilder builder() {
        return new ComputePhaseVMBuilder();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isMsgStateUsed() {
        return this.msgStateUsed;
    }

    public boolean isAccountActivated() {
        return this.accountActivated;
    }

    public BigInteger getGasFees() {
        return this.gasFees;
    }

    public ComputePhaseVMDetails getDetails() {
        return this.details;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setMsgStateUsed(boolean msgStateUsed) {
        this.msgStateUsed = msgStateUsed;
    }

    public void setAccountActivated(boolean accountActivated) {
        this.accountActivated = accountActivated;
    }

    public void setGasFees(BigInteger gasFees) {
        this.gasFees = gasFees;
    }

    public void setDetails(ComputePhaseVMDetails details) {
        this.details = details;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComputePhaseVM)) {
            return false;
        }
        ComputePhaseVM other = (ComputePhaseVM)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$magic = this.getMagic();
        String other$magic = other.getMagic();
        if (this$magic == null ? other$magic != null : !this$magic.equals(other$magic)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (this.isMsgStateUsed() != other.isMsgStateUsed()) {
            return false;
        }
        if (this.isAccountActivated() != other.isAccountActivated()) {
            return false;
        }
        BigInteger this$gasFees = this.getGasFees();
        BigInteger other$gasFees = other.getGasFees();
        if (this$gasFees == null ? other$gasFees != null : !((Object)this$gasFees).equals(other$gasFees)) {
            return false;
        }
        ComputePhaseVMDetails this$details = this.getDetails();
        ComputePhaseVMDetails other$details = other.getDetails();
        return !(this$details == null ? other$details != null : !((Object)this$details).equals(other$details));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ComputePhaseVM;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $magic = this.getMagic();
        result = result * 59 + ($magic == null ? 43 : $magic.hashCode());
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        result = result * 59 + (this.isMsgStateUsed() ? 79 : 97);
        result = result * 59 + (this.isAccountActivated() ? 79 : 97);
        BigInteger $gasFees = this.getGasFees();
        result = result * 59 + ($gasFees == null ? 43 : ((Object)$gasFees).hashCode());
        ComputePhaseVMDetails $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        return result;
    }

    public String toString() {
        return "ComputePhaseVM(magic=" + this.getMagic() + ", success=" + this.isSuccess() + ", msgStateUsed=" + this.isMsgStateUsed() + ", accountActivated=" + this.isAccountActivated() + ", gasFees=" + String.valueOf(this.getGasFees()) + ", details=" + String.valueOf(this.getDetails()) + ")";
    }

    public static class ComputePhaseVMBuilder {
        private int magic;
        private boolean success;
        private boolean msgStateUsed;
        private boolean accountActivated;
        private BigInteger gasFees;
        private ComputePhaseVMDetails details;

        ComputePhaseVMBuilder() {
        }

        public ComputePhaseVMBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public ComputePhaseVMBuilder success(boolean success) {
            this.success = success;
            return this;
        }

        public ComputePhaseVMBuilder msgStateUsed(boolean msgStateUsed) {
            this.msgStateUsed = msgStateUsed;
            return this;
        }

        public ComputePhaseVMBuilder accountActivated(boolean accountActivated) {
            this.accountActivated = accountActivated;
            return this;
        }

        public ComputePhaseVMBuilder gasFees(BigInteger gasFees) {
            this.gasFees = gasFees;
            return this;
        }

        public ComputePhaseVMBuilder details(ComputePhaseVMDetails details) {
            this.details = details;
            return this;
        }

        public ComputePhaseVM build() {
            return new ComputePhaseVM(this.magic, this.success, this.msgStateUsed, this.accountActivated, this.gasFees, this.details);
        }

        public String toString() {
            return "ComputePhaseVM.ComputePhaseVMBuilder(magic=" + this.magic + ", success=" + this.success + ", msgStateUsed=" + this.msgStateUsed + ", accountActivated=" + this.accountActivated + ", gasFees=" + String.valueOf(this.gasFees) + ", details=" + String.valueOf(this.details) + ")";
        }
    }
}

