/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.math.BigInteger;
import java.util.HashMap;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.ExternalMessageInInfo;
import org.ton.java.tlb.ExternalMessageOutInfo;
import org.ton.java.tlb.InternalMessageInfo;

public interface CommonMsgInfo {
    public Cell toCell();

    public static CommonMsgInfo deserialize(CellSlice cs) {
        boolean isExternal = cs.preloadBit();
        if (!isExternal) {
            return InternalMessageInfo.deserialize(cs);
        }
        boolean isOut = cs.preloadBitAt(2);
        if (isOut) {
            return ExternalMessageOutInfo.deserialize(cs);
        }
        return ExternalMessageInInfo.deserialize(cs);
    }

    public String getType();

    public String getSourceAddress();

    public String getDestinationAddress();

    public BigInteger getValueCoins();

    public HashMap getExtraCurrencies();
}

