/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.BouncePhase;
import org.ton.java.tlb.StorageUsed;

public class BouncePhaseNoFounds
implements BouncePhase,
Serializable {
    int magic;
    StorageUsed msgSize;
    BigInteger reqFwdFees;

    private String getMagic() {
        return Integer.toHexString(this.magic);
    }

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(1, 2).storeSlice(CellSlice.beginParse((Cell)this.msgSize.toCell())).storeCoins(this.reqFwdFees).endCell();
    }

    public static BouncePhaseNoFounds deserialize(CellSlice cs) {
        long magic = cs.loadUint(2).intValue();
        assert (magic == 1L) : "BouncePhaseNoFounds: magic not equal to 0b01, found 0x" + Long.toHexString(magic);
        return BouncePhaseNoFounds.builder().msgSize(StorageUsed.deserialize(cs)).reqFwdFees(cs.loadCoins()).build();
    }

    BouncePhaseNoFounds(int magic, StorageUsed msgSize, BigInteger reqFwdFees) {
        this.magic = magic;
        this.msgSize = msgSize;
        this.reqFwdFees = reqFwdFees;
    }

    public static BouncePhaseNoFoundsBuilder builder() {
        return new BouncePhaseNoFoundsBuilder();
    }

    public StorageUsed getMsgSize() {
        return this.msgSize;
    }

    public BigInteger getReqFwdFees() {
        return this.reqFwdFees;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setMsgSize(StorageUsed msgSize) {
        this.msgSize = msgSize;
    }

    public void setReqFwdFees(BigInteger reqFwdFees) {
        this.reqFwdFees = reqFwdFees;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BouncePhaseNoFounds)) {
            return false;
        }
        BouncePhaseNoFounds other = (BouncePhaseNoFounds)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$magic = this.getMagic();
        String other$magic = other.getMagic();
        if (this$magic == null ? other$magic != null : !this$magic.equals(other$magic)) {
            return false;
        }
        StorageUsed this$msgSize = this.getMsgSize();
        StorageUsed other$msgSize = other.getMsgSize();
        if (this$msgSize == null ? other$msgSize != null : !((Object)this$msgSize).equals(other$msgSize)) {
            return false;
        }
        BigInteger this$reqFwdFees = this.getReqFwdFees();
        BigInteger other$reqFwdFees = other.getReqFwdFees();
        return !(this$reqFwdFees == null ? other$reqFwdFees != null : !((Object)this$reqFwdFees).equals(other$reqFwdFees));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BouncePhaseNoFounds;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $magic = this.getMagic();
        result = result * 59 + ($magic == null ? 43 : $magic.hashCode());
        StorageUsed $msgSize = this.getMsgSize();
        result = result * 59 + ($msgSize == null ? 43 : ((Object)$msgSize).hashCode());
        BigInteger $reqFwdFees = this.getReqFwdFees();
        result = result * 59 + ($reqFwdFees == null ? 43 : ((Object)$reqFwdFees).hashCode());
        return result;
    }

    public String toString() {
        return "BouncePhaseNoFounds(magic=" + this.getMagic() + ", msgSize=" + String.valueOf(this.getMsgSize()) + ", reqFwdFees=" + String.valueOf(this.getReqFwdFees()) + ")";
    }

    public static class BouncePhaseNoFoundsBuilder {
        private int magic;
        private StorageUsed msgSize;
        private BigInteger reqFwdFees;

        BouncePhaseNoFoundsBuilder() {
        }

        public BouncePhaseNoFoundsBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public BouncePhaseNoFoundsBuilder msgSize(StorageUsed msgSize) {
            this.msgSize = msgSize;
            return this;
        }

        public BouncePhaseNoFoundsBuilder reqFwdFees(BigInteger reqFwdFees) {
            this.reqFwdFees = reqFwdFees;
            return this;
        }

        public BouncePhaseNoFounds build() {
            return new BouncePhaseNoFounds(this.magic, this.msgSize, this.reqFwdFees);
        }

        public String toString() {
            return "BouncePhaseNoFounds.BouncePhaseNoFoundsBuilder(magic=" + this.magic + ", msgSize=" + String.valueOf(this.msgSize) + ", reqFwdFees=" + String.valueOf(this.reqFwdFees) + ")";
        }
    }
}

