/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.cell.TonHashMapE;
import org.ton.java.tlb.CryptoSignaturePair;

public class BlockSignaturesPure
implements Serializable {
    long sigCount;
    BigInteger sigWeight;
    TonHashMapE signatures;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(this.sigCount, 32).storeUint(this.sigWeight, 64).storeDict(this.signatures.serialize(k -> CellBuilder.beginCell().storeUint((BigInteger)k, 16).endCell().getBits(), v -> CellBuilder.beginCell().storeCell(((CryptoSignaturePair)v).toCell()).endCell())).endCell();
    }

    public static BlockSignaturesPure deserialize(CellSlice cs) {
        return BlockSignaturesPure.builder().sigCount(cs.loadUint(32).longValue()).sigWeight(cs.loadUint(64)).signatures(cs.loadDictE(16, k -> k.readUint(16), v -> CryptoSignaturePair.deserialize(CellSlice.beginParse((Cell)v)))).build();
    }

    BlockSignaturesPure(long sigCount, BigInteger sigWeight, TonHashMapE signatures) {
        this.sigCount = sigCount;
        this.sigWeight = sigWeight;
        this.signatures = signatures;
    }

    public static BlockSignaturesPureBuilder builder() {
        return new BlockSignaturesPureBuilder();
    }

    public long getSigCount() {
        return this.sigCount;
    }

    public BigInteger getSigWeight() {
        return this.sigWeight;
    }

    public TonHashMapE getSignatures() {
        return this.signatures;
    }

    public void setSigCount(long sigCount) {
        this.sigCount = sigCount;
    }

    public void setSigWeight(BigInteger sigWeight) {
        this.sigWeight = sigWeight;
    }

    public void setSignatures(TonHashMapE signatures) {
        this.signatures = signatures;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockSignaturesPure)) {
            return false;
        }
        BlockSignaturesPure other = (BlockSignaturesPure)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSigCount() != other.getSigCount()) {
            return false;
        }
        BigInteger this$sigWeight = this.getSigWeight();
        BigInteger other$sigWeight = other.getSigWeight();
        if (this$sigWeight == null ? other$sigWeight != null : !((Object)this$sigWeight).equals(other$sigWeight)) {
            return false;
        }
        TonHashMapE this$signatures = this.getSignatures();
        TonHashMapE other$signatures = other.getSignatures();
        return !(this$signatures == null ? other$signatures != null : !this$signatures.equals(other$signatures));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlockSignaturesPure;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $sigCount = this.getSigCount();
        result = result * 59 + (int)($sigCount >>> 32 ^ $sigCount);
        BigInteger $sigWeight = this.getSigWeight();
        result = result * 59 + ($sigWeight == null ? 43 : ((Object)$sigWeight).hashCode());
        TonHashMapE $signatures = this.getSignatures();
        result = result * 59 + ($signatures == null ? 43 : $signatures.hashCode());
        return result;
    }

    public String toString() {
        return "BlockSignaturesPure(sigCount=" + this.getSigCount() + ", sigWeight=" + String.valueOf(this.getSigWeight()) + ", signatures=" + String.valueOf(this.getSignatures()) + ")";
    }

    public static class BlockSignaturesPureBuilder {
        private long sigCount;
        private BigInteger sigWeight;
        private TonHashMapE signatures;

        BlockSignaturesPureBuilder() {
        }

        public BlockSignaturesPureBuilder sigCount(long sigCount) {
            this.sigCount = sigCount;
            return this;
        }

        public BlockSignaturesPureBuilder sigWeight(BigInteger sigWeight) {
            this.sigWeight = sigWeight;
            return this;
        }

        public BlockSignaturesPureBuilder signatures(TonHashMapE signatures) {
            this.signatures = signatures;
            return this;
        }

        public BlockSignaturesPure build() {
            return new BlockSignaturesPure(this.sigCount, this.sigWeight, this.signatures);
        }

        public String toString() {
            return "BlockSignaturesPure.BlockSignaturesPureBuilder(sigCount=" + this.sigCount + ", sigWeight=" + String.valueOf(this.sigWeight) + ", signatures=" + String.valueOf(this.signatures) + ")";
        }
    }
}

