/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.BlockSignaturesPure;
import org.ton.java.tlb.ValidatorBaseInfo;

public class BlockSignatures
implements Serializable {
    int magic;
    ValidatorBaseInfo validatorBaseInfo;
    BlockSignaturesPure pureSignatures;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(17, 8).storeCell(this.validatorBaseInfo.toCell()).storeCell(this.pureSignatures.toCell()).endCell();
    }

    public static BlockSignatures deserialize(CellSlice cs) {
        long magic = cs.loadUint(8).longValue();
        assert (magic == 17L) : "BlockSignatures: magic not equal to 0x11, found 0x" + Long.toHexString(magic);
        return BlockSignatures.builder().magic(3).validatorBaseInfo(ValidatorBaseInfo.deserialize(cs)).pureSignatures(BlockSignaturesPure.deserialize(cs)).build();
    }

    BlockSignatures(int magic, ValidatorBaseInfo validatorBaseInfo, BlockSignaturesPure pureSignatures) {
        this.magic = magic;
        this.validatorBaseInfo = validatorBaseInfo;
        this.pureSignatures = pureSignatures;
    }

    public static BlockSignaturesBuilder builder() {
        return new BlockSignaturesBuilder();
    }

    public int getMagic() {
        return this.magic;
    }

    public ValidatorBaseInfo getValidatorBaseInfo() {
        return this.validatorBaseInfo;
    }

    public BlockSignaturesPure getPureSignatures() {
        return this.pureSignatures;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setValidatorBaseInfo(ValidatorBaseInfo validatorBaseInfo) {
        this.validatorBaseInfo = validatorBaseInfo;
    }

    public void setPureSignatures(BlockSignaturesPure pureSignatures) {
        this.pureSignatures = pureSignatures;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockSignatures)) {
            return false;
        }
        BlockSignatures other = (BlockSignatures)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        ValidatorBaseInfo this$validatorBaseInfo = this.getValidatorBaseInfo();
        ValidatorBaseInfo other$validatorBaseInfo = other.getValidatorBaseInfo();
        if (this$validatorBaseInfo == null ? other$validatorBaseInfo != null : !((Object)this$validatorBaseInfo).equals(other$validatorBaseInfo)) {
            return false;
        }
        BlockSignaturesPure this$pureSignatures = this.getPureSignatures();
        BlockSignaturesPure other$pureSignatures = other.getPureSignatures();
        return !(this$pureSignatures == null ? other$pureSignatures != null : !((Object)this$pureSignatures).equals(other$pureSignatures));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlockSignatures;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        ValidatorBaseInfo $validatorBaseInfo = this.getValidatorBaseInfo();
        result = result * 59 + ($validatorBaseInfo == null ? 43 : ((Object)$validatorBaseInfo).hashCode());
        BlockSignaturesPure $pureSignatures = this.getPureSignatures();
        result = result * 59 + ($pureSignatures == null ? 43 : ((Object)$pureSignatures).hashCode());
        return result;
    }

    public String toString() {
        return "BlockSignatures(magic=" + this.getMagic() + ", validatorBaseInfo=" + String.valueOf(this.getValidatorBaseInfo()) + ", pureSignatures=" + String.valueOf(this.getPureSignatures()) + ")";
    }

    public static class BlockSignaturesBuilder {
        private int magic;
        private ValidatorBaseInfo validatorBaseInfo;
        private BlockSignaturesPure pureSignatures;

        BlockSignaturesBuilder() {
        }

        public BlockSignaturesBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public BlockSignaturesBuilder validatorBaseInfo(ValidatorBaseInfo validatorBaseInfo) {
            this.validatorBaseInfo = validatorBaseInfo;
            return this;
        }

        public BlockSignaturesBuilder pureSignatures(BlockSignaturesPure pureSignatures) {
            this.pureSignatures = pureSignatures;
            return this;
        }

        public BlockSignatures build() {
            return new BlockSignatures(this.magic, this.validatorBaseInfo, this.pureSignatures);
        }

        public String toString() {
            return "BlockSignatures.BlockSignaturesBuilder(magic=" + this.magic + ", validatorBaseInfo=" + String.valueOf(this.validatorBaseInfo) + ", pureSignatures=" + String.valueOf(this.pureSignatures) + ")";
        }
    }
}

