/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.ShardIdent;

public class BlockIdExtShardIdent
implements Serializable {
    ShardIdent shardId;
    long seqno;
    public BigInteger rootHash;
    public BigInteger fileHash;

    public String getRootHash() {
        return this.rootHash.toString(16);
    }

    public String getFileHash() {
        return this.fileHash.toString(16);
    }

    public Cell toCell() {
        return CellBuilder.beginCell().storeCell(this.shardId.toCell()).storeUint(this.seqno, 32).storeUint(this.rootHash, 256).storeUint(this.fileHash, 256).endCell();
    }

    public static BlockIdExtShardIdent deserialize(CellSlice cs) {
        return BlockIdExtShardIdent.builder().shardId(ShardIdent.deserialize(cs)).seqno(cs.loadUint(32).longValue()).rootHash(cs.loadUint(256)).fileHash(cs.loadUint(256)).build();
    }

    BlockIdExtShardIdent(ShardIdent shardId, long seqno, BigInteger rootHash, BigInteger fileHash) {
        this.shardId = shardId;
        this.seqno = seqno;
        this.rootHash = rootHash;
        this.fileHash = fileHash;
    }

    public static BlockIdExtShardIdentBuilder builder() {
        return new BlockIdExtShardIdentBuilder();
    }

    public ShardIdent getShardId() {
        return this.shardId;
    }

    public long getSeqno() {
        return this.seqno;
    }

    public void setShardId(ShardIdent shardId) {
        this.shardId = shardId;
    }

    public void setSeqno(long seqno) {
        this.seqno = seqno;
    }

    public void setRootHash(BigInteger rootHash) {
        this.rootHash = rootHash;
    }

    public void setFileHash(BigInteger fileHash) {
        this.fileHash = fileHash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockIdExtShardIdent)) {
            return false;
        }
        BlockIdExtShardIdent other = (BlockIdExtShardIdent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSeqno() != other.getSeqno()) {
            return false;
        }
        ShardIdent this$shardId = this.getShardId();
        ShardIdent other$shardId = other.getShardId();
        if (this$shardId == null ? other$shardId != null : !((Object)this$shardId).equals(other$shardId)) {
            return false;
        }
        String this$rootHash = this.getRootHash();
        String other$rootHash = other.getRootHash();
        if (this$rootHash == null ? other$rootHash != null : !this$rootHash.equals(other$rootHash)) {
            return false;
        }
        String this$fileHash = this.getFileHash();
        String other$fileHash = other.getFileHash();
        return !(this$fileHash == null ? other$fileHash != null : !this$fileHash.equals(other$fileHash));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlockIdExtShardIdent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $seqno = this.getSeqno();
        result = result * 59 + (int)($seqno >>> 32 ^ $seqno);
        ShardIdent $shardId = this.getShardId();
        result = result * 59 + ($shardId == null ? 43 : ((Object)$shardId).hashCode());
        String $rootHash = this.getRootHash();
        result = result * 59 + ($rootHash == null ? 43 : $rootHash.hashCode());
        String $fileHash = this.getFileHash();
        result = result * 59 + ($fileHash == null ? 43 : $fileHash.hashCode());
        return result;
    }

    public String toString() {
        return "BlockIdExtShardIdent(shardId=" + String.valueOf(this.getShardId()) + ", seqno=" + this.getSeqno() + ", rootHash=" + this.getRootHash() + ", fileHash=" + this.getFileHash() + ")";
    }

    public static class BlockIdExtShardIdentBuilder {
        private ShardIdent shardId;
        private long seqno;
        private BigInteger rootHash;
        private BigInteger fileHash;

        BlockIdExtShardIdentBuilder() {
        }

        public BlockIdExtShardIdentBuilder shardId(ShardIdent shardId) {
            this.shardId = shardId;
            return this;
        }

        public BlockIdExtShardIdentBuilder seqno(long seqno) {
            this.seqno = seqno;
            return this;
        }

        public BlockIdExtShardIdentBuilder rootHash(BigInteger rootHash) {
            this.rootHash = rootHash;
            return this;
        }

        public BlockIdExtShardIdentBuilder fileHash(BigInteger fileHash) {
            this.fileHash = fileHash;
            return this;
        }

        public BlockIdExtShardIdent build() {
            return new BlockIdExtShardIdent(this.shardId, this.seqno, this.rootHash, this.fileHash);
        }

        public String toString() {
            return "BlockIdExtShardIdent.BlockIdExtShardIdentBuilder(shardId=" + String.valueOf(this.shardId) + ", seqno=" + this.seqno + ", rootHash=" + String.valueOf(this.rootHash) + ", fileHash=" + String.valueOf(this.fileHash) + ")";
        }
    }
}

