/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;

public class BlockIdExt
implements Serializable {
    int workchain;
    long shard;
    long seqno;
    BigInteger rootHash;
    BigInteger fileHash;

    private String getRootHash() {
        return this.rootHash.toString(16);
    }

    private String getFileHash() {
        return this.fileHash.toString(16);
    }

    public String getShard() {
        return Long.toHexString(this.shard);
    }

    public Cell toCell() {
        return CellBuilder.beginCell().storeInt(this.workchain, 32).storeUint(this.shard, 64).storeUint(this.seqno, 32).storeUint(this.rootHash, 256).storeUint(this.fileHash, 256).endCell();
    }

    public static BlockIdExt deserialize(CellSlice cs) {
        return BlockIdExt.builder().workchain(cs.loadInt(32).intValue()).shard(cs.loadUint(64).longValue()).seqno(cs.loadUint(32).longValue()).rootHash(cs.loadUint(256)).fileHash(cs.loadUint(256)).build();
    }

    BlockIdExt(int workchain, long shard, long seqno, BigInteger rootHash, BigInteger fileHash) {
        this.workchain = workchain;
        this.shard = shard;
        this.seqno = seqno;
        this.rootHash = rootHash;
        this.fileHash = fileHash;
    }

    public static BlockIdExtBuilder builder() {
        return new BlockIdExtBuilder();
    }

    public int getWorkchain() {
        return this.workchain;
    }

    public long getSeqno() {
        return this.seqno;
    }

    public void setWorkchain(int workchain) {
        this.workchain = workchain;
    }

    public void setShard(long shard) {
        this.shard = shard;
    }

    public void setSeqno(long seqno) {
        this.seqno = seqno;
    }

    public void setRootHash(BigInteger rootHash) {
        this.rootHash = rootHash;
    }

    public void setFileHash(BigInteger fileHash) {
        this.fileHash = fileHash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockIdExt)) {
            return false;
        }
        BlockIdExt other = (BlockIdExt)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWorkchain() != other.getWorkchain()) {
            return false;
        }
        String this$shard = this.getShard();
        String other$shard = other.getShard();
        if (this$shard == null ? other$shard != null : !this$shard.equals(other$shard)) {
            return false;
        }
        if (this.getSeqno() != other.getSeqno()) {
            return false;
        }
        String this$rootHash = this.getRootHash();
        String other$rootHash = other.getRootHash();
        if (this$rootHash == null ? other$rootHash != null : !this$rootHash.equals(other$rootHash)) {
            return false;
        }
        String this$fileHash = this.getFileHash();
        String other$fileHash = other.getFileHash();
        return !(this$fileHash == null ? other$fileHash != null : !this$fileHash.equals(other$fileHash));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlockIdExt;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWorkchain();
        String $shard = this.getShard();
        result = result * 59 + ($shard == null ? 43 : $shard.hashCode());
        long $seqno = this.getSeqno();
        result = result * 59 + (int)($seqno >>> 32 ^ $seqno);
        String $rootHash = this.getRootHash();
        result = result * 59 + ($rootHash == null ? 43 : $rootHash.hashCode());
        String $fileHash = this.getFileHash();
        result = result * 59 + ($fileHash == null ? 43 : $fileHash.hashCode());
        return result;
    }

    public String toString() {
        return "BlockIdExt(workchain=" + this.getWorkchain() + ", shard=" + this.getShard() + ", seqno=" + this.getSeqno() + ", rootHash=" + this.getRootHash() + ", fileHash=" + this.getFileHash() + ")";
    }

    public static class BlockIdExtBuilder {
        private int workchain;
        private long shard;
        private long seqno;
        private BigInteger rootHash;
        private BigInteger fileHash;

        BlockIdExtBuilder() {
        }

        public BlockIdExtBuilder workchain(int workchain) {
            this.workchain = workchain;
            return this;
        }

        public BlockIdExtBuilder shard(long shard) {
            this.shard = shard;
            return this;
        }

        public BlockIdExtBuilder seqno(long seqno) {
            this.seqno = seqno;
            return this;
        }

        public BlockIdExtBuilder rootHash(BigInteger rootHash) {
            this.rootHash = rootHash;
            return this;
        }

        public BlockIdExtBuilder fileHash(BigInteger fileHash) {
            this.fileHash = fileHash;
            return this;
        }

        public BlockIdExt build() {
            return new BlockIdExt(this.workchain, this.shard, this.seqno, this.rootHash, this.fileHash);
        }

        public String toString() {
            return "BlockIdExt.BlockIdExtBuilder(workchain=" + this.workchain + ", shard=" + this.shard + ", seqno=" + this.seqno + ", rootHash=" + String.valueOf(this.rootHash) + ", fileHash=" + String.valueOf(this.fileHash) + ")";
        }
    }
}

