/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.CellSlice;

public class BlockHandle
implements Serializable {
    BigInteger offset;
    BigInteger size;

    public static BlockHandle deserialize(CellSlice cs) {
        return BlockHandle.builder().offset(cs.loadUint(64)).size(cs.loadUint(64)).build();
    }

    BlockHandle(BigInteger offset, BigInteger size) {
        this.offset = offset;
        this.size = size;
    }

    public static BlockHandleBuilder builder() {
        return new BlockHandleBuilder();
    }

    public BigInteger getOffset() {
        return this.offset;
    }

    public BigInteger getSize() {
        return this.size;
    }

    public void setOffset(BigInteger offset) {
        this.offset = offset;
    }

    public void setSize(BigInteger size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockHandle)) {
            return false;
        }
        BlockHandle other = (BlockHandle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigInteger this$offset = this.getOffset();
        BigInteger other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        BigInteger this$size = this.getSize();
        BigInteger other$size = other.getSize();
        return !(this$size == null ? other$size != null : !((Object)this$size).equals(other$size));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlockHandle;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        BigInteger $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        return result;
    }

    public String toString() {
        return "BlockHandle(offset=" + String.valueOf(this.getOffset()) + ", size=" + String.valueOf(this.getSize()) + ")";
    }

    public static class BlockHandleBuilder {
        private BigInteger offset;
        private BigInteger size;

        BlockHandleBuilder() {
        }

        public BlockHandleBuilder offset(BigInteger offset) {
            this.offset = offset;
            return this;
        }

        public BlockHandleBuilder size(BigInteger size) {
            this.size = size;
            return this;
        }

        public BlockHandle build() {
            return new BlockHandle(this.offset, this.size);
        }

        public String toString() {
            return "BlockHandle.BlockHandleBuilder(offset=" + String.valueOf(this.offset) + ", size=" + String.valueOf(this.size) + ")";
        }
    }
}

