/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.BlockExtra;
import org.ton.java.tlb.BlockInfo;
import org.ton.java.tlb.InMsg;
import org.ton.java.tlb.InMsgImportExt;
import org.ton.java.tlb.InMsgImportFin;
import org.ton.java.tlb.InMsgImportIhr;
import org.ton.java.tlb.InMsgImportImm;
import org.ton.java.tlb.MerkleUpdate;
import org.ton.java.tlb.OutMsg;
import org.ton.java.tlb.OutMsgExt;
import org.ton.java.tlb.OutMsgImm;
import org.ton.java.tlb.OutMsgNew;
import org.ton.java.tlb.Transaction;
import org.ton.java.tlb.ValueFlow;

public class Block
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Block.class);
    long magic;
    int globalId;
    BlockInfo blockInfo;
    ValueFlow valueFlow;
    MerkleUpdate stateUpdate;
    BlockExtra extra;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(300897706, 32).storeInt(this.globalId, 32).storeRef(this.blockInfo.toCell()).storeRef(this.valueFlow.toCell()).storeRef(this.stateUpdate.toCell()).storeRef(this.extra.toCell()).endCell();
    }

    public static Block deserialize(CellSlice cs) {
        long magic = cs.loadUint(32).longValue();
        assert (magic == 300897706L) : "Block: magic not equal to 0x11ef55aa, found 0x" + Long.toHexString(magic);
        Block block = Block.builder().magic(300897706L).globalId(cs.loadInt(32).intValue()).blockInfo(BlockInfo.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).build();
        block.setValueFlow(ValueFlow.deserialize(CellSlice.beginParse((Cell)cs.loadRef())));
        MerkleUpdate merkleUpdate = MerkleUpdate.deserialize(CellSlice.beginParse((Cell)cs.loadRef()));
        block.setStateUpdate(merkleUpdate);
        block.setExtra(BlockExtra.deserialize(CellSlice.beginParse((Cell)cs.loadRef())));
        return block;
    }

    public List<Transaction> getAllTransactions() {
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        Block block = this;
        List<OutMsg> outMsgs = block.getExtra().getOutMsgDesc().getOutMessages();
        for (OutMsg outMsg : outMsgs) {
            if (outMsg instanceof OutMsgExt) {
                result.add(((OutMsgExt)outMsg).getTransaction());
            }
            if (outMsg instanceof OutMsgImm) {
                result.add(((OutMsgImm)outMsg).getTransaction());
            }
            if (outMsg instanceof OutMsgNew) {
                result.add(((OutMsgNew)outMsg).getTransaction());
            }
            if (!(outMsg instanceof OutMsgNew)) continue;
            result.add(((OutMsgNew)outMsg).getTransaction());
        }
        List<InMsg> inMsgs = block.getExtra().getInMsgDesc().getInMessages();
        for (InMsg inMsg : inMsgs) {
            if (inMsg instanceof InMsgImportExt) {
                result.add(((InMsgImportExt)inMsg).getTransaction());
            }
            if (inMsg instanceof InMsgImportIhr) {
                result.add(((InMsgImportIhr)inMsg).getTransaction());
            }
            if (inMsg instanceof InMsgImportImm) {
                result.add(((InMsgImportImm)inMsg).getTransaction());
            }
            if (!(inMsg instanceof InMsgImportFin)) continue;
            result.add(((InMsgImportFin)inMsg).getTransaction());
        }
        return result;
    }

    Block(long magic, int globalId, BlockInfo blockInfo, ValueFlow valueFlow, MerkleUpdate stateUpdate, BlockExtra extra) {
        this.magic = magic;
        this.globalId = globalId;
        this.blockInfo = blockInfo;
        this.valueFlow = valueFlow;
        this.stateUpdate = stateUpdate;
        this.extra = extra;
    }

    public static BlockBuilder builder() {
        return new BlockBuilder();
    }

    public long getMagic() {
        return this.magic;
    }

    public int getGlobalId() {
        return this.globalId;
    }

    public BlockInfo getBlockInfo() {
        return this.blockInfo;
    }

    public ValueFlow getValueFlow() {
        return this.valueFlow;
    }

    public MerkleUpdate getStateUpdate() {
        return this.stateUpdate;
    }

    public BlockExtra getExtra() {
        return this.extra;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setGlobalId(int globalId) {
        this.globalId = globalId;
    }

    public void setBlockInfo(BlockInfo blockInfo) {
        this.blockInfo = blockInfo;
    }

    public void setValueFlow(ValueFlow valueFlow) {
        this.valueFlow = valueFlow;
    }

    public void setStateUpdate(MerkleUpdate stateUpdate) {
        this.stateUpdate = stateUpdate;
    }

    public void setExtra(BlockExtra extra) {
        this.extra = extra;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Block)) {
            return false;
        }
        Block other = (Block)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        if (this.getGlobalId() != other.getGlobalId()) {
            return false;
        }
        BlockInfo this$blockInfo = this.getBlockInfo();
        BlockInfo other$blockInfo = other.getBlockInfo();
        if (this$blockInfo == null ? other$blockInfo != null : !((Object)this$blockInfo).equals(other$blockInfo)) {
            return false;
        }
        ValueFlow this$valueFlow = this.getValueFlow();
        ValueFlow other$valueFlow = other.getValueFlow();
        if (this$valueFlow == null ? other$valueFlow != null : !((Object)this$valueFlow).equals(other$valueFlow)) {
            return false;
        }
        MerkleUpdate this$stateUpdate = this.getStateUpdate();
        MerkleUpdate other$stateUpdate = other.getStateUpdate();
        if (this$stateUpdate == null ? other$stateUpdate != null : !((Object)this$stateUpdate).equals(other$stateUpdate)) {
            return false;
        }
        BlockExtra this$extra = this.getExtra();
        BlockExtra other$extra = other.getExtra();
        return !(this$extra == null ? other$extra != null : !((Object)this$extra).equals(other$extra));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Block;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $magic = this.getMagic();
        result = result * 59 + (int)($magic >>> 32 ^ $magic);
        result = result * 59 + this.getGlobalId();
        BlockInfo $blockInfo = this.getBlockInfo();
        result = result * 59 + ($blockInfo == null ? 43 : ((Object)$blockInfo).hashCode());
        ValueFlow $valueFlow = this.getValueFlow();
        result = result * 59 + ($valueFlow == null ? 43 : ((Object)$valueFlow).hashCode());
        MerkleUpdate $stateUpdate = this.getStateUpdate();
        result = result * 59 + ($stateUpdate == null ? 43 : ((Object)$stateUpdate).hashCode());
        BlockExtra $extra = this.getExtra();
        result = result * 59 + ($extra == null ? 43 : ((Object)$extra).hashCode());
        return result;
    }

    public String toString() {
        return "Block(magic=" + this.getMagic() + ", globalId=" + this.getGlobalId() + ", blockInfo=" + String.valueOf(this.getBlockInfo()) + ", valueFlow=" + String.valueOf(this.getValueFlow()) + ", stateUpdate=" + String.valueOf(this.getStateUpdate()) + ", extra=" + String.valueOf(this.getExtra()) + ")";
    }

    public static class BlockBuilder {
        private long magic;
        private int globalId;
        private BlockInfo blockInfo;
        private ValueFlow valueFlow;
        private MerkleUpdate stateUpdate;
        private BlockExtra extra;

        BlockBuilder() {
        }

        public BlockBuilder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public BlockBuilder globalId(int globalId) {
            this.globalId = globalId;
            return this;
        }

        public BlockBuilder blockInfo(BlockInfo blockInfo) {
            this.blockInfo = blockInfo;
            return this;
        }

        public BlockBuilder valueFlow(ValueFlow valueFlow) {
            this.valueFlow = valueFlow;
            return this;
        }

        public BlockBuilder stateUpdate(MerkleUpdate stateUpdate) {
            this.stateUpdate = stateUpdate;
            return this;
        }

        public BlockBuilder extra(BlockExtra extra) {
            this.extra = extra;
            return this;
        }

        public Block build() {
            return new Block(this.magic, this.globalId, this.blockInfo, this.valueFlow, this.stateUpdate, this.extra);
        }

        public String toString() {
            return "Block.BlockBuilder(magic=" + this.magic + ", globalId=" + this.globalId + ", blockInfo=" + String.valueOf(this.blockInfo) + ", valueFlow=" + String.valueOf(this.valueFlow) + ", stateUpdate=" + String.valueOf(this.stateUpdate) + ", extra=" + String.valueOf(this.extra) + ")";
        }
    }
}

