/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.ShardDescr;

public class BinTree
implements Serializable {
    ShardDescr value;
    BinTree left;
    BinTree right;

    public BinTree() {
    }

    public BinTree(ShardDescr value) {
        this.value = value;
    }

    public BinTree(ShardDescr value, BinTree left, BinTree right) {
        this.value = value;
        this.left = left;
        this.right = right;
    }

    public static BinTree fromDeque(Deque<ShardDescr> cells) {
        return BinTree.buildTree(cells);
    }

    private static BinTree buildTree(Deque<ShardDescr> cells) {
        if (cells.isEmpty()) {
            return null;
        }
        ShardDescr value = cells.pop();
        BinTree left = BinTree.buildTree(cells);
        BinTree right = BinTree.buildTree(cells);
        return new BinTree(value, left, right);
    }

    public Cell toCell() {
        if (this.value == null && this.left == null && this.right == null) {
            return CellBuilder.beginCell().endCell();
        }
        return BinTree.addToBinTree(this);
    }

    private static Cell addToBinTree(BinTree tree) {
        CellBuilder cb = CellBuilder.beginCell();
        if (tree.value != null) {
            cb.storeBit(Boolean.valueOf(true));
            cb.storeRef(CellBuilder.beginCell().storeBit(Boolean.valueOf(false)).storeCell(tree.value.toCell()).endCell());
            if (tree.left != null && tree.left.value != null) {
                cb.storeRef(BinTree.addToBinTree(tree.left));
            }
            if (tree.right != null && tree.right.value != null) {
                cb.storeRef(BinTree.addToBinTree(tree.right));
            }
        } else {
            cb.storeBit(Boolean.valueOf(false));
        }
        return cb.endCell();
    }

    public static BinTree deserialize(CellSlice cs) {
        if (cs.isExotic() || cs.getRestBits() == 0) {
            return null;
        }
        BinTree root = new BinTree();
        if (cs.loadBit()) {
            CellSlice internalCs;
            if (cs.getRefsCount() != 0 && !(internalCs = CellSlice.beginParse((Cell)cs.loadRef())).loadBit()) {
                root.value = ShardDescr.deserialize(internalCs);
            }
            if (cs.getRefsCount() != 0) {
                root.left = BinTree.deserialize(CellSlice.beginParse((Cell)cs.loadRef()));
            }
            if (cs.getRefsCount() != 0) {
                root.right = BinTree.deserialize(CellSlice.beginParse((Cell)cs.loadRef()));
            }
            return root;
        }
        root.value = ShardDescr.deserialize(cs);
        return root;
    }

    public List<ShardDescr> toList() {
        ArrayList<ShardDescr> list = new ArrayList<ShardDescr>();
        this.addToList(this, list);
        return list;
    }

    private void addToList(BinTree node, List<ShardDescr> list) {
        if (node == null) {
            return;
        }
        if (node.value != null) {
            list.add(node.value);
        }
        this.addToList(node.left, list);
        this.addToList(node.right, list);
    }
}

