/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.CurrencyCollection;
import org.ton.java.tlb.OutAction;

public class ActionReserveCurrency
implements OutAction,
Serializable {
    long magic;
    int mode;
    CurrencyCollection currency;

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(921090057, 32).storeUint(this.mode, 8).storeCell(this.currency.toCell()).endCell();
    }

    public static ActionReserveCurrency deserialize(CellSlice cs) {
        return ActionReserveCurrency.builder().magic(cs.loadUint(32).intValue()).mode(cs.loadUint(8).intValue()).currency(CurrencyCollection.deserialize(cs)).build();
    }

    ActionReserveCurrency(long magic, int mode, CurrencyCollection currency) {
        this.magic = magic;
        this.mode = mode;
        this.currency = currency;
    }

    public static ActionReserveCurrencyBuilder builder() {
        return new ActionReserveCurrencyBuilder();
    }

    public long getMagic() {
        return this.magic;
    }

    public int getMode() {
        return this.mode;
    }

    public CurrencyCollection getCurrency() {
        return this.currency;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setCurrency(CurrencyCollection currency) {
        this.currency = currency;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActionReserveCurrency)) {
            return false;
        }
        ActionReserveCurrency other = (ActionReserveCurrency)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        if (this.getMode() != other.getMode()) {
            return false;
        }
        CurrencyCollection this$currency = this.getCurrency();
        CurrencyCollection other$currency = other.getCurrency();
        return !(this$currency == null ? other$currency != null : !((Object)this$currency).equals(other$currency));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActionReserveCurrency;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $magic = this.getMagic();
        result = result * 59 + (int)($magic >>> 32 ^ $magic);
        result = result * 59 + this.getMode();
        CurrencyCollection $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : ((Object)$currency).hashCode());
        return result;
    }

    public String toString() {
        return "ActionReserveCurrency(magic=" + this.getMagic() + ", mode=" + this.getMode() + ", currency=" + String.valueOf(this.getCurrency()) + ")";
    }

    public static class ActionReserveCurrencyBuilder {
        private long magic;
        private int mode;
        private CurrencyCollection currency;

        ActionReserveCurrencyBuilder() {
        }

        public ActionReserveCurrencyBuilder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public ActionReserveCurrencyBuilder mode(int mode) {
            this.mode = mode;
            return this;
        }

        public ActionReserveCurrencyBuilder currency(CurrencyCollection currency) {
            this.currency = currency;
            return this;
        }

        public ActionReserveCurrency build() {
            return new ActionReserveCurrency(this.magic, this.mode, this.currency);
        }

        public String toString() {
            return "ActionReserveCurrency.ActionReserveCurrencyBuilder(magic=" + this.magic + ", mode=" + this.mode + ", currency=" + String.valueOf(this.currency) + ")";
        }
    }
}

