/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.AccountState;
import org.ton.java.tlb.AccountStateActive;
import org.ton.java.tlb.AccountStateFrozen;
import org.ton.java.tlb.AccountStateUninit;
import org.ton.java.tlb.CurrencyCollection;

public class AccountStorage
implements Serializable {
    String accountStatus;
    BigInteger lastTransactionLt;
    CurrencyCollection balance;
    AccountState accountState;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(this.lastTransactionLt, 64).storeCell(this.balance.toCell()).storeCell(this.accountState.toCell()).endCell();
    }

    public static AccountStorage deserialize(CellSlice cs) {
        AccountStorage accountStorage = AccountStorage.builder().build();
        BigInteger lastTransactionLt = cs.loadUint(64);
        CurrencyCollection coins = CurrencyCollection.deserialize(cs);
        boolean isStatusActive = cs.preloadBit();
        if (isStatusActive) {
            accountStorage.setAccountStatus("ACTIVE");
            accountStorage.setAccountState(AccountStateActive.deserialize(cs));
        } else {
            boolean isStatusFrozen = cs.preloadBitAt(2);
            if (isStatusFrozen) {
                accountStorage.setAccountStatus("FROZEN");
                accountStorage.setAccountState(AccountStateFrozen.deserialize(cs));
            } else {
                accountStorage.setAccountStatus("UNINIT");
                accountStorage.setAccountState(AccountStateUninit.deserialize(cs));
            }
        }
        accountStorage.setLastTransactionLt(lastTransactionLt);
        accountStorage.setBalance(coins);
        return accountStorage;
    }

    AccountStorage(String accountStatus, BigInteger lastTransactionLt, CurrencyCollection balance, AccountState accountState) {
        this.accountStatus = accountStatus;
        this.lastTransactionLt = lastTransactionLt;
        this.balance = balance;
        this.accountState = accountState;
    }

    public static AccountStorageBuilder builder() {
        return new AccountStorageBuilder();
    }

    public String getAccountStatus() {
        return this.accountStatus;
    }

    public BigInteger getLastTransactionLt() {
        return this.lastTransactionLt;
    }

    public CurrencyCollection getBalance() {
        return this.balance;
    }

    public AccountState getAccountState() {
        return this.accountState;
    }

    public void setAccountStatus(String accountStatus) {
        this.accountStatus = accountStatus;
    }

    public void setLastTransactionLt(BigInteger lastTransactionLt) {
        this.lastTransactionLt = lastTransactionLt;
    }

    public void setBalance(CurrencyCollection balance) {
        this.balance = balance;
    }

    public void setAccountState(AccountState accountState) {
        this.accountState = accountState;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountStorage)) {
            return false;
        }
        AccountStorage other = (AccountStorage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$accountStatus = this.getAccountStatus();
        String other$accountStatus = other.getAccountStatus();
        if (this$accountStatus == null ? other$accountStatus != null : !this$accountStatus.equals(other$accountStatus)) {
            return false;
        }
        BigInteger this$lastTransactionLt = this.getLastTransactionLt();
        BigInteger other$lastTransactionLt = other.getLastTransactionLt();
        if (this$lastTransactionLt == null ? other$lastTransactionLt != null : !((Object)this$lastTransactionLt).equals(other$lastTransactionLt)) {
            return false;
        }
        CurrencyCollection this$balance = this.getBalance();
        CurrencyCollection other$balance = other.getBalance();
        if (this$balance == null ? other$balance != null : !((Object)this$balance).equals(other$balance)) {
            return false;
        }
        AccountState this$accountState = this.getAccountState();
        AccountState other$accountState = other.getAccountState();
        return !(this$accountState == null ? other$accountState != null : !this$accountState.equals(other$accountState));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccountStorage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $accountStatus = this.getAccountStatus();
        result = result * 59 + ($accountStatus == null ? 43 : $accountStatus.hashCode());
        BigInteger $lastTransactionLt = this.getLastTransactionLt();
        result = result * 59 + ($lastTransactionLt == null ? 43 : ((Object)$lastTransactionLt).hashCode());
        CurrencyCollection $balance = this.getBalance();
        result = result * 59 + ($balance == null ? 43 : ((Object)$balance).hashCode());
        AccountState $accountState = this.getAccountState();
        result = result * 59 + ($accountState == null ? 43 : $accountState.hashCode());
        return result;
    }

    public String toString() {
        return "AccountStorage(accountStatus=" + this.getAccountStatus() + ", lastTransactionLt=" + String.valueOf(this.getLastTransactionLt()) + ", balance=" + String.valueOf(this.getBalance()) + ", accountState=" + String.valueOf(this.getAccountState()) + ")";
    }

    public static class AccountStorageBuilder {
        private String accountStatus;
        private BigInteger lastTransactionLt;
        private CurrencyCollection balance;
        private AccountState accountState;

        AccountStorageBuilder() {
        }

        public AccountStorageBuilder accountStatus(String accountStatus) {
            this.accountStatus = accountStatus;
            return this;
        }

        public AccountStorageBuilder lastTransactionLt(BigInteger lastTransactionLt) {
            this.lastTransactionLt = lastTransactionLt;
            return this;
        }

        public AccountStorageBuilder balance(CurrencyCollection balance) {
            this.balance = balance;
            return this;
        }

        public AccountStorageBuilder accountState(AccountState accountState) {
            this.accountState = accountState;
            return this;
        }

        public AccountStorage build() {
            return new AccountStorage(this.accountStatus, this.lastTransactionLt, this.balance, this.accountState);
        }

        public String toString() {
            return "AccountStorage.AccountStorageBuilder(accountStatus=" + this.accountStatus + ", lastTransactionLt=" + String.valueOf(this.lastTransactionLt) + ", balance=" + String.valueOf(this.balance) + ", accountState=" + String.valueOf(this.accountState) + ")";
        }
    }
}

