/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellSlice;
import org.ton.java.cell.TonHashMap;
import org.ton.java.tlb.Account;
import org.ton.java.utils.Utils;

public class AccountHelper
implements Serializable {
    boolean isActive;
    Account state;
    Cell data;
    Cell code;
    BigInteger lastTxLt;
    byte[] lastTxHash;

    public boolean hasGetMethod(String name) {
        if (Objects.isNull(this.code)) {
            return false;
        }
        switch (name) {
            case "recv_internal": 
            case "main": 
            case "recv_external": 
            case "run_ticktock": {
                return false;
            }
        }
        long hash = AccountHelper.methodNameHash(name);
        CellSlice cs = CellSlice.beginParse((Cell)this.code);
        byte[] hdr = cs.loadBytes(56);
        if (!Utils.bytesToHex((byte[])hdr).toLowerCase().contains("ff00f4a413f4bc")) {
            return false;
        }
        CellSlice ref = CellSlice.beginParse((Cell)cs.loadRef());
        TonHashMap dict = ref.loadDict(19, k -> k.readUint(19), v -> v);
        for (Map.Entry entry : dict.elements.entrySet()) {
            if (((BigInteger)entry.getKey()).longValue() != hash) continue;
            return true;
        }
        return false;
    }

    public static long methodNameHash(String name) {
        return Utils.getCRC16ChecksumAsInt((byte[])name.getBytes(StandardCharsets.UTF_8)) & 0xFFFF | 0x10000;
    }

    AccountHelper(boolean isActive, Account state, Cell data, Cell code, BigInteger lastTxLt, byte[] lastTxHash) {
        this.isActive = isActive;
        this.state = state;
        this.data = data;
        this.code = code;
        this.lastTxLt = lastTxLt;
        this.lastTxHash = lastTxHash;
    }

    public static AccountHelperBuilder builder() {
        return new AccountHelperBuilder();
    }

    public boolean isActive() {
        return this.isActive;
    }

    public Account getState() {
        return this.state;
    }

    public Cell getData() {
        return this.data;
    }

    public Cell getCode() {
        return this.code;
    }

    public BigInteger getLastTxLt() {
        return this.lastTxLt;
    }

    public byte[] getLastTxHash() {
        return this.lastTxHash;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public void setState(Account state) {
        this.state = state;
    }

    public void setData(Cell data) {
        this.data = data;
    }

    public void setCode(Cell code) {
        this.code = code;
    }

    public void setLastTxLt(BigInteger lastTxLt) {
        this.lastTxLt = lastTxLt;
    }

    public void setLastTxHash(byte[] lastTxHash) {
        this.lastTxHash = lastTxHash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountHelper)) {
            return false;
        }
        AccountHelper other = (AccountHelper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        Account this$state = this.getState();
        Account other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
            return false;
        }
        Cell this$data = this.getData();
        Cell other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        Cell this$code = this.getCode();
        Cell other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        BigInteger this$lastTxLt = this.getLastTxLt();
        BigInteger other$lastTxLt = other.getLastTxLt();
        if (this$lastTxLt == null ? other$lastTxLt != null : !((Object)this$lastTxLt).equals(other$lastTxLt)) {
            return false;
        }
        return Arrays.equals(this.getLastTxHash(), other.getLastTxHash());
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccountHelper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isActive() ? 79 : 97);
        Account $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        Cell $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Cell $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        BigInteger $lastTxLt = this.getLastTxLt();
        result = result * 59 + ($lastTxLt == null ? 43 : ((Object)$lastTxLt).hashCode());
        result = result * 59 + Arrays.hashCode(this.getLastTxHash());
        return result;
    }

    public String toString() {
        return "AccountHelper(isActive=" + this.isActive() + ", state=" + String.valueOf(this.getState()) + ", data=" + String.valueOf(this.getData()) + ", code=" + String.valueOf(this.getCode()) + ", lastTxLt=" + String.valueOf(this.getLastTxLt()) + ", lastTxHash=" + Arrays.toString(this.getLastTxHash()) + ")";
    }

    public static class AccountHelperBuilder {
        private boolean isActive;
        private Account state;
        private Cell data;
        private Cell code;
        private BigInteger lastTxLt;
        private byte[] lastTxHash;

        AccountHelperBuilder() {
        }

        public AccountHelperBuilder isActive(boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public AccountHelperBuilder state(Account state) {
            this.state = state;
            return this;
        }

        public AccountHelperBuilder data(Cell data) {
            this.data = data;
            return this;
        }

        public AccountHelperBuilder code(Cell code) {
            this.code = code;
            return this;
        }

        public AccountHelperBuilder lastTxLt(BigInteger lastTxLt) {
            this.lastTxLt = lastTxLt;
            return this;
        }

        public AccountHelperBuilder lastTxHash(byte[] lastTxHash) {
            this.lastTxHash = lastTxHash;
            return this;
        }

        public AccountHelper build() {
            return new AccountHelper(this.isActive, this.state, this.data, this.code, this.lastTxLt, this.lastTxHash);
        }

        public String toString() {
            return "AccountHelper.AccountHelperBuilder(isActive=" + this.isActive + ", state=" + String.valueOf(this.state) + ", data=" + String.valueOf(this.data) + ", code=" + String.valueOf(this.code) + ", lastTxLt=" + String.valueOf(this.lastTxLt) + ", lastTxHash=" + Arrays.toString(this.lastTxHash) + ")";
        }
    }
}

