/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.cell.TonHashMapAug;
import org.ton.java.tlb.CurrencyCollection;
import org.ton.java.tlb.Transaction;

public class AccountBlock
implements Serializable {
    long magic;
    BigInteger addr;
    TonHashMapAug transactions;
    Cell stateUpdate;

    public Cell toCell() {
        Cell dictCell = this.transactions.serialize(k -> CellBuilder.beginCell().storeUint((BigInteger)k, 64).endCell().getBits(), v -> CellBuilder.beginCell().storeRef(((Transaction)v).toCell()), e -> CellBuilder.beginCell().storeCell(((CurrencyCollection)e).toCell()), (fk, fv) -> CellBuilder.beginCell().storeUint(0, 1));
        return CellBuilder.beginCell().storeUint(5, 32).storeUint(this.addr, 256).storeDict(dictCell).storeRef(this.stateUpdate).endCell();
    }

    public static AccountBlock deserialize(CellSlice cs) {
        long magic = cs.loadUint(4).longValue();
        assert (magic == 5L) : "AccountBlock: magic not equal to 0x5, found 0x" + Long.toHexString(magic);
        return AccountBlock.builder().magic(5L).addr(cs.loadUint(256)).transactions(cs.loadDictAug(64, k -> k.readInt(64), v -> Transaction.deserialize(CellSlice.beginParse((Cell)v.loadRef())), e -> CurrencyCollection.deserialize(e))).stateUpdate(cs.loadRef()).build();
    }

    AccountBlock(long magic, BigInteger addr, TonHashMapAug transactions, Cell stateUpdate) {
        this.magic = magic;
        this.addr = addr;
        this.transactions = transactions;
        this.stateUpdate = stateUpdate;
    }

    public static AccountBlockBuilder builder() {
        return new AccountBlockBuilder();
    }

    public long getMagic() {
        return this.magic;
    }

    public BigInteger getAddr() {
        return this.addr;
    }

    public TonHashMapAug getTransactions() {
        return this.transactions;
    }

    public Cell getStateUpdate() {
        return this.stateUpdate;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setAddr(BigInteger addr) {
        this.addr = addr;
    }

    public void setTransactions(TonHashMapAug transactions) {
        this.transactions = transactions;
    }

    public void setStateUpdate(Cell stateUpdate) {
        this.stateUpdate = stateUpdate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountBlock)) {
            return false;
        }
        AccountBlock other = (AccountBlock)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        BigInteger this$addr = this.getAddr();
        BigInteger other$addr = other.getAddr();
        if (this$addr == null ? other$addr != null : !((Object)this$addr).equals(other$addr)) {
            return false;
        }
        TonHashMapAug this$transactions = this.getTransactions();
        TonHashMapAug other$transactions = other.getTransactions();
        if (this$transactions == null ? other$transactions != null : !this$transactions.equals(other$transactions)) {
            return false;
        }
        Cell this$stateUpdate = this.getStateUpdate();
        Cell other$stateUpdate = other.getStateUpdate();
        return !(this$stateUpdate == null ? other$stateUpdate != null : !this$stateUpdate.equals(other$stateUpdate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccountBlock;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $magic = this.getMagic();
        result = result * 59 + (int)($magic >>> 32 ^ $magic);
        BigInteger $addr = this.getAddr();
        result = result * 59 + ($addr == null ? 43 : ((Object)$addr).hashCode());
        TonHashMapAug $transactions = this.getTransactions();
        result = result * 59 + ($transactions == null ? 43 : $transactions.hashCode());
        Cell $stateUpdate = this.getStateUpdate();
        result = result * 59 + ($stateUpdate == null ? 43 : $stateUpdate.hashCode());
        return result;
    }

    public String toString() {
        return "AccountBlock(magic=" + this.getMagic() + ", addr=" + String.valueOf(this.getAddr()) + ", transactions=" + String.valueOf(this.getTransactions()) + ", stateUpdate=" + String.valueOf(this.getStateUpdate()) + ")";
    }

    public static class AccountBlockBuilder {
        private long magic;
        private BigInteger addr;
        private TonHashMapAug transactions;
        private Cell stateUpdate;

        AccountBlockBuilder() {
        }

        public AccountBlockBuilder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public AccountBlockBuilder addr(BigInteger addr) {
            this.addr = addr;
            return this;
        }

        public AccountBlockBuilder transactions(TonHashMapAug transactions) {
            this.transactions = transactions;
            return this;
        }

        public AccountBlockBuilder stateUpdate(Cell stateUpdate) {
            this.stateUpdate = stateUpdate;
            return this;
        }

        public AccountBlock build() {
            return new AccountBlock(this.magic, this.addr, this.transactions, this.stateUpdate);
        }

        public String toString() {
            return "AccountBlock.AccountBlockBuilder(magic=" + this.magic + ", addr=" + String.valueOf(this.addr) + ", transactions=" + String.valueOf(this.transactions) + ", stateUpdate=" + String.valueOf(this.stateUpdate) + ")";
        }
    }
}

