/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.wallet.v5;

import com.iwebpp.crypto.TweetNaclFast;
import java.math.BigInteger;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.cell.CellType;
import org.ton.java.cell.TonHashMap;
import org.ton.java.cell.TonHashMapE;
import org.ton.java.smartcontract.types.Destination;
import org.ton.java.smartcontract.types.WalletCodes;
import org.ton.java.smartcontract.types.WalletV5Config;
import org.ton.java.smartcontract.types.WalletV5InnerRequest;
import org.ton.java.smartcontract.wallet.Contract;
import org.ton.java.tlb.ActionList;
import org.ton.java.tlb.ActionSendMsg;
import org.ton.java.tlb.CommonMsgInfo;
import org.ton.java.tlb.CommonMsgInfoRelaxed;
import org.ton.java.tlb.CurrencyCollection;
import org.ton.java.tlb.ExternalMessageInInfo;
import org.ton.java.tlb.InternalMessageInfo;
import org.ton.java.tlb.InternalMessageInfoRelaxed;
import org.ton.java.tlb.Message;
import org.ton.java.tlb.MessageRelaxed;
import org.ton.java.tlb.MsgAddressInt;
import org.ton.java.tlb.MsgAddressIntStd;
import org.ton.java.tlb.OutAction;
import org.ton.java.tlb.OutList;
import org.ton.java.tlb.StateInit;
import org.ton.java.tonlib.Tonlib;
import org.ton.java.tonlib.types.ExtMessageInfo;
import org.ton.java.tonlib.types.RawTransaction;
import org.ton.java.tonlib.types.RunResult;
import org.ton.java.tonlib.types.TvmStackEntryCell;
import org.ton.java.tonlib.types.TvmStackEntryList;
import org.ton.java.tonlib.types.TvmStackEntryNumber;
import org.ton.java.utils.Utils;

public class WalletV5
implements Contract {
    private static final int SIZE_BOOL = 1;
    private static final int SIZE_SEQNO = 32;
    private static final int SIZE_WALLET_ID = 32;
    private static final int SIZE_VALID_UNTIL = 32;
    private static final int PREFIX_SIGNED_EXTERNAL = 1936287598;
    private static final int PREFIX_SIGNED_INTERNAL = 1936289396;
    private static final int PREFIX_EXTENSION_ACTION = 1702392942;
    TweetNaclFast.Signature.KeyPair keyPair;
    long initialSeqno;
    long walletId;
    byte[] publicKey;
    long validUntil;
    TonHashMapE extensions;
    boolean isSigAuthAllowed;
    private Tonlib tonlib;
    private long wc;
    private boolean deployAsLibrary;

    public static WalletV5Builder builder() {
        return new CustomWalletV5Builder();
    }

    @Override
    public Tonlib getTonlib() {
        return this.tonlib;
    }

    @Override
    public void setTonlib(Tonlib pTonlib) {
        this.tonlib = pTonlib;
    }

    @Override
    public long getWorkchain() {
        return this.wc;
    }

    @Override
    public String getName() {
        return "V5";
    }

    @Override
    public Cell createDataCell() {
        if (Objects.isNull(this.extensions)) {
            return CellBuilder.beginCell().storeBit(Boolean.valueOf(this.isSigAuthAllowed)).storeUint(this.initialSeqno, 32).storeUint(this.walletId, 32).storeBytes(this.keyPair.getPublicKey()).storeBit(Boolean.valueOf(false)).endCell();
        }
        return CellBuilder.beginCell().storeBit(Boolean.valueOf(this.isSigAuthAllowed)).storeUint(this.initialSeqno, 32).storeUint(this.walletId, 32).storeBytes(Objects.isNull(this.keyPair) ? this.publicKey : this.keyPair.getPublicKey()).storeDict(this.extensions.serialize(k -> CellBuilder.beginCell().storeUint((BigInteger)k, 256).endCell().getBits(), v -> CellBuilder.beginCell().storeBit((Boolean)v).endCell())).endCell();
    }

    @Override
    public Cell createCodeCell() {
        if (!this.deployAsLibrary) {
            return CellBuilder.beginCell().fromBoc(WalletCodes.V5R1.getValue()).endCell();
        }
        return CellBuilder.beginCell().storeUint(2, 8).storeBytes(CellBuilder.beginCell().fromBoc(WalletCodes.V5R1.getValue()).endCell().getHash()).setExotic(true).cellType(CellType.LIBRARY).endCell();
    }

    @Override
    public StateInit getStateInit() {
        return StateInit.builder().code(this.createCodeCell()).data(this.createDataCell()).build();
    }

    public ExtMessageInfo send(WalletV5Config config) {
        return this.tonlib.sendRawMessage(this.prepareExternalMsg(config).toCell().toBase64());
    }

    public RawTransaction sendWithConfirmation(WalletV5Config config) {
        return this.tonlib.sendRawMessageWithConfirmation(this.prepareExternalMsg(config).toCell().toBase64(), this.getAddress());
    }

    public ExtMessageInfo deploy() {
        return this.tonlib.sendRawMessage(this.prepareDeployMsg().toCell().toBase64());
    }

    public ExtMessageInfo deploy(byte[] signedBody) {
        return this.tonlib.sendRawMessage(this.prepareDeployMsg(signedBody).toCell().toBase64());
    }

    public Message prepareDeployMsg(byte[] signedBodyHash) {
        Cell body = this.createDeployMsg();
        return Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).build()).init(this.getStateInit()).body(CellBuilder.beginCell().storeCell(body).storeBytes(signedBodyHash).endCell()).build();
    }

    public ExtMessageInfo send(WalletV5Config config, byte[] signedBodyHash) {
        return this.tonlib.sendRawMessage(this.prepareExternalMsg(config, signedBodyHash).toCell().toBase64());
    }

    public Message prepareExternalMsg(WalletV5Config config, byte[] signedBodyHash) {
        Cell body = this.createExternalTransferBody(config);
        return Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).build()).init(this.getStateInit()).body(CellBuilder.beginCell().storeCell(body).storeBytes(signedBodyHash).endCell()).build();
    }

    @Override
    public Message prepareDeployMsg() {
        Cell body = this.createDeployMsg();
        byte[] signature = Utils.signData((byte[])this.keyPair.getPublicKey(), (byte[])this.keyPair.getSecretKey(), (byte[])body.hash());
        return Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).build()).init(this.getStateInit()).body(CellBuilder.beginCell().storeCell(body).storeBytes(signature).endCell()).build();
    }

    public Message prepareExternalMsg(WalletV5Config config) {
        Cell body = this.createExternalTransferBody(config);
        byte[] signature = Utils.signData((byte[])this.keyPair.getPublicKey(), (byte[])this.keyPair.getSecretKey(), (byte[])body.hash());
        return Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).build()).init(this.getStateInit()).body(CellBuilder.beginCell().storeCell(body).storeBytes(signature).endCell()).build();
    }

    public Message prepareInternalMsg(WalletV5Config config) {
        Cell body = this.createInternalSignedBody(config);
        return Message.builder().info((CommonMsgInfo)InternalMessageInfo.builder().srcAddr((MsgAddressInt)this.getAddressIntStd()).dstAddr((MsgAddressInt)this.getAddressIntStd()).value(CurrencyCollection.builder().coins(config.getAmount()).extraCurrencies(this.convertExtraCurrenciesToHashMap(config.getExtraCurrencies())).build()).build()).body(body).build();
    }

    public MessageRelaxed prepareInternalMsgRelaxed(WalletV5Config config) {
        Cell body = this.createInternalSignedBody(config);
        return MessageRelaxed.builder().info((CommonMsgInfoRelaxed)InternalMessageInfoRelaxed.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).value(CurrencyCollection.builder().coins(config.getAmount()).extraCurrencies(this.convertExtraCurrenciesToHashMap(config.getExtraCurrencies())).build()).build()).body(body).build();
    }

    public Cell createDeployMsg() {
        if (Objects.isNull(this.extensions)) {
            return CellBuilder.beginCell().storeUint(1936287598, 32).storeUint(this.walletId, 32).storeUint(this.validUntil == 0L ? Instant.now().getEpochSecond() + 60L : this.validUntil, 32).storeUint(0, 32).storeBit(Boolean.valueOf(false)).endCell();
        }
        return CellBuilder.beginCell().storeUint(1936287598, 32).storeUint(this.walletId, 32).storeUint(this.validUntil == 0L ? Instant.now().getEpochSecond() + 60L : this.validUntil, 32).storeUint(0, 32).storeDict(this.extensions.serialize(k -> CellBuilder.beginCell().storeUint((BigInteger)k, 256).endCell().getBits(), v -> CellBuilder.beginCell().storeBit((Boolean)v).endCell())).endCell();
    }

    public Cell createExternalTransferBody(WalletV5Config config) {
        return CellBuilder.beginCell().storeUint(1936287598, 32).storeUint(config.getWalletId(), 32).storeUint(config.getValidUntil() == 0L ? Instant.now().getEpochSecond() + 60L : config.getValidUntil(), 32).storeUint(config.getSeqno(), 32).storeCell(config.getBody()).endCell();
    }

    public Cell createInternalTransferBody(WalletV5Config config) {
        return CellBuilder.beginCell().storeUint(1936289396, 32).storeUint(config.getWalletId(), 32).storeUint(config.getValidUntil() == 0L ? Instant.now().getEpochSecond() + 60L : config.getValidUntil(), 32).storeUint(config.getSeqno(), 32).storeCell(config.getBody()).endCell();
    }

    public Cell createInternalSignedBody(WalletV5Config config) {
        Cell body = this.createInternalTransferBody(config);
        byte[] signature = Utils.signData((byte[])this.keyPair.getPublicKey(), (byte[])this.keyPair.getSecretKey(), (byte[])body.hash());
        return CellBuilder.beginCell().storeCell(body).storeBytes(signature).endCell();
    }

    public Cell createInternalExtensionTransferBody(BigInteger queryId, Cell body) {
        return CellBuilder.beginCell().storeUint(1702392942, 32).storeUint(queryId, 64).storeCell(body).endCell();
    }

    public Cell createInternalExtensionSignedBody(BigInteger queryId, Cell body) {
        Cell body1 = this.createInternalExtensionTransferBody(queryId, body);
        byte[] signature = Utils.signData((byte[])this.keyPair.getPublicKey(), (byte[])this.keyPair.getSecretKey(), (byte[])body1.hash());
        return CellBuilder.beginCell().storeCell(body).storeBytes(signature).endCell();
    }

    public WalletV5InnerRequest manageExtensions(ActionList actionList) {
        return WalletV5InnerRequest.builder().outActions(OutList.builder().build()).hasOtherActions(true).otherActions(actionList).build();
    }

    public WalletV5InnerRequest createBulkTransfer(List<Destination> recipients) {
        if (recipients.size() > 255) {
            throw new IllegalArgumentException("Maximum number of recipients should be less than 255");
        }
        ArrayList<OutAction> messages = new ArrayList<OutAction>();
        for (Destination recipient : recipients) {
            messages.add(this.convertDestinationToOutAction(recipient));
        }
        return WalletV5InnerRequest.builder().outActions(OutList.builder().actions(messages).build()).hasOtherActions(false).build();
    }

    public WalletV5InnerRequest createBulkTransferAndManageExtensions(List<Destination> recipients, ActionList actionList) {
        if (recipients.size() > 255) {
            throw new IllegalArgumentException("Maximum number of recipients should be less than 255");
        }
        ArrayList<OutAction> messages = new ArrayList<OutAction>();
        for (Destination recipient : recipients) {
            messages.add(this.convertDestinationToOutAction(recipient));
        }
        if (actionList.getActions().isEmpty()) {
            return WalletV5InnerRequest.builder().outActions(OutList.builder().actions(messages).build()).hasOtherActions(false).build();
        }
        return WalletV5InnerRequest.builder().outActions(OutList.builder().actions(messages).build()).hasOtherActions(true).otherActions(actionList).build();
    }

    private OutAction convertDestinationToOutAction(Destination destination) {
        Address dstAddress = Address.of((String)destination.getAddress());
        return ActionSendMsg.builder().mode(destination.getMode() == 0 ? 3 : destination.getMode()).outMsg(MessageRelaxed.builder().info((CommonMsgInfoRelaxed)InternalMessageInfoRelaxed.builder().bounce(Boolean.valueOf(destination.isBounce())).dstAddr((MsgAddressInt)MsgAddressIntStd.builder().workchainId(dstAddress.wc).address(dstAddress.toBigInteger()).build()).value(CurrencyCollection.builder().coins(destination.getAmount()).extraCurrencies(this.convertExtraCurrenciesToHashMap(destination.getExtraCurrencies())).build()).build()).init(this.getStateInit()).body(Objects.isNull(destination.getBody()) && StringUtils.isNotEmpty((CharSequence)destination.getComment()) ? CellBuilder.beginCell().storeUint(0, 32).storeString(destination.getComment()).endCell() : destination.getBody()).build()).build();
    }

    public long getWalletId() {
        RunResult result = this.tonlib.runMethod(this.getAddress(), (long)Utils.calculateMethodId((String)"get_subwallet_id"));
        TvmStackEntryNumber subWalletId = (TvmStackEntryNumber)result.getStack().get(0);
        return subWalletId.getNumber().longValue();
    }

    public byte[] getPublicKey() {
        RunResult result = this.tonlib.runMethod(this.getAddress(), (long)Utils.calculateMethodId((String)"get_public_key"));
        TvmStackEntryNumber pubKey = (TvmStackEntryNumber)result.getStack().get(0);
        return pubKey.getNumber().toByteArray();
    }

    public boolean getIsSignatureAuthAllowed() {
        RunResult result = this.tonlib.runMethod(this.getAddress(), (long)Utils.calculateMethodId((String)"is_signature_allowed"));
        TvmStackEntryNumber signatureAllowed = (TvmStackEntryNumber)result.getStack().get(0);
        return signatureAllowed.getNumber().longValue() != 0L;
    }

    public TonHashMap getRawExtensions() {
        RunResult result = this.tonlib.runMethod(this.getAddress(), (long)Utils.calculateMethodId((String)"get_extensions"));
        if (result.getStack().get(0) instanceof TvmStackEntryList) {
            return new TonHashMap(256);
        }
        TvmStackEntryCell tvmStackEntryCell = (TvmStackEntryCell)result.getStack().get(0);
        String base64Msg = tvmStackEntryCell.getCell().getBytes();
        CellSlice cs = CellSlice.beginParse((Cell)Cell.fromBocBase64((String)base64Msg));
        return cs.loadDict(256, k -> k.readUint(256), v -> v);
    }

    WalletV5(TweetNaclFast.Signature.KeyPair keyPair, long initialSeqno, long walletId, byte[] publicKey, long validUntil, TonHashMapE extensions, boolean isSigAuthAllowed, Tonlib tonlib, long wc, boolean deployAsLibrary) {
        this.keyPair = keyPair;
        this.initialSeqno = initialSeqno;
        this.walletId = walletId;
        this.publicKey = publicKey;
        this.validUntil = validUntil;
        this.extensions = extensions;
        this.isSigAuthAllowed = isSigAuthAllowed;
        this.tonlib = tonlib;
        this.wc = wc;
        this.deployAsLibrary = deployAsLibrary;
    }

    public TweetNaclFast.Signature.KeyPair getKeyPair() {
        return this.keyPair;
    }

    public long getInitialSeqno() {
        return this.initialSeqno;
    }

    public long getValidUntil() {
        return this.validUntil;
    }

    public TonHashMapE getExtensions() {
        return this.extensions;
    }

    public boolean isSigAuthAllowed() {
        return this.isSigAuthAllowed;
    }

    public long getWc() {
        return this.wc;
    }

    public boolean isDeployAsLibrary() {
        return this.deployAsLibrary;
    }

    private static class CustomWalletV5Builder
    extends WalletV5Builder {
        private CustomWalletV5Builder() {
        }

        @Override
        public WalletV5 build() {
            if (Objects.isNull(this.publicKey) && Objects.isNull(this.keyPair)) {
                this.keyPair = Utils.generateSignatureKeyPair();
            }
            return super.build();
        }
    }

    public static class WalletV5Builder {
        private TweetNaclFast.Signature.KeyPair keyPair;
        private long initialSeqno;
        private long walletId;
        private byte[] publicKey;
        private long validUntil;
        private TonHashMapE extensions;
        private boolean isSigAuthAllowed;
        private Tonlib tonlib;
        private long wc;
        private boolean deployAsLibrary;

        WalletV5Builder() {
        }

        public WalletV5Builder keyPair(TweetNaclFast.Signature.KeyPair keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public WalletV5Builder initialSeqno(long initialSeqno) {
            this.initialSeqno = initialSeqno;
            return this;
        }

        public WalletV5Builder walletId(long walletId) {
            this.walletId = walletId;
            return this;
        }

        public WalletV5Builder publicKey(byte[] publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public WalletV5Builder validUntil(long validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public WalletV5Builder extensions(TonHashMapE extensions) {
            this.extensions = extensions;
            return this;
        }

        public WalletV5Builder isSigAuthAllowed(boolean isSigAuthAllowed) {
            this.isSigAuthAllowed = isSigAuthAllowed;
            return this;
        }

        public WalletV5Builder tonlib(Tonlib tonlib) {
            this.tonlib = tonlib;
            return this;
        }

        public WalletV5Builder wc(long wc) {
            this.wc = wc;
            return this;
        }

        public WalletV5Builder deployAsLibrary(boolean deployAsLibrary) {
            this.deployAsLibrary = deployAsLibrary;
            return this;
        }

        public WalletV5 build() {
            return new WalletV5(this.keyPair, this.initialSeqno, this.walletId, this.publicKey, this.validUntil, this.extensions, this.isSigAuthAllowed, this.tonlib, this.wc, this.deployAsLibrary);
        }

        public String toString() {
            return "WalletV5.WalletV5Builder(keyPair=" + String.valueOf(this.keyPair) + ", initialSeqno=" + this.initialSeqno + ", walletId=" + this.walletId + ", publicKey=" + Arrays.toString(this.publicKey) + ", validUntil=" + this.validUntil + ", extensions=" + String.valueOf(this.extensions) + ", isSigAuthAllowed=" + this.isSigAuthAllowed + ", tonlib=" + String.valueOf(this.tonlib) + ", wc=" + this.wc + ", deployAsLibrary=" + this.deployAsLibrary + ")";
        }
    }
}

