/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.types;

import java.math.BigInteger;
import org.ton.java.address.Address;

public class Royalty {
    double royalty;
    BigInteger royaltyFactor;
    BigInteger royaltyBase;
    Address royaltyAddress;

    Royalty(double royalty, BigInteger royaltyFactor, BigInteger royaltyBase, Address royaltyAddress) {
        this.royalty = royalty;
        this.royaltyFactor = royaltyFactor;
        this.royaltyBase = royaltyBase;
        this.royaltyAddress = royaltyAddress;
    }

    public static RoyaltyBuilder builder() {
        return new RoyaltyBuilder();
    }

    public double getRoyalty() {
        return this.royalty;
    }

    public BigInteger getRoyaltyFactor() {
        return this.royaltyFactor;
    }

    public BigInteger getRoyaltyBase() {
        return this.royaltyBase;
    }

    public Address getRoyaltyAddress() {
        return this.royaltyAddress;
    }

    public String toString() {
        return "Royalty(royalty=" + this.getRoyalty() + ", royaltyFactor=" + String.valueOf(this.getRoyaltyFactor()) + ", royaltyBase=" + String.valueOf(this.getRoyaltyBase()) + ", royaltyAddress=" + String.valueOf(this.getRoyaltyAddress()) + ")";
    }

    public static class RoyaltyBuilder {
        private double royalty;
        private BigInteger royaltyFactor;
        private BigInteger royaltyBase;
        private Address royaltyAddress;

        RoyaltyBuilder() {
        }

        public RoyaltyBuilder royalty(double royalty) {
            this.royalty = royalty;
            return this;
        }

        public RoyaltyBuilder royaltyFactor(BigInteger royaltyFactor) {
            this.royaltyFactor = royaltyFactor;
            return this;
        }

        public RoyaltyBuilder royaltyBase(BigInteger royaltyBase) {
            this.royaltyBase = royaltyBase;
            return this;
        }

        public RoyaltyBuilder royaltyAddress(Address royaltyAddress) {
            this.royaltyAddress = royaltyAddress;
            return this;
        }

        public Royalty build() {
            return new Royalty(this.royalty, this.royaltyFactor, this.royaltyBase, this.royaltyAddress);
        }

        public String toString() {
            return "Royalty.RoyaltyBuilder(royalty=" + this.royalty + ", royaltyFactor=" + String.valueOf(this.royaltyFactor) + ", royaltyBase=" + String.valueOf(this.royaltyBase) + ", royaltyAddress=" + String.valueOf(this.royaltyAddress) + ")";
        }
    }
}

