/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.types;

import java.math.BigInteger;
import org.ton.java.cell.Cell;

public class PendingQuery {
    BigInteger queryId;
    long creatorI;
    long cnt;
    long cntBits;
    Cell msg;

    PendingQuery(BigInteger queryId, long creatorI, long cnt, long cntBits, Cell msg) {
        this.queryId = queryId;
        this.creatorI = creatorI;
        this.cnt = cnt;
        this.cntBits = cntBits;
        this.msg = msg;
    }

    public static PendingQueryBuilder builder() {
        return new PendingQueryBuilder();
    }

    public BigInteger getQueryId() {
        return this.queryId;
    }

    public long getCreatorI() {
        return this.creatorI;
    }

    public long getCnt() {
        return this.cnt;
    }

    public long getCntBits() {
        return this.cntBits;
    }

    public Cell getMsg() {
        return this.msg;
    }

    public String toString() {
        return "PendingQuery(queryId=" + String.valueOf(this.getQueryId()) + ", creatorI=" + this.getCreatorI() + ", cnt=" + this.getCnt() + ", cntBits=" + this.getCntBits() + ", msg=" + String.valueOf(this.getMsg()) + ")";
    }

    public static class PendingQueryBuilder {
        private BigInteger queryId;
        private long creatorI;
        private long cnt;
        private long cntBits;
        private Cell msg;

        PendingQueryBuilder() {
        }

        public PendingQueryBuilder queryId(BigInteger queryId) {
            this.queryId = queryId;
            return this;
        }

        public PendingQueryBuilder creatorI(long creatorI) {
            this.creatorI = creatorI;
            return this;
        }

        public PendingQueryBuilder cnt(long cnt) {
            this.cnt = cnt;
            return this;
        }

        public PendingQueryBuilder cntBits(long cntBits) {
            this.cntBits = cntBits;
            return this;
        }

        public PendingQueryBuilder msg(Cell msg) {
            this.msg = msg;
            return this;
        }

        public PendingQuery build() {
            return new PendingQuery(this.queryId, this.creatorI, this.cnt, this.cntBits, this.msg);
        }

        public String toString() {
            return "PendingQuery.PendingQueryBuilder(queryId=" + String.valueOf(this.queryId) + ", creatorI=" + this.creatorI + ", cnt=" + this.cnt + ", cntBits=" + this.cntBits + ", msg=" + String.valueOf(this.msg) + ")";
        }
    }
}

