/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.types;

public class HighloadQueryId {
    static final int MAX_SHIFT = 8191;
    static final int MAX_BITNUMBER = 1022;
    static final int SHIFT_SIZE = 13;
    static final int BITNUMBER_SIZE = 10;
    int shift = 0;
    int bitNumber = 0;

    public static HighloadQueryId fromShiftAndBitNumber(int shift, int bitNumber) throws IllegalArgumentException {
        if (shift < 0) {
            throw new IllegalArgumentException("Shift cannot be less than 0");
        }
        if (shift > 8191) {
            throw new IllegalArgumentException("Shift cannot be greater than 8191");
        }
        if (bitNumber < 0) {
            throw new IllegalArgumentException("BitNumber cannot be less than 0");
        }
        if (bitNumber > 1022) {
            throw new IllegalArgumentException("BitNumber cannot be greater than 1022");
        }
        HighloadQueryId qid = new HighloadQueryId();
        qid.shift = shift;
        qid.bitNumber = bitNumber;
        return qid;
    }

    public static HighloadQueryId fromSeqno(int seqno) {
        return HighloadQueryId.fromShiftAndBitNumber(seqno / 1023, seqno % 1023);
    }

    public static HighloadQueryId fromQueryId(int queryId) {
        return HighloadQueryId.fromShiftAndBitNumber(queryId >> 10, queryId & 0x3FF);
    }

    public int getQueryId() {
        return (this.shift << 10) + this.bitNumber;
    }

    public boolean hasNext() {
        boolean isEnd = this.bitNumber >= 1021 && this.shift >= 8191;
        return !isEnd;
    }

    public HighloadQueryId getNext() throws IllegalStateException {
        int newBitnumber = this.bitNumber + 1;
        int newShift = this.shift;
        if (newShift >= 8191 && newBitnumber > 1021) {
            throw new IllegalStateException("Overload");
        }
        if (newBitnumber > 1022) {
            newBitnumber = 0;
            if (++newShift > 8191) {
                throw new IllegalStateException("Overload");
            }
        }
        return HighloadQueryId.fromShiftAndBitNumber(newShift, newBitnumber);
    }

    public int getShift() {
        return this.shift;
    }

    public int getBitNumber() {
        return this.bitNumber;
    }

    public int toSeqno() {
        return this.shift * 1023 + this.bitNumber;
    }
}

