/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.types;

import java.math.BigInteger;
import java.util.List;
import org.ton.java.cell.Cell;
import org.ton.java.tonlib.types.ExtraCurrency;

public class Destination {
    boolean bounce;
    int mode;
    String address;
    BigInteger amount;
    List<ExtraCurrency> extraCurrencies;
    String comment;
    Cell body;

    Destination(boolean bounce, int mode, String address, BigInteger amount, List<ExtraCurrency> extraCurrencies, String comment, Cell body) {
        this.bounce = bounce;
        this.mode = mode;
        this.address = address;
        this.amount = amount;
        this.extraCurrencies = extraCurrencies;
        this.comment = comment;
        this.body = body;
    }

    public static DestinationBuilder builder() {
        return new DestinationBuilder();
    }

    public boolean isBounce() {
        return this.bounce;
    }

    public int getMode() {
        return this.mode;
    }

    public String getAddress() {
        return this.address;
    }

    public BigInteger getAmount() {
        return this.amount;
    }

    public List<ExtraCurrency> getExtraCurrencies() {
        return this.extraCurrencies;
    }

    public String getComment() {
        return this.comment;
    }

    public Cell getBody() {
        return this.body;
    }

    public String toString() {
        return "Destination(bounce=" + this.isBounce() + ", mode=" + this.getMode() + ", address=" + this.getAddress() + ", amount=" + String.valueOf(this.getAmount()) + ", extraCurrencies=" + String.valueOf(this.getExtraCurrencies()) + ", comment=" + this.getComment() + ", body=" + String.valueOf(this.getBody()) + ")";
    }

    public static class DestinationBuilder {
        private boolean bounce;
        private int mode;
        private String address;
        private BigInteger amount;
        private List<ExtraCurrency> extraCurrencies;
        private String comment;
        private Cell body;

        DestinationBuilder() {
        }

        public DestinationBuilder bounce(boolean bounce) {
            this.bounce = bounce;
            return this;
        }

        public DestinationBuilder mode(int mode) {
            this.mode = mode;
            return this;
        }

        public DestinationBuilder address(String address) {
            this.address = address;
            return this;
        }

        public DestinationBuilder amount(BigInteger amount) {
            this.amount = amount;
            return this;
        }

        public DestinationBuilder extraCurrencies(List<ExtraCurrency> extraCurrencies) {
            this.extraCurrencies = extraCurrencies;
            return this;
        }

        public DestinationBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public DestinationBuilder body(Cell body) {
            this.body = body;
            return this;
        }

        public Destination build() {
            return new Destination(this.bounce, this.mode, this.address, this.amount, this.extraCurrencies, this.comment, this.body);
        }

        public String toString() {
            return "Destination.DestinationBuilder(bounce=" + this.bounce + ", mode=" + this.mode + ", address=" + this.address + ", amount=" + String.valueOf(this.amount) + ", extraCurrencies=" + String.valueOf(this.extraCurrencies) + ", comment=" + this.comment + ", body=" + String.valueOf(this.body) + ")";
        }
    }
}

