/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.types;

import java.math.BigInteger;
import java.util.Arrays;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;

public class ChannelData {
    long state;
    BigInteger balanceA;
    BigInteger balanceB;
    byte[] publicKeyA;
    byte[] publicKeyB;
    BigInteger channelId;
    long quarantineDuration;
    BigInteger misbehaviorFine;
    long conditionalCloseDuration;
    BigInteger seqnoA;
    BigInteger seqnoB;
    Cell quarantine;
    BigInteger excessFee;
    Address addressA;
    Address addressB;

    ChannelData(long state, BigInteger balanceA, BigInteger balanceB, byte[] publicKeyA, byte[] publicKeyB, BigInteger channelId, long quarantineDuration, BigInteger misbehaviorFine, long conditionalCloseDuration, BigInteger seqnoA, BigInteger seqnoB, Cell quarantine, BigInteger excessFee, Address addressA, Address addressB) {
        this.state = state;
        this.balanceA = balanceA;
        this.balanceB = balanceB;
        this.publicKeyA = publicKeyA;
        this.publicKeyB = publicKeyB;
        this.channelId = channelId;
        this.quarantineDuration = quarantineDuration;
        this.misbehaviorFine = misbehaviorFine;
        this.conditionalCloseDuration = conditionalCloseDuration;
        this.seqnoA = seqnoA;
        this.seqnoB = seqnoB;
        this.quarantine = quarantine;
        this.excessFee = excessFee;
        this.addressA = addressA;
        this.addressB = addressB;
    }

    public static ChannelDataBuilder builder() {
        return new ChannelDataBuilder();
    }

    public long getState() {
        return this.state;
    }

    public BigInteger getBalanceA() {
        return this.balanceA;
    }

    public BigInteger getBalanceB() {
        return this.balanceB;
    }

    public byte[] getPublicKeyA() {
        return this.publicKeyA;
    }

    public byte[] getPublicKeyB() {
        return this.publicKeyB;
    }

    public BigInteger getChannelId() {
        return this.channelId;
    }

    public long getQuarantineDuration() {
        return this.quarantineDuration;
    }

    public BigInteger getMisbehaviorFine() {
        return this.misbehaviorFine;
    }

    public long getConditionalCloseDuration() {
        return this.conditionalCloseDuration;
    }

    public BigInteger getSeqnoA() {
        return this.seqnoA;
    }

    public BigInteger getSeqnoB() {
        return this.seqnoB;
    }

    public Cell getQuarantine() {
        return this.quarantine;
    }

    public BigInteger getExcessFee() {
        return this.excessFee;
    }

    public Address getAddressA() {
        return this.addressA;
    }

    public Address getAddressB() {
        return this.addressB;
    }

    public String toString() {
        return "ChannelData(state=" + this.getState() + ", balanceA=" + String.valueOf(this.getBalanceA()) + ", balanceB=" + String.valueOf(this.getBalanceB()) + ", publicKeyA=" + Arrays.toString(this.getPublicKeyA()) + ", publicKeyB=" + Arrays.toString(this.getPublicKeyB()) + ", channelId=" + String.valueOf(this.getChannelId()) + ", quarantineDuration=" + this.getQuarantineDuration() + ", misbehaviorFine=" + String.valueOf(this.getMisbehaviorFine()) + ", conditionalCloseDuration=" + this.getConditionalCloseDuration() + ", seqnoA=" + String.valueOf(this.getSeqnoA()) + ", seqnoB=" + String.valueOf(this.getSeqnoB()) + ", quarantine=" + String.valueOf(this.getQuarantine()) + ", excessFee=" + String.valueOf(this.getExcessFee()) + ", addressA=" + String.valueOf(this.getAddressA()) + ", addressB=" + String.valueOf(this.getAddressB()) + ")";
    }

    public static class ChannelDataBuilder {
        private long state;
        private BigInteger balanceA;
        private BigInteger balanceB;
        private byte[] publicKeyA;
        private byte[] publicKeyB;
        private BigInteger channelId;
        private long quarantineDuration;
        private BigInteger misbehaviorFine;
        private long conditionalCloseDuration;
        private BigInteger seqnoA;
        private BigInteger seqnoB;
        private Cell quarantine;
        private BigInteger excessFee;
        private Address addressA;
        private Address addressB;

        ChannelDataBuilder() {
        }

        public ChannelDataBuilder state(long state) {
            this.state = state;
            return this;
        }

        public ChannelDataBuilder balanceA(BigInteger balanceA) {
            this.balanceA = balanceA;
            return this;
        }

        public ChannelDataBuilder balanceB(BigInteger balanceB) {
            this.balanceB = balanceB;
            return this;
        }

        public ChannelDataBuilder publicKeyA(byte[] publicKeyA) {
            this.publicKeyA = publicKeyA;
            return this;
        }

        public ChannelDataBuilder publicKeyB(byte[] publicKeyB) {
            this.publicKeyB = publicKeyB;
            return this;
        }

        public ChannelDataBuilder channelId(BigInteger channelId) {
            this.channelId = channelId;
            return this;
        }

        public ChannelDataBuilder quarantineDuration(long quarantineDuration) {
            this.quarantineDuration = quarantineDuration;
            return this;
        }

        public ChannelDataBuilder misbehaviorFine(BigInteger misbehaviorFine) {
            this.misbehaviorFine = misbehaviorFine;
            return this;
        }

        public ChannelDataBuilder conditionalCloseDuration(long conditionalCloseDuration) {
            this.conditionalCloseDuration = conditionalCloseDuration;
            return this;
        }

        public ChannelDataBuilder seqnoA(BigInteger seqnoA) {
            this.seqnoA = seqnoA;
            return this;
        }

        public ChannelDataBuilder seqnoB(BigInteger seqnoB) {
            this.seqnoB = seqnoB;
            return this;
        }

        public ChannelDataBuilder quarantine(Cell quarantine) {
            this.quarantine = quarantine;
            return this;
        }

        public ChannelDataBuilder excessFee(BigInteger excessFee) {
            this.excessFee = excessFee;
            return this;
        }

        public ChannelDataBuilder addressA(Address addressA) {
            this.addressA = addressA;
            return this;
        }

        public ChannelDataBuilder addressB(Address addressB) {
            this.addressB = addressB;
            return this;
        }

        public ChannelData build() {
            return new ChannelData(this.state, this.balanceA, this.balanceB, this.publicKeyA, this.publicKeyB, this.channelId, this.quarantineDuration, this.misbehaviorFine, this.conditionalCloseDuration, this.seqnoA, this.seqnoB, this.quarantine, this.excessFee, this.addressA, this.addressB);
        }

        public String toString() {
            return "ChannelData.ChannelDataBuilder(state=" + this.state + ", balanceA=" + String.valueOf(this.balanceA) + ", balanceB=" + String.valueOf(this.balanceB) + ", publicKeyA=" + Arrays.toString(this.publicKeyA) + ", publicKeyB=" + Arrays.toString(this.publicKeyB) + ", channelId=" + String.valueOf(this.channelId) + ", quarantineDuration=" + this.quarantineDuration + ", misbehaviorFine=" + String.valueOf(this.misbehaviorFine) + ", conditionalCloseDuration=" + this.conditionalCloseDuration + ", seqnoA=" + String.valueOf(this.seqnoA) + ", seqnoB=" + String.valueOf(this.seqnoB) + ", quarantine=" + String.valueOf(this.quarantine) + ", excessFee=" + String.valueOf(this.excessFee) + ", addressA=" + String.valueOf(this.addressA) + ", addressB=" + String.valueOf(this.addressB) + ")";
        }
    }
}

