/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.token.nft;

import java.math.BigInteger;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.smartcontract.token.nft.NftUtils;
import org.ton.java.smartcontract.types.NftSaleData;
import org.ton.java.smartcontract.wallet.Contract;
import org.ton.java.tonlib.Tonlib;
import org.ton.java.tonlib.types.RunResult;
import org.ton.java.tonlib.types.TvmStackEntryNumber;
import org.ton.java.tonlib.types.TvmStackEntrySlice;
import org.ton.java.utils.Utils;

public class NftSale
implements Contract {
    public static final String NFT_SALE_HEX_CODE = "B5EE9C7241020A010001B4000114FF00F4A413F4BCF2C80B01020120020302014804050004F2300202CD0607002FA03859DA89A1F481F481F481F401A861A1F401F481F4006101F7D00E8698180B8D8492F82707D201876A2687D207D207D207D006A18116BA4E10159C71D991B1B2990E382C92F837028916382F970FA01698FC1080289C6C8895D7970FAE99F98FD2018201A642802E78B2801E78B00E78B00FD016664F6AA701363804C9B081B2299823878027003698FE99F9810E000C92F857010C0801F5D41081DCD650029285029185F7970E101E87D007D207D0018384008646582A804E78B28B9D090D0A85AD08A500AFD010AE5B564B8FD80384008646582AC678B2803FD010B65B564B8FD80384008646582A802E78B00FD0109E5B564B8FD80381041082FE61E8A10C00C646582A802E78B117D010A65B509E58F8A40900C8C0029A3110471036454012F004E032363704C0038E4782103B9ACA0015BEF2E1C95312C70559C705B1F2E1CA702082105FCC3D14218010C8CB055006CF1622FA0215CB6A14CB1F14CB3F21CF1601CF16CA0021FA02CA00C98100A0FB00E05F06840FF2F0002ACB3F22CF1658CF16CA0021FA02CA00C98100A0FB00AECABAD1";
    Address marketplaceAddress;
    Address nftItemAddress;
    BigInteger fullPrice;
    BigInteger marketplaceFee;
    BigInteger royaltyAmount;
    Address royaltyAddress;
    private Tonlib tonlib;
    private long wc;

    public static NftSaleBuilder builder() {
        return new CustomNftSaleBuilder();
    }

    @Override
    public Tonlib getTonlib() {
        return this.tonlib;
    }

    @Override
    public void setTonlib(Tonlib pTonlib) {
        this.tonlib = pTonlib;
    }

    @Override
    public long getWorkchain() {
        return this.wc;
    }

    @Override
    public String getName() {
        return "nftSale";
    }

    @Override
    public Cell createDataCell() {
        return CellBuilder.beginCell().storeAddress(this.marketplaceAddress).storeAddress(this.nftItemAddress).storeAddress(null).storeCoins(this.fullPrice).storeRef(CellBuilder.beginCell().storeCoins(this.marketplaceFee).storeAddress(this.royaltyAddress).storeCoins(this.royaltyAmount).endCell()).endCell();
    }

    @Override
    public Cell createCodeCell() {
        return CellBuilder.beginCell().fromBoc(NFT_SALE_HEX_CODE).endCell();
    }

    public NftSaleData getData(Tonlib tonlib) {
        Address myAddress = this.getAddress();
        RunResult result = tonlib.runMethod(myAddress, "get_sale_data");
        if (result.getExit_code() != 0L) {
            throw new Error("method get_sale_data, returned an exit code " + result.getExit_code());
        }
        TvmStackEntrySlice marketplaceAddressCell = (TvmStackEntrySlice)result.getStack().get(0);
        Address marketplaceAddress = NftUtils.parseAddress(CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)marketplaceAddressCell.getSlice().getBytes())).endCell());
        TvmStackEntrySlice nftAddressCell = (TvmStackEntrySlice)result.getStack().get(1);
        Address nftAddress = NftUtils.parseAddress(CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)nftAddressCell.getSlice().getBytes())).endCell());
        TvmStackEntrySlice nftOwnerAddressCell = (TvmStackEntrySlice)result.getStack().get(2);
        Address nftOwnerAddress = null;
        try {
            nftOwnerAddress = NftUtils.parseAddress(CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)nftOwnerAddressCell.getSlice().getBytes())).endCell());
        }
        catch (Exception exception) {
            // empty catch block
        }
        TvmStackEntryNumber fullPriceNumber = (TvmStackEntryNumber)result.getStack().get(3);
        BigInteger fullPrice = fullPriceNumber.getNumber();
        TvmStackEntryNumber marketplaceFeeNumber = (TvmStackEntryNumber)result.getStack().get(4);
        BigInteger marketplaceFee = marketplaceFeeNumber.getNumber();
        TvmStackEntrySlice royaltyAddressCell = (TvmStackEntrySlice)result.getStack().get(5);
        Address royaltyAddress = NftUtils.parseAddress(CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)royaltyAddressCell.getSlice().getBytes())).endCell());
        TvmStackEntryNumber royaltyAmountNumber = (TvmStackEntryNumber)result.getStack().get(6);
        BigInteger royaltyAmount = royaltyAmountNumber.getNumber();
        return NftSaleData.builder().marketplaceAddress(marketplaceAddress).nftAddress(nftAddress).nftOwnerAddress(nftOwnerAddress).fullPrice(fullPrice).marketplaceFee(marketplaceFee).royaltyAddress(royaltyAddress).royaltyAmount(royaltyAmount).build();
    }

    public static Cell createCancelBody(long queryId) {
        CellBuilder cell = CellBuilder.beginCell();
        cell.storeUint(3, 32);
        cell.storeUint(queryId, 64);
        return cell.endCell();
    }

    NftSale(Address marketplaceAddress, Address nftItemAddress, BigInteger fullPrice, BigInteger marketplaceFee, BigInteger royaltyAmount, Address royaltyAddress, Tonlib tonlib, long wc) {
        this.marketplaceAddress = marketplaceAddress;
        this.nftItemAddress = nftItemAddress;
        this.fullPrice = fullPrice;
        this.marketplaceFee = marketplaceFee;
        this.royaltyAmount = royaltyAmount;
        this.royaltyAddress = royaltyAddress;
        this.tonlib = tonlib;
        this.wc = wc;
    }

    public Address getMarketplaceAddress() {
        return this.marketplaceAddress;
    }

    public Address getNftItemAddress() {
        return this.nftItemAddress;
    }

    public BigInteger getFullPrice() {
        return this.fullPrice;
    }

    public BigInteger getMarketplaceFee() {
        return this.marketplaceFee;
    }

    public BigInteger getRoyaltyAmount() {
        return this.royaltyAmount;
    }

    public Address getRoyaltyAddress() {
        return this.royaltyAddress;
    }

    public long getWc() {
        return this.wc;
    }

    private static class CustomNftSaleBuilder
    extends NftSaleBuilder {
        private CustomNftSaleBuilder() {
        }

        @Override
        public NftSale build() {
            return super.build();
        }
    }

    public static class NftSaleBuilder {
        private Address marketplaceAddress;
        private Address nftItemAddress;
        private BigInteger fullPrice;
        private BigInteger marketplaceFee;
        private BigInteger royaltyAmount;
        private Address royaltyAddress;
        private Tonlib tonlib;
        private long wc;

        NftSaleBuilder() {
        }

        public NftSaleBuilder marketplaceAddress(Address marketplaceAddress) {
            this.marketplaceAddress = marketplaceAddress;
            return this;
        }

        public NftSaleBuilder nftItemAddress(Address nftItemAddress) {
            this.nftItemAddress = nftItemAddress;
            return this;
        }

        public NftSaleBuilder fullPrice(BigInteger fullPrice) {
            this.fullPrice = fullPrice;
            return this;
        }

        public NftSaleBuilder marketplaceFee(BigInteger marketplaceFee) {
            this.marketplaceFee = marketplaceFee;
            return this;
        }

        public NftSaleBuilder royaltyAmount(BigInteger royaltyAmount) {
            this.royaltyAmount = royaltyAmount;
            return this;
        }

        public NftSaleBuilder royaltyAddress(Address royaltyAddress) {
            this.royaltyAddress = royaltyAddress;
            return this;
        }

        public NftSaleBuilder tonlib(Tonlib tonlib) {
            this.tonlib = tonlib;
            return this;
        }

        public NftSaleBuilder wc(long wc) {
            this.wc = wc;
            return this;
        }

        public NftSale build() {
            return new NftSale(this.marketplaceAddress, this.nftItemAddress, this.fullPrice, this.marketplaceFee, this.royaltyAmount, this.royaltyAddress, this.tonlib, this.wc);
        }

        public String toString() {
            return "NftSale.NftSaleBuilder(marketplaceAddress=" + String.valueOf(this.marketplaceAddress) + ", nftItemAddress=" + String.valueOf(this.nftItemAddress) + ", fullPrice=" + String.valueOf(this.fullPrice) + ", marketplaceFee=" + String.valueOf(this.marketplaceFee) + ", royaltyAmount=" + String.valueOf(this.royaltyAmount) + ", royaltyAddress=" + String.valueOf(this.royaltyAddress) + ", tonlib=" + String.valueOf(this.tonlib) + ", wc=" + this.wc + ")";
        }
    }
}

