/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.token.ft;

import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.smartcontract.token.ft.JettonWalletStableCoin;
import org.ton.java.smartcontract.token.nft.NftUtils;
import org.ton.java.smartcontract.types.JettonMinterData;
import org.ton.java.smartcontract.types.WalletCodes;
import org.ton.java.smartcontract.wallet.Contract;
import org.ton.java.tonlib.Tonlib;
import org.ton.java.tonlib.types.RunResult;
import org.ton.java.tonlib.types.TvmStackEntryCell;
import org.ton.java.tonlib.types.TvmStackEntryNumber;
import org.ton.java.tonlib.types.TvmStackEntrySlice;
import org.ton.java.utils.Utils;

public class JettonMinterStableCoin
implements Contract {
    private static final Logger log = LoggerFactory.getLogger(JettonMinterStableCoin.class);
    Address adminAddress;
    Address nextAdminAddress;
    Cell content;
    String jettonWalletCodeHex;
    Address customAddress;
    String code;
    private Tonlib tonlib;
    private long wc;

    public static JettonMinterStableCoinBuilder builder() {
        return new CustomJettonMinterStableCoinBuilder();
    }

    @Override
    public Tonlib getTonlib() {
        return this.tonlib;
    }

    @Override
    public void setTonlib(Tonlib pTonlib) {
        this.tonlib = pTonlib;
    }

    @Override
    public long getWorkchain() {
        return this.wc;
    }

    @Override
    public String getName() {
        return "jettonMinterStableCoin";
    }

    @Override
    public Cell createDataCell() {
        if (StringUtils.isNotEmpty((CharSequence)this.code)) {
            log.info("Using custom JettonMinter");
            return CellBuilder.beginCell().storeCoins(BigInteger.ZERO).storeAddress(this.adminAddress).storeAddress(this.nextAdminAddress).storeRef(CellBuilder.beginCell().fromBoc(this.code).endCell()).storeRef(this.content).endCell();
        }
        return CellBuilder.beginCell().storeCoins(BigInteger.ZERO).storeAddress(this.adminAddress).storeAddress(this.nextAdminAddress).storeRef(CellBuilder.beginCell().fromBoc(WalletCodes.jettonMinterStableCoin.getValue()).endCell()).storeRef(this.content).endCell();
    }

    @Override
    public Cell createCodeCell() {
        if (StringUtils.isNotEmpty((CharSequence)this.code)) {
            log.info("Using custom JettonMinter");
            return CellBuilder.beginCell().fromBoc(this.code).endCell();
        }
        return CellBuilder.beginCell().fromBoc(WalletCodes.jettonMinterStableCoin.getValue()).endCell();
    }

    public static Cell createMintBody(long queryId, Address destination, BigInteger amount, BigInteger jettonAmount, Address fromAddress, Address responseAddress, BigInteger forwardAmount, Cell forwardPayload) {
        return CellBuilder.beginCell().storeUint(1680571655, 32).storeUint(queryId, 64).storeAddress(destination).storeCoins(amount).storeRef(CellBuilder.beginCell().storeUint(395134233, 32).storeUint(queryId, 64).storeCoins(jettonAmount).storeAddress(fromAddress).storeAddress(responseAddress).storeCoins(forwardAmount).storeBit(Boolean.valueOf(false)).storeCell(forwardPayload).endCell()).endCell();
    }

    public static Cell createChangeAdminBody(long queryId, Address newAdminAddress) {
        if (Objects.isNull(newAdminAddress)) {
            throw new Error("Specify newAdminAddress");
        }
        return CellBuilder.beginCell().storeUint(1694626644, 32).storeUint(queryId, 64).storeAddress(newAdminAddress).endCell();
    }

    public static Cell createUpgradeBody(long queryId, Cell data, Cell code) {
        return CellBuilder.beginCell().storeUint(621336170, 32).storeUint(queryId, 64).storeRef(data).storeRef(code).endCell();
    }

    public static Cell createChangeMetaDataUriBody(String jettonContentUri, long queryId) {
        return CellBuilder.beginCell().storeUint(-880400126, 32).storeUint(queryId, 64).storeRef(NftUtils.createOffChainUriCell(jettonContentUri)).endCell();
    }

    public static Cell createClaimAdminBody(long queryId) {
        return CellBuilder.beginCell().storeUint(-74915559, 32).storeUint(queryId, 64).endCell();
    }

    public static Cell createCallToBody(long queryId, Address toAddress, BigInteger tonAmount, Cell masterMsg) {
        return CellBuilder.beginCell().storeUint(593276754, 32).storeUint(queryId, 64).storeAddress(toAddress).storeCoins(tonAmount).storeRef(masterMsg).endCell();
    }

    public JettonMinterData getJettonData() {
        RunResult result = Objects.nonNull(this.customAddress) ? this.tonlib.runMethod(this.customAddress, "get_jetton_data") : this.tonlib.runMethod(this.getAddress(), "get_jetton_data");
        if (result.getExit_code() != 0L) {
            throw new Error("method get_jetton_data, returned an exit code " + result.getExit_code());
        }
        TvmStackEntryNumber totalSupplyNumber = (TvmStackEntryNumber)result.getStack().get(0);
        BigInteger totalSupply = totalSupplyNumber.getNumber();
        boolean isMutable = ((TvmStackEntryNumber)result.getStack().get(1)).getNumber().longValue() == -1L;
        TvmStackEntrySlice adminAddr = (TvmStackEntrySlice)result.getStack().get(2);
        Address adminAddress = NftUtils.parseAddress(CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)adminAddr.getSlice().getBytes())).endCell());
        TvmStackEntryCell jettonContent = (TvmStackEntryCell)result.getStack().get(3);
        Cell jettonContentCell = CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)jettonContent.getCell().getBytes())).endCell();
        String jettonContentUri = null;
        jettonContentUri = NftUtils.parseOnChainUriCell(jettonContentCell);
        TvmStackEntryCell contentC = (TvmStackEntryCell)result.getStack().get(4);
        Cell jettonWalletCode = CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)contentC.getCell().getBytes())).endCell();
        return JettonMinterData.builder().totalSupply(totalSupply).isMutable(isMutable).adminAddress(adminAddress).jettonContentCell(jettonContentCell).jettonContentUri(jettonContentUri).jettonWalletCode(jettonWalletCode).build();
    }

    public BigInteger getTotalSupply() {
        RunResult result = Objects.nonNull(this.customAddress) ? this.tonlib.runMethod(this.customAddress, "get_jetton_data") : this.tonlib.runMethod(this.getAddress(), "get_jetton_data");
        TvmStackEntryNumber totalSupplyNumber = (TvmStackEntryNumber)result.getStack().get(0);
        return totalSupplyNumber.getNumber();
    }

    public JettonWalletStableCoin getJettonWallet(Address ownerAddress) {
        CellBuilder cell = CellBuilder.beginCell();
        cell.storeAddress(ownerAddress);
        ArrayDeque<CallSite> stack = new ArrayDeque<CallSite>();
        stack.offer((CallSite)((Object)("[slice, " + cell.endCell().toHex(true) + "]")));
        RunResult result = Objects.nonNull(this.customAddress) ? this.tonlib.runMethod(this.customAddress, "get_wallet_address", stack) : this.tonlib.runMethod(this.getAddress(), "get_wallet_address", stack);
        if (result.getExit_code() != 0L) {
            throw new Error("method get_wallet_address, returned an exit code " + result.getExit_code());
        }
        TvmStackEntrySlice addr = (TvmStackEntrySlice)result.getStack().get(0);
        Address jettonWalletAddress = NftUtils.parseAddress(CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)addr.getSlice().getBytes())).endCell());
        return JettonWalletStableCoin.builder().tonlib(this.tonlib).address(jettonWalletAddress).build();
    }

    JettonMinterStableCoin(Address adminAddress, Address nextAdminAddress, Cell content, String jettonWalletCodeHex, Address customAddress, String code, Tonlib tonlib, long wc) {
        this.adminAddress = adminAddress;
        this.nextAdminAddress = nextAdminAddress;
        this.content = content;
        this.jettonWalletCodeHex = jettonWalletCodeHex;
        this.customAddress = customAddress;
        this.code = code;
        this.tonlib = tonlib;
        this.wc = wc;
    }

    public Address getAdminAddress() {
        return this.adminAddress;
    }

    public Address getNextAdminAddress() {
        return this.nextAdminAddress;
    }

    public Cell getContent() {
        return this.content;
    }

    public String getJettonWalletCodeHex() {
        return this.jettonWalletCodeHex;
    }

    public Address getCustomAddress() {
        return this.customAddress;
    }

    public String getCode() {
        return this.code;
    }

    public long getWc() {
        return this.wc;
    }

    private static class CustomJettonMinterStableCoinBuilder
    extends JettonMinterStableCoinBuilder {
        private CustomJettonMinterStableCoinBuilder() {
        }

        @Override
        public JettonMinterStableCoin build() {
            return super.build();
        }
    }

    public static class JettonMinterStableCoinBuilder {
        private Address adminAddress;
        private Address nextAdminAddress;
        private Cell content;
        private String jettonWalletCodeHex;
        private Address customAddress;
        private String code;
        private Tonlib tonlib;
        private long wc;

        JettonMinterStableCoinBuilder() {
        }

        public JettonMinterStableCoinBuilder adminAddress(Address adminAddress) {
            this.adminAddress = adminAddress;
            return this;
        }

        public JettonMinterStableCoinBuilder nextAdminAddress(Address nextAdminAddress) {
            this.nextAdminAddress = nextAdminAddress;
            return this;
        }

        public JettonMinterStableCoinBuilder content(Cell content) {
            this.content = content;
            return this;
        }

        public JettonMinterStableCoinBuilder jettonWalletCodeHex(String jettonWalletCodeHex) {
            this.jettonWalletCodeHex = jettonWalletCodeHex;
            return this;
        }

        public JettonMinterStableCoinBuilder customAddress(Address customAddress) {
            this.customAddress = customAddress;
            return this;
        }

        public JettonMinterStableCoinBuilder code(String code) {
            this.code = code;
            return this;
        }

        public JettonMinterStableCoinBuilder tonlib(Tonlib tonlib) {
            this.tonlib = tonlib;
            return this;
        }

        public JettonMinterStableCoinBuilder wc(long wc) {
            this.wc = wc;
            return this;
        }

        public JettonMinterStableCoin build() {
            return new JettonMinterStableCoin(this.adminAddress, this.nextAdminAddress, this.content, this.jettonWalletCodeHex, this.customAddress, this.code, this.tonlib, this.wc);
        }

        public String toString() {
            return "JettonMinterStableCoin.JettonMinterStableCoinBuilder(adminAddress=" + String.valueOf(this.adminAddress) + ", nextAdminAddress=" + String.valueOf(this.nextAdminAddress) + ", content=" + String.valueOf(this.content) + ", jettonWalletCodeHex=" + this.jettonWalletCodeHex + ", customAddress=" + String.valueOf(this.customAddress) + ", code=" + this.code + ", tonlib=" + String.valueOf(this.tonlib) + ", wc=" + this.wc + ")";
        }
    }
}

