/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.token.ft;

import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.smartcontract.token.ft.JettonWallet;
import org.ton.java.smartcontract.token.nft.NftUtils;
import org.ton.java.smartcontract.types.JettonMinterData;
import org.ton.java.smartcontract.types.WalletCodes;
import org.ton.java.smartcontract.wallet.Contract;
import org.ton.java.tonlib.Tonlib;
import org.ton.java.tonlib.types.RunResult;
import org.ton.java.tonlib.types.TvmStackEntryCell;
import org.ton.java.tonlib.types.TvmStackEntryNumber;
import org.ton.java.tonlib.types.TvmStackEntrySlice;
import org.ton.java.utils.Utils;

public class JettonMinter
implements Contract {
    private static final Logger log = LoggerFactory.getLogger(JettonMinter.class);
    Address adminAddress;
    Cell content;
    String jettonWalletCodeHex;
    Address customAddress;
    String code;
    private Tonlib tonlib;
    private long wc;

    public static JettonMinterBuilder builder() {
        return new CustomJettonMinterBuilder();
    }

    @Override
    public Tonlib getTonlib() {
        return this.tonlib;
    }

    @Override
    public void setTonlib(Tonlib pTonlib) {
        this.tonlib = pTonlib;
    }

    @Override
    public long getWorkchain() {
        return this.wc;
    }

    @Override
    public String getName() {
        return "jettonMinter";
    }

    @Override
    public Cell createDataCell() {
        if (StringUtils.isNotEmpty((CharSequence)this.code)) {
            return CellBuilder.beginCell().storeCoins(BigInteger.ZERO).storeAddress(this.adminAddress).storeRef(this.content).storeRef(CellBuilder.beginCell().fromBoc(this.code).endCell()).endCell();
        }
        return CellBuilder.beginCell().storeCoins(BigInteger.ZERO).storeAddress(this.adminAddress).storeRef(this.content).storeRef(CellBuilder.beginCell().fromBoc(this.jettonWalletCodeHex).endCell()).endCell();
    }

    @Override
    public Cell createCodeCell() {
        if (StringUtils.isNotEmpty((CharSequence)this.code)) {
            log.info("Using custom JettonMinter");
            return CellBuilder.beginCell().fromBoc(this.code).endCell();
        }
        return CellBuilder.beginCell().fromBoc(WalletCodes.jettonMinter.getValue()).endCell();
    }

    public static Cell createMintBody(long queryId, Address destination, BigInteger amount, BigInteger jettonAmount, Address fromAddress, Address responseAddress, BigInteger forwardTonAmount, Cell forwardPayload) {
        return CellBuilder.beginCell().storeUint(21, 32).storeUint(queryId, 64).storeAddress(destination).storeCoins(amount).storeRef(CellBuilder.beginCell().storeUint(395134233, 32).storeUint(queryId, 64).storeCoins(jettonAmount).storeAddress(fromAddress).storeAddress(responseAddress).storeCoins(forwardTonAmount).storeBit(Boolean.valueOf(false)).storeCell(forwardPayload).endCell()).endCell();
    }

    public Cell createChangeAdminBody(long queryId, Address newAdminAddress) {
        if (Objects.isNull(newAdminAddress)) {
            throw new Error("Specify newAdminAddress");
        }
        return CellBuilder.beginCell().storeUint(3, 32).storeUint(queryId, 64).storeAddress(newAdminAddress).endCell();
    }

    public Cell createEditContentBody(String jettonContentUri, long queryId) {
        return CellBuilder.beginCell().storeUint(4, 32).storeUint(queryId, 64).storeRef(NftUtils.createOffChainUriCell(jettonContentUri)).endCell();
    }

    public JettonMinterData getJettonData(Tonlib tonlib) {
        RunResult result = Objects.nonNull(this.customAddress) ? tonlib.runMethod(this.customAddress, "get_jetton_data") : tonlib.runMethod(this.getAddress(), "get_jetton_data");
        if (result.getExit_code() != 0L) {
            throw new Error("method get_jetton_data, returned an exit code " + result.getExit_code());
        }
        TvmStackEntryNumber totalSupplyNumber = (TvmStackEntryNumber)result.getStack().get(0);
        BigInteger totalSupply = totalSupplyNumber.getNumber();
        boolean isMutable = ((TvmStackEntryNumber)result.getStack().get(1)).getNumber().longValue() == -1L;
        TvmStackEntrySlice adminAddr = (TvmStackEntrySlice)result.getStack().get(2);
        Address adminAddress = NftUtils.parseAddress(CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)adminAddr.getSlice().getBytes())).endCell());
        TvmStackEntryCell jettonContent = (TvmStackEntryCell)result.getStack().get(3);
        Cell jettonContentCell = CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)jettonContent.getCell().getBytes())).endCell();
        String jettonContentUri = null;
        try {
            jettonContentUri = NftUtils.parseOffChainUriCell(jettonContentCell);
        }
        catch (Error error) {
            // empty catch block
        }
        TvmStackEntryCell contentC = (TvmStackEntryCell)result.getStack().get(4);
        Cell jettonWalletCode = CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)contentC.getCell().getBytes())).endCell();
        return JettonMinterData.builder().totalSupply(totalSupply).isMutable(isMutable).adminAddress(adminAddress).jettonContentCell(jettonContentCell).jettonContentUri(jettonContentUri).jettonWalletCode(jettonWalletCode).build();
    }

    public BigInteger getTotalSupply() {
        RunResult result = Objects.nonNull(this.customAddress) ? this.tonlib.runMethod(this.customAddress, "get_jetton_data") : this.tonlib.runMethod(this.getAddress(), "get_jetton_data");
        if (result.getExit_code() != 0L) {
            throw new Error("method get_jetton_data, returned an exit code " + result.getExit_code());
        }
        TvmStackEntryNumber totalSupplyNumber = (TvmStackEntryNumber)result.getStack().get(0);
        return totalSupplyNumber.getNumber();
    }

    public JettonWallet getJettonWallet(Address ownerAddress) {
        CellBuilder cell = CellBuilder.beginCell();
        cell.storeAddress(ownerAddress);
        ArrayDeque<CallSite> stack = new ArrayDeque<CallSite>();
        stack.offer((CallSite)((Object)("[slice, " + cell.endCell().toHex(true) + "]")));
        RunResult result = Objects.nonNull(this.customAddress) ? this.tonlib.runMethod(this.customAddress, "get_wallet_address", stack) : this.tonlib.runMethod(this.getAddress(), "get_wallet_address", stack);
        if (result.getExit_code() != 0L) {
            throw new Error("method get_wallet_address, returned an exit code " + result.getExit_code());
        }
        TvmStackEntrySlice addr = (TvmStackEntrySlice)result.getStack().get(0);
        Address jettonWalletAddress = NftUtils.parseAddress(CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)addr.getSlice().getBytes())).endCell());
        return JettonWallet.builder().tonlib(this.tonlib).address(jettonWalletAddress).build();
    }

    JettonMinter(Address adminAddress, Cell content, String jettonWalletCodeHex, Address customAddress, String code, Tonlib tonlib, long wc) {
        this.adminAddress = adminAddress;
        this.content = content;
        this.jettonWalletCodeHex = jettonWalletCodeHex;
        this.customAddress = customAddress;
        this.code = code;
        this.tonlib = tonlib;
        this.wc = wc;
    }

    public Address getAdminAddress() {
        return this.adminAddress;
    }

    public Cell getContent() {
        return this.content;
    }

    public String getJettonWalletCodeHex() {
        return this.jettonWalletCodeHex;
    }

    public Address getCustomAddress() {
        return this.customAddress;
    }

    public String getCode() {
        return this.code;
    }

    public long getWc() {
        return this.wc;
    }

    private static class CustomJettonMinterBuilder
    extends JettonMinterBuilder {
        private CustomJettonMinterBuilder() {
        }

        @Override
        public JettonMinter build() {
            return super.build();
        }
    }

    public static class JettonMinterBuilder {
        private Address adminAddress;
        private Cell content;
        private String jettonWalletCodeHex;
        private Address customAddress;
        private String code;
        private Tonlib tonlib;
        private long wc;

        JettonMinterBuilder() {
        }

        public JettonMinterBuilder adminAddress(Address adminAddress) {
            this.adminAddress = adminAddress;
            return this;
        }

        public JettonMinterBuilder content(Cell content) {
            this.content = content;
            return this;
        }

        public JettonMinterBuilder jettonWalletCodeHex(String jettonWalletCodeHex) {
            this.jettonWalletCodeHex = jettonWalletCodeHex;
            return this;
        }

        public JettonMinterBuilder customAddress(Address customAddress) {
            this.customAddress = customAddress;
            return this;
        }

        public JettonMinterBuilder code(String code) {
            this.code = code;
            return this;
        }

        public JettonMinterBuilder tonlib(Tonlib tonlib) {
            this.tonlib = tonlib;
            return this;
        }

        public JettonMinterBuilder wc(long wc) {
            this.wc = wc;
            return this;
        }

        public JettonMinter build() {
            return new JettonMinter(this.adminAddress, this.content, this.jettonWalletCodeHex, this.customAddress, this.code, this.tonlib, this.wc);
        }

        public String toString() {
            return "JettonMinter.JettonMinterBuilder(adminAddress=" + String.valueOf(this.adminAddress) + ", content=" + String.valueOf(this.content) + ", jettonWalletCodeHex=" + this.jettonWalletCodeHex + ", customAddress=" + String.valueOf(this.customAddress) + ", code=" + this.code + ", tonlib=" + String.valueOf(this.tonlib) + ", wc=" + this.wc + ")";
        }
    }
}

