/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.dns;

import java.math.BigInteger;
import java.util.Objects;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.smartcontract.dns.DnsUtils;
import org.ton.java.smartcontract.token.nft.NftUtils;
import org.ton.java.smartcontract.types.AuctionInfo;
import org.ton.java.smartcontract.types.ItemData;
import org.ton.java.smartcontract.types.WalletCodes;
import org.ton.java.smartcontract.wallet.Contract;
import org.ton.java.tonlib.Tonlib;
import org.ton.java.tonlib.types.RunResult;
import org.ton.java.tonlib.types.TvmStackEntryCell;
import org.ton.java.tonlib.types.TvmStackEntryNumber;
import org.ton.java.tonlib.types.TvmStackEntrySlice;
import org.ton.java.utils.Utils;

public class DnsItem
implements Contract {
    BigInteger index;
    Address collectionAddress;
    private Tonlib tonlib;
    private long wc;

    @Override
    public Tonlib getTonlib() {
        return this.tonlib;
    }

    @Override
    public void setTonlib(Tonlib pTonlib) {
        this.tonlib = pTonlib;
    }

    @Override
    public long getWorkchain() {
        return this.wc;
    }

    public static DnsItemBuilder builder() {
        return new CustomDnsItemBuilder();
    }

    @Override
    public String getName() {
        return "dnsItem";
    }

    @Override
    public Cell createDataCell() {
        return CellBuilder.beginCell().storeUint(this.index, 256).storeAddress(this.collectionAddress).endCell();
    }

    @Override
    public Cell createCodeCell() {
        return CellBuilder.beginCell().fromBoc(WalletCodes.dnsItem.getValue()).endCell();
    }

    public static ItemData getData(Tonlib tonlib, Address dnsItemAddress) {
        RunResult result = tonlib.runMethod(dnsItemAddress, "get_nft_data");
        if (result.getExit_code() != 0L) {
            throw new Error("method get_nft_data, returned an exit code " + result.getExit_code());
        }
        TvmStackEntryNumber isInitializedNumber = (TvmStackEntryNumber)result.getStack().get(0);
        boolean isInitialized = isInitializedNumber.getNumber().longValue() == -1L;
        BigInteger index = ((TvmStackEntryNumber)result.getStack().get(1)).getNumber();
        TvmStackEntrySlice collectionAddr = (TvmStackEntrySlice)result.getStack().get(2);
        Address collectionAddress = NftUtils.parseAddress(CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)collectionAddr.getSlice().getBytes())).endCell());
        TvmStackEntrySlice ownerAddr = (TvmStackEntrySlice)result.getStack().get(3);
        Address ownerAddress = isInitialized ? NftUtils.parseAddress(CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)ownerAddr.getSlice().getBytes())).endCell()) : null;
        TvmStackEntryCell contentC = (TvmStackEntryCell)result.getStack().get(4);
        Cell contentCell = CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)contentC.getCell().getBytes())).endCell();
        return ItemData.builder().isInitialized(isInitialized).index(index).collectionAddress(collectionAddress).ownerAddress(ownerAddress).contentCell(contentCell).build();
    }

    public static Cell createTransferBody(long queryId, Address newOwnerAddress, BigInteger forwardAmount, byte[] forwardPayload, Address responseAddress) {
        CellBuilder cell = CellBuilder.beginCell();
        cell.storeUint(1607220500, 32);
        cell.storeUint(queryId, 64);
        cell.storeAddress(newOwnerAddress);
        cell.storeAddress(responseAddress);
        cell.storeBit(Boolean.valueOf(false));
        cell.storeCoins(forwardAmount);
        cell.storeBit(Boolean.valueOf(false));
        if (Objects.nonNull(forwardPayload)) {
            cell.storeBytes(forwardPayload);
        }
        return cell.endCell();
    }

    public static Cell createStaticDataBody(long queryId) {
        return CellBuilder.beginCell().storeUint(801842850, 32).storeUint(queryId, 64).endCell();
    }

    public static String getDomain(Tonlib tonlib, Address dnsItemAddress) {
        RunResult result = tonlib.runMethod(dnsItemAddress, "get_domain");
        if (result.getExit_code() != 0L) {
            throw new Error("method get_domain, returned an exit code " + result.getExit_code());
        }
        TvmStackEntrySlice domainCell = (TvmStackEntrySlice)result.getStack().get(0);
        return new String(CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)domainCell.getSlice().getBytes())).endCell().getBits().toByteArray());
    }

    public static Address getEditor(Tonlib tonlib, Address dnsItemAddress) {
        RunResult result = tonlib.runMethod(dnsItemAddress, "get_editor");
        if (result.getExit_code() != 0L) {
            throw new Error("method get_editor, returned an exit code " + result.getExit_code());
        }
        TvmStackEntrySlice editorCell = (TvmStackEntrySlice)result.getStack().get(0);
        return NftUtils.parseAddress(CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)editorCell.getSlice().getBytes())).endCell());
    }

    public static AuctionInfo getAuctionInfo(Tonlib tonlib, Address dnsItemAddress) {
        RunResult result = tonlib.runMethod(dnsItemAddress, "get_auction_info");
        if (result.getExit_code() != 0L) {
            throw new Error("method get_auction_info, returned an exit code " + result.getExit_code());
        }
        TvmStackEntrySlice maxBidAddressCell = (TvmStackEntrySlice)result.getStack().get(0);
        Address maxBidAddress = NftUtils.parseAddress(CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)maxBidAddressCell.getSlice().getBytes())).endCell());
        TvmStackEntryNumber maxBidAmountNumber = (TvmStackEntryNumber)result.getStack().get(1);
        BigInteger maxBidAmount = maxBidAmountNumber.getNumber();
        TvmStackEntryNumber auctionEndTimeNumber = (TvmStackEntryNumber)result.getStack().get(2);
        long auctionEndTime = auctionEndTimeNumber.getNumber().longValue();
        return AuctionInfo.builder().maxBidAddress(maxBidAddress).maxBidAmount(maxBidAmount).auctionEndTime(auctionEndTime).build();
    }

    public static long getLastFillUpTime(Tonlib tonlib, Address dnsItemAddress) {
        RunResult result = tonlib.runMethod(dnsItemAddress, "get_last_fill_up_time");
        if (result.getExit_code() != 0L) {
            throw new Error("method get_last_fill_up_time, returned an exit code " + result.getExit_code());
        }
        TvmStackEntryNumber time = (TvmStackEntryNumber)result.getStack().get(0);
        return time.getNumber().longValue();
    }

    public static Object resolve(Tonlib tonlib, String domain, String category, boolean oneStep, Address dnsItemAddress) {
        return DnsUtils.dnsResolve(tonlib, dnsItemAddress, domain, category, oneStep);
    }

    public static Object resolve(Tonlib tonlib, String domain, Address dnsItemAddress) {
        return DnsUtils.dnsResolve(tonlib, dnsItemAddress, domain, null, false);
    }

    public static Cell createChangeContentEntryBody(String category, Cell value, long queryId) {
        CellBuilder body = CellBuilder.beginCell();
        body.storeUint(1320284409, 32);
        body.storeUint(queryId, 64);
        body.storeUint(DnsUtils.categoryToInt(category), 256);
        if (Objects.nonNull(value)) {
            body.storeRef(value);
        }
        return body.endCell();
    }

    DnsItem(BigInteger index, Address collectionAddress, Tonlib tonlib, long wc) {
        this.index = index;
        this.collectionAddress = collectionAddress;
        this.tonlib = tonlib;
        this.wc = wc;
    }

    public BigInteger getIndex() {
        return this.index;
    }

    public Address getCollectionAddress() {
        return this.collectionAddress;
    }

    public long getWc() {
        return this.wc;
    }

    private static class CustomDnsItemBuilder
    extends DnsItemBuilder {
        private CustomDnsItemBuilder() {
        }

        @Override
        public DnsItem build() {
            return super.build();
        }
    }

    public static class DnsItemBuilder {
        private BigInteger index;
        private Address collectionAddress;
        private Tonlib tonlib;
        private long wc;

        DnsItemBuilder() {
        }

        public DnsItemBuilder index(BigInteger index) {
            this.index = index;
            return this;
        }

        public DnsItemBuilder collectionAddress(Address collectionAddress) {
            this.collectionAddress = collectionAddress;
            return this;
        }

        public DnsItemBuilder tonlib(Tonlib tonlib) {
            this.tonlib = tonlib;
            return this;
        }

        public DnsItemBuilder wc(long wc) {
            this.wc = wc;
            return this;
        }

        public DnsItem build() {
            return new DnsItem(this.index, this.collectionAddress, this.tonlib, this.wc);
        }

        public String toString() {
            return "DnsItem.DnsItemBuilder(index=" + String.valueOf(this.index) + ", collectionAddress=" + String.valueOf(this.collectionAddress) + ", tonlib=" + String.valueOf(this.tonlib) + ", wc=" + this.wc + ")";
        }
    }
}

