/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.cell;

import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.ton.java.address.Address;
import org.ton.java.bitstring.BitString;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellType;
import org.ton.java.cell.TonHashMap;
import org.ton.java.cell.TonHashMapAug;
import org.ton.java.cell.TonHashMapAugE;
import org.ton.java.cell.TonHashMapE;
import org.ton.java.cell.TonPfxHashMap;
import org.ton.java.cell.TonPfxHashMapE;

public class CellSlice
implements Serializable {
    BitString bits;
    List<Cell> refs;
    public CellType type;

    private CellSlice() {
    }

    private CellSlice(BitString bits, List<Cell> refs) {
        this.bits = bits.clone();
        this.refs = refs.isEmpty() ? new ArrayList<Cell>(0) : (refs.size() <= 4 ? new ArrayList<Cell>(refs) : new ArrayList<Cell>(refs));
    }

    private CellSlice(BitString bits, List<Cell> refs, CellType cellType) {
        this.bits = bits.clone();
        this.refs = refs.isEmpty() ? new ArrayList<Cell>(0) : (refs.size() <= 4 ? new ArrayList<Cell>(refs) : new ArrayList<Cell>(refs));
        this.type = cellType;
    }

    public boolean isExotic() {
        return this.type != CellType.ORDINARY;
    }

    public static CellSlice beginParse(Cell cell) {
        return new CellSlice(cell.getBits(), cell.refs, cell.getCellType());
    }

    public static CellSlice beginParse(Object cell) {
        if (!(cell instanceof Cell) && !(cell instanceof CellSlice)) {
            throw new Error("CellSlice works only with Cell types");
        }
        if (cell instanceof Cell) {
            return CellSlice.beginParse((Cell)cell);
        }
        return (CellSlice)cell;
    }

    public static CellSlice of(Object cell) {
        if (!(cell instanceof Cell) && !(cell instanceof CellSlice)) {
            throw new Error("CellSlice works only with Cell types");
        }
        if (cell instanceof Cell) {
            return CellSlice.beginParse((Cell)cell);
        }
        return (CellSlice)cell;
    }

    public CellSlice clone() {
        CellSlice result = new CellSlice();
        result.bits = this.bits.clone();
        result.refs = this.refs.isEmpty() ? new ArrayList<Cell>(0) : (this.refs.size() <= 4 ? new ArrayList<Cell>(this.refs) : new ArrayList<Cell>(this.refs));
        result.type = this.type;
        return result;
    }

    public Cell sliceToCell() {
        return new Cell(this.bits, this.refs);
    }

    public void endParse() {
        if (this.bits.getUsedBits() != 0) {
            throw new Error("not all bits read");
        }
    }

    public Cell loadMaybeRefX() {
        boolean maybe = this.loadBit();
        if (!maybe) {
            return null;
        }
        return this.loadRef();
    }

    public int loadUnary() {
        boolean pfx = this.loadBit();
        if (!pfx) {
            return 0;
        }
        int x = this.loadUnary();
        return x + 1;
    }

    public boolean isSliceEmpty() {
        return this.bits.getUsedBits() == 0;
    }

    public List<Cell> loadRefs(int count) {
        ArrayList<Cell> result = new ArrayList<Cell>();
        for (int i = 0; i < count; ++i) {
            result.add(this.loadRef());
        }
        return result;
    }

    public Cell loadRef() {
        this.checkRefsOverflow();
        Cell cell = this.refs.get(0);
        this.refs.remove(0);
        return cell;
    }

    public int getRefsCount() {
        return this.refs.size();
    }

    public CellSlice skipRefs(int length) {
        if (length > 0) {
            this.refs.subList(0, length).clear();
        }
        return this;
    }

    public Cell preloadRef() {
        this.checkRefsOverflow();
        return this.refs.get(0);
    }

    public Cell preloadMaybeRefX() {
        boolean maybe = this.preloadBit();
        if (!maybe) {
            return null;
        }
        return this.preloadRef();
    }

    public List<Cell> preloadRefs(int count) {
        ArrayList<Cell> result = new ArrayList<Cell>();
        for (int i = 0; i < count; ++i) {
            result.add(this.refs.get(i));
        }
        return result;
    }

    public TonHashMap loadDict(int n, Function<BitString, Object> keyParser, Function<Cell, Object> valueParser) {
        TonHashMap x = new TonHashMap(n);
        x.deserialize(CellSlice.beginParse(this), keyParser, valueParser);
        return x;
    }

    public TonHashMapAug loadDictAug(int n, Function<BitString, Object> keyParser, Function<CellSlice, Object> valueParser, Function<CellSlice, Object> extraParser) {
        TonHashMapAug x = new TonHashMapAug(n);
        x.deserialize(this, keyParser, valueParser, extraParser);
        if (!this.refs.isEmpty()) {
            this.refs.remove(0);
        }
        if (!this.refs.isEmpty()) {
            this.refs.remove(0);
        }
        return x;
    }

    public TonHashMapE loadDictE(int n, Function<BitString, Object> keyParser, Function<Cell, Object> valueParser) {
        boolean isEmpty;
        boolean bl = isEmpty = !this.loadBit();
        if (isEmpty) {
            return new TonHashMapE(n);
        }
        TonHashMapE hashMap = new TonHashMapE(n);
        hashMap.deserialize(CellSlice.beginParse(this.loadRef()), keyParser, valueParser);
        return hashMap;
    }

    public TonHashMapAugE loadDictAugE(int n, Function<BitString, Object> keyParser, Function<CellSlice, Object> valueParser, Function<CellSlice, Object> extraParser) {
        boolean isEmpty;
        if (this.isExotic()) {
            return new TonHashMapAugE(n);
        }
        boolean bl = isEmpty = !this.loadBit();
        if (isEmpty) {
            return new TonHashMapAugE(n);
        }
        TonHashMapAugE hashMap = new TonHashMapAugE(n);
        hashMap.deserialize(CellSlice.beginParse(this.loadRef()), keyParser, valueParser, extraParser);
        return hashMap;
    }

    public TonPfxHashMap loadDictPfx(int n, Function<BitString, Object> keyParser, Function<Cell, Object> valueParser) {
        TonPfxHashMap x = new TonPfxHashMap(n);
        x.deserialize(this, keyParser, valueParser);
        return x;
    }

    public TonPfxHashMap parseDictPfx(int n, Function<BitString, Object> keyParser, Function<Cell, Object> valueParser) {
        TonPfxHashMap x = new TonPfxHashMap(n);
        x.deserialize(this, keyParser, valueParser);
        return x;
    }

    public TonPfxHashMapE loadDictPfxE(int n, Function<BitString, Object> keyParser, Function<Cell, Object> valueParser) {
        boolean isEmpty;
        boolean bl = isEmpty = !this.loadBit();
        if (isEmpty) {
            return new TonPfxHashMapE(n);
        }
        TonPfxHashMapE hashMap = new TonPfxHashMapE(n);
        hashMap.deserialize(CellSlice.beginParse(this.loadRef()), keyParser, valueParser);
        return hashMap;
    }

    public TonHashMap preloadDict(int n, Function<BitString, Object> keyParser, Function<Cell, Object> valueParser) {
        TonHashMap x = new TonHashMap(n);
        x.deserialize(this.clone(), keyParser, valueParser);
        return x;
    }

    public TonHashMap preloadDictE(int n, Function<BitString, Object> keyParser, Function<Cell, Object> valueParser) {
        boolean isEmpty;
        boolean bl = isEmpty = !this.preloadBit();
        if (isEmpty) {
            return new TonHashMap(n);
        }
        TonHashMap x = new TonHashMap(n);
        CellSlice cs = this.clone();
        cs.skipBit();
        x.deserialize(CellSlice.beginParse(cs.loadRef()), keyParser, valueParser);
        return x;
    }

    public CellSlice skipDictE() {
        boolean isEmpty = this.loadBit();
        return isEmpty ? this.skipRefs(1) : this;
    }

    public CellSlice skipDict(int dictKeySize) {
        this.loadDict(dictKeySize, k -> CellBuilder.beginCell().endCell(), v -> CellBuilder.beginCell().endCell());
        return this;
    }

    public boolean loadBit() {
        this.checkBitsOverflow(1);
        return this.bits.readBit();
    }

    public boolean preloadBit() {
        this.checkBitsOverflow(1);
        return this.bits.get(0);
    }

    public boolean preloadBitAt(int position) {
        this.checkBitsOverflow(position);
        BitString cloned = this.clone().bits;
        cloned.readBits(position - 1);
        return cloned.readBit();
    }

    public int getFreeBits() {
        return this.getRestBits();
    }

    public int getRestBits() {
        return this.bits.getUsedBits();
    }

    public CellSlice skipBits(int length) {
        this.checkBitsOverflow(length);
        this.bits.readCursor += length;
        return this;
    }

    public CellSlice skipBit() {
        this.checkBitsOverflow(1);
        this.bits.readBit();
        return this;
    }

    public byte[] loadBytes(int length) {
        this.checkBitsOverflow(length);
        BitString bitString = this.bits.readBits(length);
        return bitString.toByteArray();
    }

    public List<BigInteger> loadList(int elementNum, int elementBitLength) {
        this.checkBitsOverflow(elementNum * elementBitLength);
        ArrayList<BigInteger> result = new ArrayList<BigInteger>(elementNum);
        for (int i = 0; i < elementNum; ++i) {
            result.add(this.bits.readUint(elementBitLength));
        }
        return result;
    }

    public int[] loadBytes() {
        BitString bitString = this.bits.readBits();
        return bitString.toUnsignedByteArray();
    }

    public byte[] loadSignedBytes() {
        BitString bitString = this.bits.readBits();
        return bitString.toSignedByteArray();
    }

    public int[] loadSlice(int length) {
        this.checkBitsOverflow(length);
        int bytesNeeded = (length + 7) / 8;
        int[] result = new int[bytesNeeded];
        int savedPosition = this.bits.readCursor;
        for (int i = 0; i < bytesNeeded; ++i) {
            int value = 0;
            for (int j = 0; j < 8 && i * 8 + j < length; ++j) {
                if (this.bits.readCursor >= this.bits.writeCursor || !this.bits.readBit().booleanValue()) continue;
                value |= 1 << 7 - j;
            }
            result[i] = value & 0xFF;
        }
        if (this.bits.readCursor != savedPosition + length) {
            this.bits.readCursor = savedPosition + length;
        }
        return result;
    }

    public String loadString(int length) {
        this.checkBitsOverflow(length);
        BitString bitString = this.bits.readBits(length);
        return new String(bitString.toByteArray());
    }

    public String loadSnakeString() {
        int estimatedCapacity = Math.max(256, this.bits.getUsedBits() / 8 * 2);
        StringBuilder s = new StringBuilder(estimatedCapacity);
        CellSlice ref = this.clone();
        while (Objects.nonNull(ref)) {
            try {
                BitString bitString = ref.loadBits(ref.bits.getUsedBits());
                byte[] bytes = bitString.toByteArray();
                if (bytes.length > 0) {
                    s.append(new String(bytes, StandardCharsets.UTF_8));
                }
                if (ref.refs.size() > 1) {
                    throw new Error("more than one ref, it is not snake string");
                }
                if (ref.refs.size() == 1) {
                    ref = CellSlice.beginParse(ref.loadRef());
                    continue;
                }
            }
            catch (Throwable e) {
                return null;
            }
            ref = null;
        }
        return s.toString();
    }

    public BitString loadBits(int length) {
        this.checkBitsOverflow(length);
        return this.bits.readBits(length);
    }

    public BigInteger loadInt(int length) {
        return this.bits.readInt(length);
    }

    public BigInteger loadIntMaybe(int length) {
        if (this.bits.readBit().booleanValue()) {
            return this.bits.readInt(length);
        }
        return null;
    }

    public BigInteger loadUintMaybe(int length) {
        if (this.bits.readBit().booleanValue()) {
            return this.bits.readUint(length);
        }
        return null;
    }

    public BigInteger loadUint(int length) {
        this.checkBitsOverflow(length);
        if (length == 0) {
            return BigInteger.ZERO;
        }
        return new BigInteger(this.loadBits(length).toBitString(), 2);
    }

    public BigInteger preloadInt(int bitLength) {
        int savedPosition = this.bits.readCursor;
        try {
            BigInteger result = this.loadInt(bitLength);
            this.bits.readCursor = savedPosition;
            return result;
        }
        catch (Throwable e) {
            this.bits.readCursor = savedPosition;
            throw e;
        }
    }

    public BigInteger preloadUint(int bitLength) {
        if (bitLength <= 64 && this.bits.readCursor + bitLength <= this.bits.writeCursor) {
            int savedPosition = this.bits.readCursor;
            try {
                long result = 0L;
                for (int i = 0; i < bitLength; ++i) {
                    if (this.bits.readBit().booleanValue()) {
                        result = result << 1 | 1L;
                        continue;
                    }
                    result <<= 1;
                }
                this.bits.readCursor = savedPosition;
                return BigInteger.valueOf(result);
            }
            catch (Throwable e) {
                this.bits.readCursor = savedPosition;
                return BigInteger.ZERO;
            }
        }
        int savedPosition = this.bits.readCursor;
        try {
            BigInteger result = this.loadUint(bitLength);
            this.bits.readCursor = savedPosition;
            return result;
        }
        catch (Throwable e) {
            this.bits.readCursor = savedPosition;
            return BigInteger.ZERO;
        }
    }

    public BigInteger loadUintLEQ(BigInteger n) {
        BigInteger result = this.loadUint(n.bitLength());
        if (result.compareTo(n) > 0) {
            throw new Error("Cannot load {<= x}: encoded number is too high");
        }
        return result;
    }

    public BigInteger loadUintLess(BigInteger n) {
        return this.loadUintLEQ(n.subtract(BigInteger.ONE));
    }

    public BigInteger loadVarUInteger(BigInteger bitLength) {
        BigInteger len = this.loadUint(bitLength.intValue());
        if (len.compareTo(BigInteger.ZERO) == 0) {
            return BigInteger.ZERO;
        }
        return this.loadUint(len.multiply(BigInteger.valueOf(8L)).intValue());
    }

    public BigInteger loadCoins() {
        BigInteger len = this.loadUint(4);
        if (len.compareTo(BigInteger.ZERO) == 0) {
            return BigInteger.ZERO;
        }
        return this.loadUint(len.multiply(BigInteger.valueOf(8L)).intValue());
    }

    public BigInteger preloadCoins() {
        int savedPosition = this.bits.readCursor;
        try {
            BigInteger len = this.loadUint(4);
            if (len.compareTo(BigInteger.ZERO) == 0) {
                this.bits.readCursor = savedPosition;
                return BigInteger.ZERO;
            }
            BigInteger result = this.loadUint(len.multiply(BigInteger.valueOf(8L)).intValue());
            this.bits.readCursor = savedPosition;
            return result;
        }
        catch (Throwable e) {
            this.bits.readCursor = savedPosition;
            throw e;
        }
    }

    public BigInteger skipCoins() {
        return this.loadCoins();
    }

    void checkBitsOverflow(int length) {
        if (length > this.bits.getUsedBits()) {
            throw new Error("Bits overflow. Can't load " + length + " bits. " + this.bits.getUsedBits() + " bits left.");
        }
    }

    void checkRefsOverflow() {
        if (this.refs.isEmpty()) {
            throw new Error("Refs overflow. No more refs.");
        }
    }

    public String toString() {
        return this.bits.toBitString();
    }

    public Address loadAddress() {
        BigInteger i = this.preloadUint(2);
        if (i.intValue() == 0) {
            this.skipBits(2);
            return null;
        }
        this.loadBits(2);
        this.loadBits(1);
        int workchain = this.loadInt(8).intValue();
        BigInteger hashPart = this.loadUint(256);
        String address = workchain + ":" + String.format("%64s", hashPart.toString(16)).replace(' ', '0');
        return Address.of((String)address);
    }
}

