/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.cell;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.ton.java.address.Address;
import org.ton.java.bitstring.BitString;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellSlice;
import org.ton.java.cell.CellType;
import org.ton.java.utils.Utils;

public class CellBuilder {
    Cell cell;

    private CellBuilder() {
        this.cell = new Cell();
    }

    private CellBuilder(int bitSize) {
        this.cell = new Cell(bitSize);
    }

    public static CellBuilder beginCell() {
        return new CellBuilder();
    }

    public static CellBuilder beginCell(int bitSize) {
        return new CellBuilder(bitSize);
    }

    public Cell endCell() {
        this.cell.levelMask = this.cell.resolveMask();
        if (this.cell.getHashes().length == 0) {
            this.cell.calculateHashes();
        }
        return this.cell;
    }

    public CellBuilder storeBit(Boolean bit) {
        this.checkBitsOverflow(1);
        this.cell.bits.writeBit(bit);
        return this;
    }

    public CellBuilder cellType(CellType cellType) {
        this.cell.setCellType(cellType);
        return this;
    }

    public CellBuilder setExotic(boolean exotic) {
        this.cell.setExotic(exotic);
        return this;
    }

    public CellBuilder storeBits(List<Boolean> arrayBits) {
        this.checkBitsOverflow(arrayBits.size());
        for (Boolean bit : arrayBits) {
            this.cell.bits.writeBit(bit);
        }
        return this;
    }

    public CellBuilder storeBits(String bits) {
        this.checkBitsOverflow(bits.length());
        this.cell.bits.writeBits(bits);
        return this;
    }

    public CellBuilder storeBits(Boolean[] arrayBits) {
        this.checkBitsOverflow(arrayBits.length);
        this.cell.bits.writeBitArray(arrayBits);
        return this;
    }

    public CellBuilder storeUint(long number, int bitLength) {
        return this.storeUint(BigInteger.valueOf(number), bitLength);
    }

    public CellBuilder storeUintMaybe(long number, int bitLength) {
        return this.storeUintMaybe(BigInteger.valueOf(number), bitLength);
    }

    public CellBuilder storeUint(int number, int bitLength) {
        return this.storeUint(BigInteger.valueOf(number), bitLength);
    }

    public CellBuilder storeUintMaybe(int number, int bitLength) {
        return this.storeUintMaybe(BigInteger.valueOf(number), bitLength);
    }

    public CellBuilder storeUint(short number, int bitLength) {
        return this.storeUint(BigInteger.valueOf(number), bitLength);
    }

    public CellBuilder storeUintMaybe(short number, int bitLength) {
        return this.storeUintMaybe(BigInteger.valueOf(number), bitLength);
    }

    public CellBuilder storeUint(Byte number, int bitLength) {
        return this.storeUint(BigInteger.valueOf(number.byteValue()), bitLength);
    }

    public CellBuilder storeUintMaybe(Byte number, int bitLength) {
        return this.storeUintMaybe(BigInteger.valueOf(number.byteValue()), bitLength);
    }

    public CellBuilder storeUint(String number, int bitLength) {
        return this.storeUint(new BigInteger(number), bitLength);
    }

    public CellBuilder storeUintMaybe(String number, int bitLength) {
        return this.storeUintMaybe(new BigInteger(number), bitLength);
    }

    public CellBuilder storeUint(BigInteger number, int bitLength) {
        this.checkBitsOverflow(bitLength);
        this.checkSign(number);
        this.cell.bits.writeUint(Objects.isNull(number) ? BigInteger.ZERO : number, bitLength);
        return this;
    }

    public CellBuilder storeUintMaybe(BigInteger number, int bitLength) {
        if (Objects.isNull(number)) {
            this.cell.bits.writeBit(Boolean.valueOf(false));
        } else {
            this.cell.bits.writeBit(Boolean.valueOf(true));
            this.checkBitsOverflow(bitLength);
            this.checkSign(number);
            this.cell.bits.writeUint(number, bitLength);
        }
        return this;
    }

    public CellBuilder storeVarUint(BigInteger number, int bitLength) {
        this.checkSign(number);
        this.cell.bits.writeVarUint(number, bitLength);
        return this;
    }

    public CellBuilder storeVarUint(BigInteger number) {
        this.checkSign(number);
        this.cell.bits.writeVarUint(number, number.bitLength());
        return this;
    }

    public CellBuilder storeVarUint(Byte number, int bitLength) {
        this.checkSign(BigInteger.valueOf(number.byteValue()));
        this.cell.bits.writeVarUint(BigInteger.valueOf(number.byteValue()), bitLength);
        return this;
    }

    public CellBuilder storeVarUintMaybe(BigInteger number, int bitLength) {
        if (Objects.isNull(number)) {
            this.cell.bits.writeBit(Boolean.valueOf(false));
        } else {
            this.cell.bits.writeBit(Boolean.valueOf(true));
            this.checkSign(number);
            this.cell.bits.writeVarUint(number, bitLength);
        }
        return this;
    }

    public CellBuilder storeInt(long number, int bitLength) {
        return this.storeInt(BigInteger.valueOf(number), bitLength);
    }

    public CellBuilder storeIntMaybe(long number, int bitLength) {
        return this.storeIntMaybe(BigInteger.valueOf(number), bitLength);
    }

    public CellBuilder storeInt(int number, int bitLength) {
        return this.storeInt(BigInteger.valueOf(number), bitLength);
    }

    public CellBuilder storeIntMaybe(int number, int bitLength) {
        return this.storeIntMaybe(BigInteger.valueOf(number), bitLength);
    }

    public CellBuilder storeInt(short number, int bitLength) {
        return this.storeInt(BigInteger.valueOf(number), bitLength);
    }

    public CellBuilder storeIntMaybe(short number, int bitLength) {
        return this.storeIntMaybe(BigInteger.valueOf(number), bitLength);
    }

    public CellBuilder storeInt(byte number, int bitLength) {
        return this.storeInt(BigInteger.valueOf(number), bitLength);
    }

    public CellBuilder storeIntMaybe(byte number, int bitLength) {
        return this.storeIntMaybe(BigInteger.valueOf(number), bitLength);
    }

    public CellBuilder storeInt(BigInteger number, int bitLength) {
        BigInteger sint = BigInteger.ONE.shiftLeft(bitLength - 1);
        if (number.compareTo(sint.negate()) >= 0 && number.compareTo(sint) < 0) {
            this.cell.bits.writeInt(number, bitLength);
            return this;
        }
        throw new Error("Can't store an Int, because its value allocates more space than provided.");
    }

    public CellBuilder storeIntMaybe(BigInteger number, int bitLength) {
        if (Objects.isNull(number)) {
            this.cell.bits.writeBit(Boolean.valueOf(false));
        } else {
            this.cell.bits.writeBit(Boolean.valueOf(true));
            this.cell.bits.writeInt(number, bitLength);
        }
        return this;
    }

    public CellBuilder storeBitString(BitString bitString) {
        this.checkBitsOverflow(bitString.getUsedBits());
        this.cell.bits.writeBitString(bitString.clone());
        return this;
    }

    public CellBuilder storeBitString(BitString bitString, int bits) {
        this.checkBitsOverflow(bits);
        BitString temp = bitString.readBits(267);
        this.cell.bits.writeBitString(temp.clone());
        return this;
    }

    public CellBuilder storeBitStringUnsafe(BitString bitString) {
        this.cell.bits.writeBitString(bitString.clone());
        return this;
    }

    public CellBuilder storeString(String str) {
        this.checkBitsOverflow(str.length() * 8);
        this.cell.bits.writeString(str);
        return this;
    }

    public CellBuilder storeSnakeString(String str) {
        byte[] strBytes = str.getBytes(StandardCharsets.UTF_8);
        Cell c = this.f(123, strBytes);
        return this.storeSlice(CellSlice.beginParse(c));
    }

    private Cell f(int space, byte[] data) {
        if (data.length < space) {
            space = data.length;
        }
        BitString bs = new BitString(data, space * 8);
        CellBuilder c = CellBuilder.beginCell().storeBitString(bs);
        byte[] tmp = new byte[data.length - space];
        System.arraycopy(data, space, tmp, 0, data.length - space);
        if (tmp.length > 0) {
            Cell ref = this.f(127, tmp);
            c.storeRef(ref);
        }
        return c.endCell();
    }

    public CellBuilder storeAddress(Address address) {
        this.checkBitsOverflow(267);
        this.cell.bits.writeAddress(address);
        return this;
    }

    public CellBuilder storeBytes(byte[] number) {
        this.checkBitsOverflow(number.length * 8);
        this.cell.bits.writeBytes(number);
        return this;
    }

    public CellBuilder storeBytes(int[] number) {
        this.checkBitsOverflow(number.length * 8);
        this.cell.bits.writeBytes(number);
        return this;
    }

    public CellBuilder storeBytes(List<Byte> bytes) {
        this.checkBitsOverflow(bytes.size() * 8);
        for (Byte b : bytes) {
            this.cell.bits.writeUint8((int)b.byteValue());
        }
        return this;
    }

    public CellBuilder storeList(List<BigInteger> bytes, int bitLength) {
        this.checkBitsOverflow(bitLength);
        for (BigInteger b : bytes) {
            this.cell.bits.writeUint(b, bitLength);
        }
        return this;
    }

    public CellBuilder storeBytes(byte[] number, int bitLength) {
        this.checkBitsOverflow(bitLength);
        this.cell.bits.writeBytes(number);
        return this;
    }

    public CellBuilder storeBytes(int[] number, int bitLength) {
        this.checkBitsOverflow(bitLength);
        this.cell.bits.writeBytes(number);
        return this;
    }

    public CellBuilder storeRef(Cell c) {
        this.checkRefsOverflow(1);
        this.cell.refs.add(c.clone());
        return this;
    }

    public CellBuilder storeRefMaybe(Cell c) {
        if (Objects.isNull(c)) {
            this.cell.bits.writeBit(Boolean.valueOf(false));
        } else {
            this.cell.bits.writeBit(Boolean.valueOf(true));
            this.checkRefsOverflow(1);
            this.cell.refs.add(c.clone());
        }
        return this;
    }

    public CellBuilder storeRefs(List<Cell> cells) {
        this.checkRefsOverflow(cells.size());
        for (Cell c : cells) {
            this.cell.refs.add(c.clone());
        }
        return this;
    }

    public CellBuilder storeRefs(Cell ... cells) {
        this.checkRefsOverflow(cells.length);
        for (Cell c : cells) {
            this.cell.refs.add(c.clone());
        }
        return this;
    }

    public CellBuilder storeSlice(CellSlice cellSlice) {
        this.checkBitsOverflow(cellSlice.bits.getUsedBits());
        this.checkRefsOverflow(cellSlice.refs.size());
        this.storeBitString(cellSlice.bits);
        for (Cell c : cellSlice.refs) {
            this.cell.refs.add(c.clone());
        }
        return this;
    }

    public CellBuilder storeCell(Cell c) {
        if (Objects.isNull(c)) {
            return this;
        }
        this.checkBitsOverflow(c.bits.getUsedBits());
        this.checkRefsOverflow(c.refs.size());
        this.storeBitString(c.bits);
        for (Cell cc : c.refs) {
            this.cell.refs.add(cc.clone());
        }
        return this;
    }

    public CellBuilder storeCellMaybe(Cell c) {
        if (Objects.isNull(c)) {
            this.cell.bits.writeBit(Boolean.valueOf(false));
        } else {
            this.cell.bits.writeBit(Boolean.valueOf(true));
            this.storeCell(c.clone());
        }
        return this;
    }

    public CellBuilder storeDict(Cell dict) {
        this.storeRefMaybe(dict);
        return this;
    }

    public CellBuilder storeDictInLine(Cell dict) {
        this.storeSlice(CellSlice.beginParse(dict));
        return this;
    }

    public CellBuilder storeCoins(BigInteger coins) {
        this.cell.bits.writeCoins(Objects.isNull(coins) ? BigInteger.ZERO : coins);
        return this;
    }

    public CellBuilder storeCoinsMaybe(BigInteger coins) {
        if (Objects.isNull(coins)) {
            this.cell.bits.writeBit(Boolean.valueOf(false));
        } else {
            this.cell.bits.writeBit(Boolean.valueOf(true));
            this.cell.bits.writeCoins(coins);
        }
        return this;
    }

    public int getUsedBits() {
        return this.cell.bits.getUsedBits();
    }

    public int getFreeBits() {
        return this.cell.bits.getFreeBits();
    }

    public int getFreeRefs() {
        return this.cell.getFreeRefs();
    }

    public int getUsedRefs() {
        return this.cell.getUsedRefs();
    }

    void checkBitsOverflow(int length) {
        if (length > this.cell.bits.getFreeBits()) {
            throw new Error("Bits overflow. Can't add " + length + " cell.bits. " + this.cell.bits.getFreeBits() + " bits left.");
        }
    }

    void checkSign(BigInteger i) {
        if (Objects.nonNull(i) && i.signum() < 0) {
            throw new Error("Integer " + String.valueOf(i) + " must be unsigned");
        }
    }

    void checkRefsOverflow(int count) {
        if (count > 4 - this.cell.refs.size()) {
            throw new Error("Refs overflow. Can't add " + count + " cell.refs. " + (4 - this.cell.refs.size()) + " refs left.");
        }
    }

    public int[] toUnsignedByteArray() {
        return this.cell.bits.toUnsignedByteArray();
    }

    public byte[] toSignedByteArray() {
        return this.cell.bits.toSignedByteArray();
    }

    public CellBuilder fromBocBase64(String data) {
        this.cell = Cell.fromBocMultiRoot(Utils.base64ToBytes((String)data)).get(0);
        return this;
    }

    public CellBuilder fromBoc(String data) {
        this.cell = Cell.fromBocMultiRoot(Utils.hexToSignedBytes((String)data)).get(0);
        return this;
    }

    public CellBuilder fromBoc(byte[] data) {
        this.cell = Cell.fromBocMultiRoot(data).get(0);
        return this;
    }

    public CellBuilder fromBoc(int[] data) {
        this.cell = Cell.fromBocMultiRoot(Utils.unsignedBytesToSigned((int[])data)).get(0);
        return this;
    }
}

