/*
 * Decompiled with CFR 0.152.
 */
package io.github.naverz.antonio.core;

import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import io.github.naverz.antonio.GenericAntonioFindable;
import io.github.naverz.antonio.core.AntonioModel;
import io.github.naverz.antonio.core.container.ContainerType;
import io.github.naverz.antonio.core.container.FragmentContainer;
import io.github.naverz.antonio.core.container.PagerViewContainer;
import io.github.naverz.antonio.core.container.ViewHolderContainer;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class Exceptions {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String ERROR_TEXT_UNKNOWN = "An unknown error is found. Please, Issue up on Github (https://github.com/naverz/Antonio).";

    private Exceptions() {
    }

    public static String errorIllegalBinding(@Nullable String layoutIdStr, @Nullable AntonioModel model) {
        if (layoutIdStr == null || model == null) {
            return "There is no variable for the model in layout xml, Did you declare the variable in your layout xml?";
        }
        return String.format("There is no variable for [%s] in [%s.xml]. Did you declare the variable in your layout xml?", model.getClass().getSimpleName(), layoutIdStr);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static String errorClassCast(Object model, GenericAntonioFindable findable) {
        Class<?> modelClass = model.getClass();
        Pair<Class<?>, Class<?>> viewClassWithAntonioGeneric = findable.findAntonioClass();
        Class viewClass = viewClassWithAntonioGeneric != null ? (Class)viewClassWithAntonioGeneric.first : findable.getClass();
        Class antonioClass = viewClassWithAntonioGeneric != null ? (Class)viewClassWithAntonioGeneric.second : Object.class;
        return String.format("The model type [%s] doesn't match with [%s]. Check whether it is correct for the generic type of [%s<%s>]. You might need to check which one you intent between [%s] and [%s] for the model to be bound.", modelClass.getName(), viewClass.getName(), viewClass.getSimpleName(), antonioClass.getSimpleName(), modelClass.getSimpleName(), antonioClass.getSimpleName());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static String errorRegisterFirst(@NonNull Class<?> clazz, @NonNull ContainerType type) {
        return String.format("There is no [%s] in [%s]. Please, Add [%s] to [%s]", clazz.getName(), Exceptions.getContainerName(type), clazz.getName(), Exceptions.getContainerName(type));
    }

    @NonNull
    private static String getContainerName(@NonNull ContainerType type) {
        return switch (type) {
            case ContainerType.FRAGMENT -> FragmentContainer.class.getName();
            case ContainerType.PAGER_VIEW -> PagerViewContainer.class.getName();
            default -> ViewHolderContainer.class.getName();
        };
    }
}

