/*
 * Decompiled with CFR 0.152.
 */
package io.github.naverz.antonio.compiler;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import io.github.naverz.antonio.annotations.MappedWithViewDependency;
import io.github.naverz.antonio.compiler.BindData;
import io.github.naverz.antonio.compiler.BindDataSet;
import io.github.naverz.antonio.compiler.Error;
import io.github.naverz.antonio.compiler.ViewDependencyType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import net.ltgt.gradle.incap.IncrementalAnnotationProcessor;
import net.ltgt.gradle.incap.IncrementalAnnotationProcessorType;

@IncrementalAnnotationProcessor(value=IncrementalAnnotationProcessorType.AGGREGATING)
public class AntonioProcessor
extends AbstractProcessor {
    private static final String ADD_FORMAT = "                .add(%s, new $T() {\n                    @$T\n                    @Override\n                    public $T<?> build(@NonNull $T parent) {\n                        return new %s(parent);\n                    }\n                })";
    private static final String ADD_FORMAT_WITHOUT_VIEW_GROUP_PARAMETER = "                .add(%s, new $T() {\n                    @$T\n                    @Override\n                    public $T<?> build() {\n                        return new %s();\n                    }\n                })";
    private final ClassName viewGroupClass = ClassName.get((String)"android.view", (String)"ViewGroup", (String[])new String[0]);
    private final ClassName nonNullClass = ClassName.get((String)"androidx.annotation", (String)"NonNull", (String[])new String[0]);
    private final ClassName antonioSettingClass = ClassName.get((String)"io.github.naverz.antonio", (String)"AntonioSettings", (String[])new String[0]);
    private final ClassName viewHolderBuilderClass = ClassName.get((String)"io.github.naverz.antonio.core", (String)"ViewHolderBuilder", (String[])new String[0]);
    private final ClassName pagerViewBuilderClass = ClassName.get((String)"io.github.naverz.antonio.core", (String)"PagerViewDependencyBuilder", (String[])new String[0]);
    private final ClassName fragmentBuilderClass = ClassName.get((String)"io.github.naverz.antonio.core", (String)"FragmentBuilder", (String[])new String[0]);
    private final ClassName typedViewHolderClass = ClassName.get((String)"io.github.naverz.antonio.core.holder", (String)"TypedViewHolder", (String[])new String[0]);
    private final ClassName pagerViewClass = ClassName.get((String)"io.github.naverz.antonio.core.view", (String)"PagerViewDependency", (String[])new String[0]);
    private final ClassName antonioFragmentClass = ClassName.get((String)"io.github.naverz.antonio.core.fragment", (String)"AntonioFragment", (String[])new String[0]);
    private final List<MethodSpec> mMethodSpecList = new ArrayList<MethodSpec>();

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return new LinkedHashSet<String>(){
            {
                this.add(MappedWithViewDependency.class.getCanonicalName());
            }
        };
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        try {
            ArrayList<MethodSpec> mapMethodSpecs = this.makeMethodSpec(roundEnvironment);
            if (!mapMethodSpecs.isEmpty()) {
                this.mMethodSpecList.addAll(mapMethodSpecs);
            }
            if (roundEnvironment.processingOver() && !this.mMethodSpecList.isEmpty()) {
                this.writeFile(this.mMethodSpecList);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return true;
    }

    protected ArrayList<MethodSpec> makeMethodSpec(RoundEnvironment roundEnvironment) throws IllegalStateException {
        ArrayList<MethodSpec> mapMethodSpecs = new ArrayList<MethodSpec>();
        BindDataSet bindDataSet = this.bindMappedWithModel(roundEnvironment);
        if (!bindDataSet.fragmentBinds.isEmpty()) {
            mapMethodSpecs.add(this.buildBuilderWithModelType(ViewDependencyType.Fragment, bindDataSet.fragmentBinds));
        }
        if (!bindDataSet.pagerViewBinds.isEmpty()) {
            mapMethodSpecs.add(this.buildBuilderWithModelType(ViewDependencyType.PagerView, bindDataSet.pagerViewBinds));
        }
        if (!bindDataSet.viewHolderBinds.isEmpty()) {
            mapMethodSpecs.add(this.buildBuilderWithModelType(ViewDependencyType.ViewHolder, bindDataSet.viewHolderBinds));
        }
        return mapMethodSpecs;
    }

    protected String removeGenericTypeIfExist(String className) {
        if (className.endsWith(">")) {
            int indexOfStart = className.indexOf("<");
            className = className.substring(0, indexOfStart);
        }
        return className;
    }

    protected void writeFile(List<MethodSpec> specs) throws IOException {
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)"AntonioAnnotation").addModifiers(new Modifier[]{Modifier.PUBLIC});
        MethodSpec.Builder initMethodBuilder = MethodSpec.methodBuilder((String)"init").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        for (MethodSpec spec : specs) {
            classBuilder.addMethod(spec);
            initMethodBuilder.addCode(spec.name + "();\n", new Object[0]);
        }
        classBuilder.addMethod(initMethodBuilder.build());
        JavaFile.builder((String)"io.github.naverz.antonio", (TypeSpec)classBuilder.build()).build().writeTo(this.processingEnv.getFiler());
    }

    private BindDataSet bindMappedWithModel(RoundEnvironment roundEnvironment) throws IllegalStateException {
        ArrayList<BindData> viewHolderBinds = new ArrayList<BindData>();
        ArrayList<BindData> pagerViewBinds = new ArrayList<BindData>();
        ArrayList<BindData> fragmentBinds = new ArrayList<BindData>();
        BindDataSet dataSet = new BindDataSet(viewHolderBinds, pagerViewBinds, fragmentBinds);
        for (Element element : roundEnvironment.getElementsAnnotatedWith(MappedWithViewDependency.class)) {
            String modelClassType = this.removeGenericTypeIfExist(element.asType().toString());
            TypeMirror typeMirror = this.getMirrorType(element.getAnnotation(MappedWithViewDependency.class));
            ViewDependencyType type = this.getType(typeMirror);
            switch (type) {
                case PagerView: {
                    pagerViewBinds.add(new BindData(type, modelClassType, typeMirror.toString()));
                    break;
                }
                case Fragment: {
                    fragmentBinds.add(new BindData(type, modelClassType, typeMirror.toString()));
                    break;
                }
                case ViewHolder: {
                    viewHolderBinds.add(new BindData(type, modelClassType, typeMirror.toString()));
                }
            }
        }
        return dataSet;
    }

    private MethodSpec buildBuilderWithModelType(ViewDependencyType type, List<BindData> bindDataList) {
        String containerName;
        String methodName;
        String addFormat;
        String string = addFormat = type == ViewDependencyType.ViewHolder ? ADD_FORMAT : ADD_FORMAT_WITHOUT_VIEW_GROUP_PARAMETER;
        if (type == ViewDependencyType.PagerView) {
            methodName = "initPagerViewWithModel";
            containerName = "pagerViewContainer";
        } else if (type == ViewDependencyType.Fragment) {
            methodName = "initFragmentWithModel";
            containerName = "fragmentContainer";
        } else {
            methodName = "initViewHolderWithModel";
            containerName = "viewHolderContainer";
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addCode(String.format("$T.%s\n", containerName), new Object[]{this.antonioSettingClass});
        int count = 0;
        for (BindData data : bindDataList) {
            String formatStr = String.format(addFormat, data.modelClass + ".class", data.viewClass);
            if (type == ViewDependencyType.ViewHolder) {
                builder.addCode(formatStr, new Object[]{this.viewHolderBuilderClass, this.nonNullClass, this.typedViewHolderClass, this.viewGroupClass});
            } else if (type == ViewDependencyType.Fragment) {
                builder.addCode(formatStr, new Object[]{this.fragmentBuilderClass, this.nonNullClass, this.antonioFragmentClass});
            } else {
                builder.addCode(formatStr, new Object[]{this.pagerViewBuilderClass, this.nonNullClass, this.pagerViewClass});
            }
            if (count < bindDataList.size() - 1) {
                builder.addCode("\n", new Object[0]);
                ++count;
                continue;
            }
            builder.addCode(";", new Object[0]);
        }
        return builder.build();
    }

    private ViewDependencyType getType(TypeMirror mirror) throws IllegalStateException {
        List<? extends TypeMirror> types;
        TypeMirror processingMirror = mirror;
        while (!(types = this.processingEnv.getTypeUtils().directSupertypes(processingMirror)).isEmpty()) {
            for (TypeMirror typeMirror : types) {
                String type = this.removeGenericTypeIfExist(typeMirror.toString());
                if (type.equals(this.antonioFragmentClass.canonicalName())) {
                    return ViewDependencyType.Fragment;
                }
                if (type.equals(this.typedViewHolderClass.canonicalName())) {
                    return ViewDependencyType.ViewHolder;
                }
                if (!type.equals(this.pagerViewClass.canonicalName())) continue;
                return ViewDependencyType.PagerView;
            }
            processingMirror = types.get(0);
        }
        throw new IllegalStateException(Error.getErrorTextClassIsNotSupportedType(mirror.toString()));
    }

    private TypeMirror getMirrorType(MappedWithViewDependency model) {
        try {
            String name = model.viewClass().getName();
            throw new IllegalStateException("An unknown error is found. Please, Issue up on Github (https://github.com/naverz/Antonio).");
        }
        catch (MirroredTypeException e) {
            return e.getTypeMirror();
        }
    }
}

