/*
 * Decompiled with CFR 0.152.
 */
package io.github.naverz.antonio.compiler;

import com.google.devtools.ksp.UtilsKt;
import com.google.devtools.ksp.processing.CodeGenerator;
import com.google.devtools.ksp.processing.Dependencies;
import com.google.devtools.ksp.processing.KSPLogger;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.processing.SymbolProcessor;
import com.google.devtools.ksp.symbol.ClassKind;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSFile;
import com.google.devtools.ksp.symbol.KSNode;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.TypeSpec;
import com.squareup.kotlinpoet.ksp.OriginatingKSFilesKt;
import io.github.naverz.antonio.annotations.MappedWithViewDependency;
import io.github.naverz.antonio.compiler.AddingContainerModel;
import io.github.naverz.antonio.compiler.ExtensionsKt;
import io.github.naverz.antonio.compiler.ViewDependencyType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/github/naverz/antonio/compiler/AntonioKspProcessor;", "Lcom/google/devtools/ksp/processing/SymbolProcessor;", "codeGenerator", "Lcom/google/devtools/ksp/processing/CodeGenerator;", "logger", "Lcom/google/devtools/ksp/processing/KSPLogger;", "(Lcom/google/devtools/ksp/processing/CodeGenerator;Lcom/google/devtools/ksp/processing/KSPLogger;)V", "fragmentInitCodeBlocks", "", "Lcom/squareup/kotlinpoet/CodeBlock;", "fragmentInitFileBuilder", "Lcom/squareup/kotlinpoet/FileSpec$Builder;", "fragmentOriginatingKSFiles", "Lcom/google/devtools/ksp/symbol/KSFile;", "pagerViewInitCodeBlocks", "pagerViewInitFileBuilder", "pagerViewOriginatingKSFiles", "viewHolderInitCodeBlocks", "viewHolderInitFileBuilder", "viewHolderOriginatingKSFiles", "finish", "", "initFileBuilder", "process", "", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "antonio-compiler"})
@SourceDebugExtension(value={"SMAP\nAntonioKspProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AntonioKspProcessor.kt\nio/github/naverz/antonio/compiler/AntonioKspProcessor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,136:1\n1313#2,2:137\n1855#3,2:139\n1855#3,2:141\n1855#3,2:143\n37#4,2:145\n37#4,2:147\n37#4,2:149\n*S KotlinDebug\n*F\n+ 1 AntonioKspProcessor.kt\nio/github/naverz/antonio/compiler/AntonioKspProcessor\n*L\n45#1:137,2\n81#1:139,2\n82#1:141,2\n83#1:143,2\n93#1:145,2\n101#1:147,2\n109#1:149,2\n*E\n"})
public final class AntonioKspProcessor
implements SymbolProcessor {
    @NotNull
    private final CodeGenerator codeGenerator;
    @NotNull
    private final KSPLogger logger;
    @NotNull
    private final FileSpec.Builder fragmentInitFileBuilder;
    @NotNull
    private final FileSpec.Builder viewHolderInitFileBuilder;
    @NotNull
    private final FileSpec.Builder pagerViewInitFileBuilder;
    @NotNull
    private final List<CodeBlock> fragmentInitCodeBlocks;
    @NotNull
    private final List<CodeBlock> pagerViewInitCodeBlocks;
    @NotNull
    private final List<CodeBlock> viewHolderInitCodeBlocks;
    @NotNull
    private final List<KSFile> fragmentOriginatingKSFiles;
    @NotNull
    private final List<KSFile> pagerViewOriginatingKSFiles;
    @NotNull
    private final List<KSFile> viewHolderOriginatingKSFiles;

    public AntonioKspProcessor(@NotNull CodeGenerator codeGenerator, @NotNull KSPLogger logger) {
        Intrinsics.checkNotNullParameter((Object)codeGenerator, (String)"codeGenerator");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.codeGenerator = codeGenerator;
        this.logger = logger;
        String[] stringArray = new String[]{"AntonioSettings"};
        this.fragmentInitFileBuilder = FileSpec.Companion.builder("io.github.naverz.antonio", "AntonioFragmentInitExtension").addImport("io.github.naverz.antonio", stringArray);
        stringArray = new String[]{"AntonioSettings"};
        this.viewHolderInitFileBuilder = FileSpec.Companion.builder("io.github.naverz.antonio", "AntonioViewHolderInitExtension").addImport("io.github.naverz.antonio", stringArray);
        stringArray = new String[]{"AntonioSettings"};
        this.pagerViewInitFileBuilder = FileSpec.Companion.builder("io.github.naverz.antonio", "AntonioPagerViewInitExtension").addImport("io.github.naverz.antonio", stringArray);
        this.fragmentInitCodeBlocks = new ArrayList();
        this.pagerViewInitCodeBlocks = new ArrayList();
        this.viewHolderInitCodeBlocks = new ArrayList();
        this.fragmentOriginatingKSFiles = new ArrayList();
        this.pagerViewOriginatingKSFiles = new ArrayList();
        this.viewHolderOriginatingKSFiles = new ArrayList();
    }

    @NotNull
    public List<KSAnnotated> process(@NotNull Resolver resolver) {
        Sequence mappedWithViewDependencySymbols;
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        String string = MappedWithViewDependency.class.getCanonicalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalName(...)");
        Sequence $this$forEach$iv = mappedWithViewDependencySymbols = Resolver.getSymbolsWithAnnotation$default((Resolver)resolver, (String)string, (boolean)false, (int)2, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KSAnnotated classDeclaration = (KSAnnotated)element$iv;
            boolean bl = false;
            if (!(classDeclaration instanceof KSClassDeclaration) || ((KSClassDeclaration)classDeclaration).getClassKind() != ClassKind.CLASS || !UtilsKt.validate$default((KSNode)((KSNode)classDeclaration), null, (int)1, null)) {
                String message = Reflection.getOrCreateKotlinClass(MappedWithViewDependency.class) + " annotation is only for the class type";
                this.logger.error(message, (KSNode)classDeclaration);
                continue;
            }
            AddingContainerModel addingContainerModel = ExtensionsKt.makeAddingContainerModel(classDeclaration);
            ViewDependencyType viewDependencyType = addingContainerModel.component1();
            CodeBlock addFormatText = addingContainerModel.component2();
            switch (WhenMappings.$EnumSwitchMapping$0[viewDependencyType.ordinal()]) {
                case 1: {
                    this.fragmentInitCodeBlocks.add(addFormatText);
                    KSFile kSFile = ((KSClassDeclaration)classDeclaration).getContainingFile();
                    Intrinsics.checkNotNull((Object)kSFile);
                    this.fragmentOriginatingKSFiles.add(kSFile);
                    break;
                }
                case 2: {
                    this.pagerViewInitCodeBlocks.add(addFormatText);
                    KSFile kSFile = ((KSClassDeclaration)classDeclaration).getContainingFile();
                    Intrinsics.checkNotNull((Object)kSFile);
                    this.pagerViewOriginatingKSFiles.add(kSFile);
                    break;
                }
                case 3: {
                    this.viewHolderInitCodeBlocks.add(addFormatText);
                    KSFile kSFile = ((KSClassDeclaration)classDeclaration).getContainingFile();
                    Intrinsics.checkNotNull((Object)kSFile);
                    this.viewHolderOriginatingKSFiles.add(kSFile);
                }
            }
        }
        return CollectionsKt.emptyList();
    }

    public void finish() {
        CodeBlock it;
        super.finish();
        if (this.fragmentInitCodeBlocks.isEmpty() && this.pagerViewInitCodeBlocks.isEmpty() && this.viewHolderInitCodeBlocks.isEmpty()) {
            return;
        }
        KModifier[] kModifierArray = new KModifier[]{KModifier.INTERNAL};
        FunSpec.Builder fragmentInitFunc = FunSpec.Companion.builder("initFragmentWithModel").addModifiers(kModifierArray);
        KModifier[] kModifierArray2 = new KModifier[]{KModifier.INTERNAL};
        FunSpec.Builder pagerInitFunc = FunSpec.Companion.builder("initPagerViewWithModel").addModifiers(kModifierArray2);
        KModifier[] kModifierArray3 = new KModifier[]{KModifier.INTERNAL};
        FunSpec.Builder viewHolderInitFunc = FunSpec.Companion.builder("initViewHolderWithModel").addModifiers(kModifierArray3);
        Iterable $this$forEach$iv = this.fragmentInitCodeBlocks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (CodeBlock)element$iv;
            boolean bl = false;
            fragmentInitFunc.addCode(it);
        }
        $this$forEach$iv = this.pagerViewInitCodeBlocks;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (CodeBlock)element$iv;
            boolean bl = false;
            pagerInitFunc.addCode(it);
        }
        $this$forEach$iv = this.viewHolderInitCodeBlocks;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (CodeBlock)element$iv;
            boolean bl = false;
            viewHolderInitFunc.addCode(it);
        }
        this.fragmentInitFileBuilder.addFunction(fragmentInitFunc.build());
        this.pagerViewInitFileBuilder.addFunction(pagerInitFunc.build());
        this.viewHolderInitFileBuilder.addFunction(viewHolderInitFunc.build());
        Collection $this$toTypedArray$iv = this.fragmentOriginatingKSFiles;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        kModifierArray3 = thisCollection$iv.toArray(new KSFile[0]);
        OriginatingKSFilesKt.writeTo((FileSpec)this.fragmentInitFileBuilder.build(), (CodeGenerator)this.codeGenerator, (Dependencies)new Dependencies(true, (KSFile[])Arrays.copyOf(kModifierArray3, kModifierArray3.length)));
        $this$toTypedArray$iv = this.pagerViewOriginatingKSFiles;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        kModifierArray3 = thisCollection$iv.toArray(new KSFile[0]);
        OriginatingKSFilesKt.writeTo((FileSpec)this.pagerViewInitFileBuilder.build(), (CodeGenerator)this.codeGenerator, (Dependencies)new Dependencies(true, (KSFile[])Arrays.copyOf(kModifierArray3, kModifierArray3.length)));
        $this$toTypedArray$iv = this.viewHolderOriginatingKSFiles;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        kModifierArray3 = thisCollection$iv.toArray(new KSFile[0]);
        OriginatingKSFilesKt.writeTo((FileSpec)this.viewHolderInitFileBuilder.build(), (CodeGenerator)this.codeGenerator, (Dependencies)new Dependencies(true, (KSFile[])Arrays.copyOf(kModifierArray3, kModifierArray3.length)));
        this.initFileBuilder();
    }

    private final void initFileBuilder() {
        FunSpec.Builder builder;
        FunSpec.Builder $this$initFileBuilder_u24lambda_u244 = builder = FunSpec.Companion.builder("init");
        boolean bl = false;
        Object[] objectArray = new Object[]{"initPagerViewWithModel"};
        $this$initFileBuilder_u24lambda_u244.addCode(CodeBlock.Companion.of("%L()\n", objectArray));
        objectArray = new Object[]{"initFragmentWithModel"};
        $this$initFileBuilder_u24lambda_u244.addCode(CodeBlock.Companion.of("%L()\n", objectArray));
        objectArray = new Object[]{"initViewHolderWithModel"};
        $this$initFileBuilder_u24lambda_u244.addCode(CodeBlock.Companion.of("%L()", objectArray));
        FunSpec initFunction = builder.build();
        OriginatingKSFilesKt.writeTo((FileSpec)FileSpec.Companion.builder("io.github.naverz.antonio", "AntonioAnnotation").addType(TypeSpec.Companion.objectBuilder("AntonioAnnotation").addFunction(initFunction).build()).build(), (CodeGenerator)this.codeGenerator, (boolean)false, (Iterable)CollectionsKt.emptyList());
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ViewDependencyType.values().length];
            try {
                nArray[ViewDependencyType.Fragment.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ViewDependencyType.PagerView.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ViewDependencyType.ViewHolder.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

