/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.utils;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import org.springframework.dao.DataAccessException;

public interface ExceptionHandler {
    default public <T extends DataAccessException> T repackageToException(List<DynamoDBMapper.FailedBatch> failedBatches, Class<T> targetType) {
        Queue allExceptions = failedBatches.stream().map(it -> it.getException()).collect(Collectors.toCollection(LinkedList::new));
        Exception cause = (Exception)allExceptions.poll();
        try {
            Constructor<T> ctor = targetType.getConstructor(String.class, Throwable.class);
            DataAccessException e = (DataAccessException)ctor.newInstance("Processing of entities failed!", cause);
            allExceptions.stream().forEach(arg_0 -> e.addSuppressed(arg_0));
            return (T)e;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            if (!1.$assertionsDisabled) {
                throw new AssertionError();
            }
            throw new RuntimeException("Could not repackage '" + String.valueOf(failedBatches) + "' to " + String.valueOf(targetType), e);
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

