/*
 * Decompiled with CFR 0.152.
 */
package io.github.mocreates;

import io.github.mocreates.config.DefaultSequenceConfig;
import io.github.mocreates.config.SequenceConfig;
import io.github.mocreates.config.SimpleSequenceConfig;
import io.github.mocreates.exception.DatacenterIdGenerateException;
import io.github.mocreates.util.Assert;
import io.github.mocreates.util.StringUtils;
import io.github.mocreates.util.SystemClock;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.concurrent.ThreadLocalRandom;

public class Sequence {
    private final long twepoch;
    private final long workerIdShift;
    private final long datacenterIdShift;
    private final long timestampLeftShift;
    private final long sequenceMask;
    private final long workerId;
    private final long datacenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private InetAddress inetAddress;

    public Sequence(SequenceConfig config) {
        config.selfCheck();
        this.twepoch = config.getTwepoch();
        long maxWorkerId = -1L << (int)config.getWorkerIdBits() ^ 0xFFFFFFFFFFFFFFFFL;
        long maxDatacenterId = -1L << (int)config.getDatacenterIdBits() ^ 0xFFFFFFFFFFFFFFFFL;
        this.workerIdShift = config.getSequenceBits();
        this.datacenterIdShift = config.getSequenceBits() + config.getWorkerIdBits();
        this.timestampLeftShift = config.getSequenceBits() + config.getWorkerIdBits() + config.getDatacenterIdBits();
        this.sequenceMask = -1L << (int)config.getSequenceBits() ^ 0xFFFFFFFFFFFFFFFFL;
        if (config instanceof DefaultSequenceConfig) {
            DefaultSequenceConfig defaultSequenceConfig = (DefaultSequenceConfig)config;
            Assert.isTrue(defaultSequenceConfig.getWorkerId() <= maxWorkerId && defaultSequenceConfig.getWorkerId() >= 0L, String.format("worker Id can't be greater than %d or less than 0", maxWorkerId));
            Assert.isTrue(defaultSequenceConfig.getDatacenterId() <= maxDatacenterId && defaultSequenceConfig.getDatacenterId() >= 0L, String.format("datacenter Id can't be greater than %d or less than 0", maxDatacenterId));
            this.workerId = defaultSequenceConfig.getWorkerId();
            this.datacenterId = defaultSequenceConfig.getDatacenterId();
        } else if (config instanceof SimpleSequenceConfig) {
            SimpleSequenceConfig simpleSequenceConfig = (SimpleSequenceConfig)config;
            this.inetAddress = simpleSequenceConfig.getInetAddress();
            this.datacenterId = this.getDatacenterId(maxDatacenterId);
            this.workerId = this.getMaxWorkerId(this.datacenterId, maxWorkerId);
        } else {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684 SequenceConfig \u7c7b\u578b");
        }
    }

    protected long getMaxWorkerId(long datacenterId, long maxWorkerId) {
        StringBuilder mpid = new StringBuilder();
        mpid.append(datacenterId);
        String name = ManagementFactory.getRuntimeMXBean().getName();
        if (StringUtils.isNotBlank(name)) {
            mpid.append(name.split("@")[0]);
        }
        return (long)(mpid.toString().hashCode() & 0xFFFF) % (maxWorkerId + 1L);
    }

    protected long getDatacenterId(long maxDatacenterId) {
        long id = 0L;
        try {
            NetworkInterface network;
            if (null == this.inetAddress) {
                this.inetAddress = InetAddress.getLocalHost();
            }
            if (null == (network = NetworkInterface.getByInetAddress(this.inetAddress))) {
                id = 1L;
            } else {
                byte[] mac = network.getHardwareAddress();
                if (null != mac) {
                    id = (0xFFL & (long)mac[mac.length - 2] | 0xFF00L & (long)mac[mac.length - 1] << 8) >> 6;
                    id %= maxDatacenterId + 1L;
                }
            }
        }
        catch (Exception e) {
            throw new DatacenterIdGenerateException(e.getMessage());
        }
        return id;
    }

    public synchronized long nextId() {
        long timestamp;
        block8: {
            timestamp = this.timeGen();
            if (timestamp < this.lastTimestamp) {
                long offset = this.lastTimestamp - timestamp;
                if (offset <= 5L) {
                    try {
                        this.wait(offset << 1);
                        timestamp = this.timeGen();
                        if (timestamp < this.lastTimestamp) {
                            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", offset));
                        }
                        break block8;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", offset));
            }
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & this.sequenceMask;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = ThreadLocalRandom.current().nextLong(1L, 3L);
        }
        this.lastTimestamp = timestamp;
        return timestamp - this.twepoch << (int)this.timestampLeftShift | this.datacenterId << (int)this.datacenterIdShift | this.workerId << (int)this.workerIdShift | this.sequence;
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return SystemClock.now();
    }
}

