/*
 * Decompiled with CFR 0.152.
 */
package ArmyC2.C2SD.Utilities;

import ArmyC2.C2SD.Utilities.FileHandler;
import ArmyC2.C2SD.Utilities.SymbolUtilities;
import ArmyC2.C2SD.Utilities.UnitDef;
import ArmyC2.C2SD.Utilities.XMLUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class UnitDefTable {
    private static UnitDefTable _instance = null;
    private static Map<String, UnitDef> _UnitDefinitionsB = null;
    private static ArrayList<UnitDef> _UnitDefDupsB = null;
    private static Map<String, UnitDef> _UnitDefinitionsC = null;
    private static ArrayList<UnitDef> _UnitDefDupsC = null;
    private static String propSymbolID = "SYMBOLID";
    private static String propDrawCategory = "DRAWCATEGORY";
    private static String propModifiers = "MODIFIERS";
    private static String propDescription = "DESCRIPTION";
    private static String propHierarchy = "HIERARCHY";
    private static String propAlphaHierarchy = "ALPHAHIERARCHY";
    private static String propPath = "PATH";

    private UnitDefTable() {
        this.Init();
    }

    public static synchronized UnitDefTable getInstance() {
        if (_instance == null) {
            _instance = new UnitDefTable();
        }
        return _instance;
    }

    private void Init() {
        _UnitDefinitionsB = new HashMap<String, UnitDef>();
        _UnitDefDupsB = new ArrayList();
        _UnitDefinitionsC = new HashMap<String, UnitDef>();
        _UnitDefDupsC = new ArrayList();
        String xmlPathB = "XML/UnitConstantsB.xml";
        String xmlPathC = "XML/UnitConstantsC.xml";
        InputStream xmlStreamB = this.getClass().getClassLoader().getResourceAsStream(xmlPathB);
        InputStream xmlStreamC = this.getClass().getClassLoader().getResourceAsStream(xmlPathC);
        String lookupXmlB = FileHandler.InputStreamToString(xmlStreamB);
        String lookupXmlC = FileHandler.InputStreamToString(xmlStreamC);
        this.populateLookup(lookupXmlB, 0);
        this.populateLookup(lookupXmlC, 1);
    }

    private void populateLookup(String xml, int symStd) {
        UnitDef ud = null;
        ArrayList<String> al = XMLUtil.getItemList(xml, "<SYMBOL>", "</SYMBOL>");
        for (int i = 0; i < al.size(); ++i) {
            String data = al.get(i);
            String symbolID = XMLUtil.parseTagValue(data, "<SYMBOLID>", "</SYMBOLID>");
            String description = XMLUtil.parseTagValue(data, "<DESCRIPTION>", "</DESCRIPTION>");
            description = description.replaceAll("&amp;", "&");
            String drawCategory = XMLUtil.parseTagValue(data, "<DRAWCATEGORY>", "</DRAWCATEGORY>");
            String hierarchy = XMLUtil.parseTagValue(data, "<HIERARCHY>", "</HIERARCHY>");
            String alphaHierarchy = XMLUtil.parseTagValue(data, "<ALPHAHIERARCHY>", "</ALPHAHIERARCHY>");
            String path = XMLUtil.parseTagValue(data, "<PATH>", "</PATH>");
            ud = new UnitDef();
            if (SymbolUtilities.isInstallation(symbolID)) {
                symbolID = symbolID.substring(0, 10) + "H****";
            }
            ud.setBasicSymbolId(symbolID);
            ud.setDescription(description);
            if (drawCategory == null || drawCategory.equals("")) {
                ud.setDrawCategory(0);
            } else {
                ud.setDrawCategory(Integer.valueOf(drawCategory));
            }
            ud.setHierarchy(hierarchy);
            ud.setAlphaHierarchy(alphaHierarchy);
            ud.setFullPath(path);
            boolean isMCSSpecificFE = SymbolUtilities.isMCSSpecificForceElement(ud);
            if (symStd == 0) {
                if (!_UnitDefinitionsB.containsKey(symbolID) && !isMCSSpecificFE) {
                    _UnitDefinitionsB.put(symbolID, ud);
                    continue;
                }
                if (isMCSSpecificFE) continue;
                _UnitDefDupsB.add(ud);
                continue;
            }
            if (!_UnitDefinitionsC.containsKey(symbolID) && !isMCSSpecificFE) {
                _UnitDefinitionsC.put(symbolID, ud);
                continue;
            }
            if (isMCSSpecificFE) continue;
            _UnitDefDupsC.add(ud);
        }
    }

    public UnitDef getUnitDef(String basicSymbolID, int symStd) {
        UnitDef returnVal = null;
        if (symStd == 0) {
            returnVal = _UnitDefinitionsB.get(basicSymbolID);
            if (returnVal == null) {
                basicSymbolID = basicSymbolID.replace("*****", "H****");
                returnVal = _UnitDefinitionsB.get(basicSymbolID);
            }
        } else if (symStd == 1 && (returnVal = _UnitDefinitionsC.get(basicSymbolID)) == null) {
            basicSymbolID = basicSymbolID.replace("*****", "H****");
            returnVal = _UnitDefinitionsC.get(basicSymbolID);
        }
        return returnVal;
    }

    public Map<String, UnitDef> GetAllUnitDefs(int symStd) {
        if (symStd == 0) {
            return _UnitDefinitionsB;
        }
        return _UnitDefinitionsC;
    }

    public ArrayList<UnitDef> GetUnitDefDups(int symStd) {
        if (symStd == 0) {
            return _UnitDefDupsB;
        }
        return _UnitDefDupsC;
    }

    public Boolean HasUnitDef(String basicSymbolID, int symStd) {
        if (basicSymbolID != null && basicSymbolID.length() == 15) {
            if (symStd == 0) {
                return _UnitDefinitionsB.containsKey(basicSymbolID);
            }
            if (symStd == 1) {
                return _UnitDefinitionsC.containsKey(basicSymbolID);
            }
            return false;
        }
        return false;
    }
}

