/*
 * Decompiled with CFR 0.152.
 */
package ArmyC2.C2SD.Utilities;

import ArmyC2.C2SD.Utilities.ErrorLogger;
import ArmyC2.C2SD.Utilities.RendererException;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.io.InputStream;

public class SinglePointFont {
    static SinglePointFont _instance = null;

    private SinglePointFont() {
    }

    public static synchronized SinglePointFont getInstance() {
        if (_instance == null) {
            _instance = new SinglePointFont();
        }
        return _instance;
    }

    public Font getUnitFont(float size) {
        InputStream fontStream = _instance.getClass().getClassLoader().getResourceAsStream("FONTS/UnitFont.ttf");
        Font newFont = null;
        try {
            newFont = Font.createFont(0, fontStream);
        }
        catch (FontFormatException ffe) {
            ErrorLogger.LogException(this.getClass().getName(), "getUnitFont()", new RendererException("UnitFont failed to load.", ffe));
        }
        catch (IOException ioe) {
            ErrorLogger.LogException(this.getClass().getName(), "getUnitFont()", new RendererException("UnitFont failed to load.", ioe));
        }
        catch (Exception exc) {
            ErrorLogger.LogException(this.getClass().getName(), "getUnitFont()", new RendererException("UnitFont failed to load.", exc));
        }
        newFont = newFont.deriveFont(0, size);
        return newFont;
    }

    public Font getSPFont(float size) {
        InputStream fontStream = _instance.getClass().getClassLoader().getResourceAsStream("FONTS/SinglePoint.ttf");
        Font newFont = null;
        try {
            newFont = Font.createFont(0, fontStream);
        }
        catch (FontFormatException ffe) {
            ErrorLogger.LogException(this.getClass().getName(), "getSPFont()", new RendererException("SPFont failed to load.", ffe));
        }
        catch (IOException ioe) {
            ErrorLogger.LogException(this.getClass().getName(), "getSPFont()", new RendererException("SPFont failed to load.", ioe));
        }
        catch (Exception exc) {
            ErrorLogger.LogException(this.getClass().getName(), "getSPFont()", new RendererException("SPFont failed to load.", exc));
        }
        newFont = newFont.deriveFont(0, size);
        return newFont;
    }

    public Font getTGFont(float size) {
        InputStream fontStream = _instance.getClass().getClassLoader().getResourceAsStream("FONTS/TacticalGraphics.ttf");
        Font newFont = null;
        try {
            newFont = Font.createFont(0, fontStream);
        }
        catch (FontFormatException ffe) {
            ErrorLogger.LogException(this.getClass().getName(), "getTGFont()", new RendererException("TGFont failed to load.", ffe));
        }
        catch (IOException ioe) {
            ErrorLogger.LogException(this.getClass().getName(), "getTGFont()", new RendererException("TGFont failed to load.", ioe));
        }
        catch (Exception exc) {
            ErrorLogger.LogException(this.getClass().getName(), "getTGFont()", new RendererException("TGFont failed to load.", exc));
        }
        newFont = newFont.deriveFont(0, size);
        return newFont;
    }
}

