/*
 * Decompiled with CFR 0.152.
 */
package io.github.miracelwhipp.net.nuget.plugin;

import io.github.miracelwhipp.net.common.WagonArtifact;
import java.io.File;

public class NugetArtifact {
    public static final String EXTENSION_SPECIFICATION = ".nuspec";
    public static final String EXTENSION_PACKAGE = ".nupkg";
    public static final String TYPE_SPECIFICATION = "nuspec";
    public static final String TYPE_PACKAGE = "nupkg";
    private final WagonArtifact wagonArtifact;

    private NugetArtifact(WagonArtifact wagonArtifact) {
        this.wagonArtifact = wagonArtifact;
    }

    public String getArtifactId() {
        return this.wagonArtifact.getArtifactId();
    }

    public String getGroupId() {
        return this.wagonArtifact.getGroupId();
    }

    public String getVersion() {
        return this.wagonArtifact.getVersion();
    }

    public String getClassifier() {
        return this.wagonArtifact.getClassifier();
    }

    public String getType() {
        return this.wagonArtifact.getType();
    }

    public boolean isMetadata() {
        return this.wagonArtifact.isMetadata();
    }

    public WagonArtifact getWagonArtifact() {
        return this.wagonArtifact;
    }

    public String toString() {
        return "NugetArtifact{wagonArtifact=" + this.wagonArtifact + '}';
    }

    public boolean isNugetFile() {
        return this.getType().equals(TYPE_PACKAGE) || this.isNuSpec();
    }

    private boolean isNuSpec() {
        return this.getType().equals(TYPE_SPECIFICATION);
    }

    public boolean isPom() {
        return this.getType().equals("pom");
    }

    public boolean isSpec() {
        return this.isPom() || this.isNuSpec();
    }

    public String resourceString() {
        if (this.isMetadata()) {
            return this.getGroupId() + "/index.json";
        }
        if (this.isSpec()) {
            return this.getGroupId() + "/" + this.getVersion() + "/" + this.getGroupId() + EXTENSION_SPECIFICATION;
        }
        return this.getGroupId() + "/" + this.getVersion() + "/" + this.getGroupId() + "." + this.getVersion() + EXTENSION_PACKAGE;
    }

    public String artifactName() {
        return this.getArtifactId() + "." + this.getType();
    }

    public File specificationFile() {
        return new File(this.getGroupId() + EXTENSION_SPECIFICATION);
    }

    public NugetArtifact correspondingDownloadArtifact() {
        if (this.isSpec()) {
            return new NugetArtifact(WagonArtifact.newInstance((String)this.getGroupId(), (String)this.getGroupId(), (String)this.getVersion(), (String)this.getClassifier(), (String)TYPE_SPECIFICATION));
        }
        return new NugetArtifact(WagonArtifact.newInstance((String)this.getGroupId(), (String)this.getGroupId(), (String)this.getVersion(), (String)this.getClassifier(), (String)TYPE_PACKAGE));
    }

    public static NugetArtifact newInstance(String groupId, String artifactId, String version, String classifier, String type) {
        return new NugetArtifact(WagonArtifact.newInstance((String)groupId, (String)artifactId, (String)version, (String)classifier, (String)type));
    }

    public static NugetArtifact fromMavenResourceString(String resourceName) {
        return new NugetArtifact(WagonArtifact.fromWagonResourceString((String)resourceName));
    }
}

