/*
 * Decompiled with CFR 0.152.
 */
package io.github.miracelwhipp.net.nuget.plugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.miracelwhipp.net.common.Streams;
import io.github.miracelwhipp.net.common.Xml;
import io.github.miracelwhipp.net.nuget.plugin.NugetArtifact;
import io.github.miracelwhipp.net.nuget.plugin.NugetMetadata;
import io.github.miracelwhipp.net.nuget.plugin.NugetPackageDownloadManager;
import io.github.miracelwhipp.net.nuget.plugin.TargetFrameworkParameterSetter;
import io.github.miracelwhipp.net.provider.FrameworkVersion;
import io.github.miracelwhipp.net.provider.NetFrameworkProvider;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import java.util.regex.Matcher;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.logging.Logger;
import org.xml.sax.SAXException;

public abstract class AbstractNugetWagon
implements Wagon {
    public static final String LIBRARY_DIRECTORY = "lib/";
    public static final String TOOLS_DIRECTORY = "tools/";
    public static final String REFERENCES_DIRECTORY = "ref/";
    public static final String SUFFIX_MD5 = ".md5";
    public static final String BUILD_DIRECTORY = "build/";

    public abstract Wagon getDelegate();

    public abstract NugetPackageDownloadManager getDownloadManager();

    public abstract NetFrameworkProvider getFrameworkProvider();

    public abstract Logger getLogger();

    public synchronized void get(String resourceName, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.getLogger().debug("nuget download for " + resourceName + " to " + destination.getAbsolutePath());
        if (resourceName.endsWith(".sha1")) {
            this.getLogger().debug("resource is sha1 hash. not supported.");
            throw new ResourceDoesNotExistException("sha1 not supported.");
        }
        if (resourceName.endsWith(SUFFIX_MD5)) {
            this.getLogger().debug("resource is md5 hash.");
            this.getDownloadManager().getMd5Hash(this.getRepository(), NugetArtifact.fromMavenResourceString(resourceName.substring(0, resourceName.length() - SUFFIX_MD5.length())), destination);
            return;
        }
        NugetArtifact nugetArtifact = NugetArtifact.fromMavenResourceString(resourceName);
        if (nugetArtifact.isNugetFile()) {
            this.getLogger().debug("resource is nuget specific file.");
            this.getDownloadManager().getNugetFile(this.getDelegate(), nugetArtifact, destination);
            return;
        }
        if (nugetArtifact.isMetadata()) {
            this.getLogger().debug("resource is meta data only.");
            File jsonFile = new File(destination.getAbsolutePath() + ".json");
            this.getDownloadManager().getNugetFile(this.getDelegate(), nugetArtifact, jsonFile);
            this.transformResult(jsonFile, nugetArtifact, destination);
            return;
        }
        NugetArtifact downloadArtifact = nugetArtifact.correspondingDownloadArtifact();
        this.getLogger().debug("corresponding artifact is " + downloadArtifact);
        File downloadPackageFile = this.downloadPackageFile(downloadArtifact, nugetArtifact, destination);
        this.getDownloadManager().get(this.getDelegate(), downloadArtifact, downloadPackageFile);
        this.transformResult(downloadPackageFile, nugetArtifact, destination);
    }

    public synchronized boolean getIfNewer(String resourceName, File destination, long timestamp) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.getLogger().debug("nuget download for " + resourceName + " to " + destination.getAbsolutePath());
        if (resourceName.endsWith(SUFFIX_MD5) || resourceName.endsWith(".sha1")) {
            throw new ResourceDoesNotExistException("checksums not supported yet");
        }
        NugetArtifact nugetArtifact = NugetArtifact.fromMavenResourceString(resourceName);
        if (nugetArtifact.isNugetFile()) {
            this.getLogger().debug("resource is nuget specific file.");
            return this.getDownloadManager().getIfNewer(this.getDelegate(), nugetArtifact, destination, timestamp);
        }
        if (nugetArtifact.isMetadata()) {
            this.getLogger().debug("resource is meta data only.");
            File jsonFile = new File(destination.getAbsolutePath() + ".json");
            boolean result = this.getDownloadManager().getIfNewer(this.getDelegate(), nugetArtifact, jsonFile, timestamp);
            if (!result) {
                return false;
            }
            this.transformResult(jsonFile, nugetArtifact, destination);
            return true;
        }
        NugetArtifact downloadArtifact = nugetArtifact.correspondingDownloadArtifact();
        this.getLogger().debug("corresponding artifact is " + downloadArtifact);
        File downloadPackageFile = this.downloadPackageFile(downloadArtifact, nugetArtifact, destination);
        boolean result = this.getDownloadManager().getIfNewer(this.getDelegate(), downloadArtifact, downloadPackageFile, timestamp);
        if (!result) {
            return false;
        }
        this.transformResult(downloadPackageFile, nugetArtifact, destination);
        return true;
    }

    private File downloadPackageFile(NugetArtifact downloadArtifact, NugetArtifact artifact, File destination) {
        String groupIdPath = this.getGroupIdPath(artifact.getGroupId());
        String artifactPath = groupIdPath + File.separator + artifact.getArtifactId() + File.separator + artifact.getVersion();
        String destinationString = destination.getAbsolutePath();
        int artifactPosition = destinationString.lastIndexOf(artifactPath);
        File repositoryDirectory = new File(destinationString.substring(0, artifactPosition));
        File result = repositoryDirectory.toPath().resolve(downloadArtifact.getWagonArtifact().getArtifactFilename().toPath()).toFile();
        this.getLogger().debug("download package file is " + result.getAbsolutePath());
        return result;
    }

    private String getGroupIdPath(String groupId) {
        return groupId.replaceAll("\\.", Matcher.quoteReplacement(File.separator));
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        return this.getDelegate().resourceExists(NugetArtifact.fromMavenResourceString(resourceName).resourceString());
    }

    public List<String> getFileList(String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        return this.getDelegate().getFileList(destinationDirectory);
    }

    private void transformResult(File downloadPackageFile, NugetArtifact nugetArtifact, File destination) throws TransferFailedException, ResourceDoesNotExistException {
        this.getLogger().debug("transforming result. downloadPackageFile : " + downloadPackageFile.getAbsolutePath() + " nuget artifact : " + nugetArtifact + " destination " + destination.getAbsolutePath());
        if (nugetArtifact.isNugetFile()) {
            this.getLogger().debug("artifact is nuget specific file. Nothing to be done.");
            return;
        }
        if (nugetArtifact.isMetadata()) {
            this.getLogger().debug("transforming to meta data xml.");
            this.transFormToMetaDataXml(nugetArtifact, downloadPackageFile, destination);
            return;
        }
        if (nugetArtifact.isPom()) {
            this.getLogger().debug("transforming to pom.");
            this.transFormToPom(downloadPackageFile, destination);
            return;
        }
        if (nugetArtifact.getType().equals("dll")) {
            this.getLogger().debug("extracting library.");
            this.extractLibrary(downloadPackageFile, nugetArtifact, destination);
            return;
        }
        if (nugetArtifact.getType().equals("exe")) {
            this.getLogger().debug("extracting tool.");
            this.extractTool(downloadPackageFile, nugetArtifact, destination);
            return;
        }
        this.getLogger().debug("nothing to be done.");
    }

    private void transFormToMetaDataXml(NugetArtifact nugetArtifact, File jsonFile, File destination) throws TransferFailedException {
        try {
            String releaseVersion;
            ObjectMapper mapper = new ObjectMapper();
            NugetMetadata nugetMetadata = (NugetMetadata)mapper.readValue(jsonFile, NugetMetadata.class);
            StringBuilder builder = new StringBuilder();
            builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<metadata modelVersion=\"1.1.0\">\n  <groupId>");
            builder.append(nugetArtifact.getGroupId());
            builder.append("</groupId>\n  <artifactId>");
            builder.append(nugetArtifact.getArtifactId());
            builder.append("</artifactId>\n  <versioning>\n");
            if (!nugetMetadata.getVersions().isEmpty()) {
                builder.append("    <latest>");
                builder.append(nugetMetadata.getVersions().get(nugetMetadata.getVersions().size() - 1));
                builder.append("</latest>\n");
            }
            if ((releaseVersion = this.findReleaseVersion(nugetMetadata)) != null) {
                builder.append("    <release>");
                builder.append(releaseVersion);
                builder.append("</release>\n");
            }
            builder.append("    <versions>\n");
            for (String version : nugetMetadata.getVersions()) {
                builder.append("      <version>");
                builder.append(version);
                builder.append("</version>\n");
            }
            builder.append("    </versions>\n  </versioning>\n</metadata>\n");
            FileUtils.write((File)destination, (CharSequence)builder.toString(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
    }

    private String findReleaseVersion(NugetMetadata nugetMetadata) {
        for (int index = nugetMetadata.getVersions().size() - 1; index >= 0; --index) {
            String version = nugetMetadata.getVersions().get(index);
            if (!version.matches("[0-9]+(\\.[0-9]+)*")) continue;
            return version;
        }
        return null;
    }

    private void extractTool(File downloadPackageFile, NugetArtifact nugetArtifact, File destination) throws TransferFailedException, ResourceDoesNotExistException {
        try {
            File file = Streams.unpackForFile((File)downloadPackageFile, (File)new File(TOOLS_DIRECTORY, nugetArtifact.artifactName()));
            this.provideUnpackedFile(destination, file);
        }
        catch (IOException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
    }

    private void extractLibrary(File downloadPackageFile, NugetArtifact nugetArtifact, File destination) throws TransferFailedException, ResourceDoesNotExistException {
        FrameworkVersion desiredVersion = this.getFrameworkProvider().getFrameworkVersion();
        if (desiredVersion == null) {
            desiredVersion = FrameworkVersion.defaultVersion();
        }
        this.getLogger().debug("desired version is " + desiredVersion.toString());
        try {
            this.getLogger().debug("unpacking " + downloadPackageFile.getAbsolutePath() + " in order to get file " + nugetArtifact.specificationFile().getAbsolutePath());
            File specification = Streams.unpackForFile((File)downloadPackageFile, (File)nugetArtifact.specificationFile());
            File file = this.findLibrary(nugetArtifact, desiredVersion, specification, specification.getParentFile());
            this.provideUnpackedFile(destination, file);
        }
        catch (IOException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
    }

    private File findLibrary(NugetArtifact nugetArtifact, FrameworkVersion desiredVersion, File specification, File directory) throws ResourceDoesNotExistException {
        File libraryDirectory = new File(directory, LIBRARY_DIRECTORY);
        File result = new File(new File(libraryDirectory, desiredVersion.versionedToken()), nugetArtifact.artifactName());
        if (result.exists()) {
            return result;
        }
        result = this.searchDirectoryForVersionedFile(nugetArtifact, desiredVersion, libraryDirectory);
        if (result == null) {
            result = new File(new File(directory, TOOLS_DIRECTORY), nugetArtifact.artifactName());
        }
        if (result.exists()) {
            return result;
        }
        result = this.searchDirectoryForVersionedFile(nugetArtifact, desiredVersion, new File(directory, REFERENCES_DIRECTORY));
        if (result != null) {
            return result;
        }
        File buildDirectory = new File(directory, BUILD_DIRECTORY);
        result = new File(new File(new File(buildDirectory, desiredVersion.versionedToken()), REFERENCES_DIRECTORY), nugetArtifact.artifactName());
        if (result.exists()) {
            return result;
        }
        result = this.searchDirectoryForVersionedFile(nugetArtifact, desiredVersion, buildDirectory);
        if (result == null) {
            throw new ResourceDoesNotExistException("no compatible artifact found in nuget package");
        }
        return result;
    }

    private File searchDirectoryForVersionedFile(final NugetArtifact nugetArtifact, FrameworkVersion desiredVersion, File directory) {
        File[] directories = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (!pathname.isDirectory()) {
                    return false;
                }
                return new File(pathname, nugetArtifact.artifactName()).exists();
            }
        });
        if (directories == null) {
            return null;
        }
        FrameworkVersion extractedVersion = null;
        for (File pathname : directories) {
            FrameworkVersion currentVersion = FrameworkVersion.fromShortName((String)pathname.getName());
            if (currentVersion == null || !desiredVersion.isDownwardsCompatible(currentVersion) || extractedVersion != null && !currentVersion.isDownwardsCompatible(extractedVersion)) continue;
            extractedVersion = currentVersion;
        }
        if (extractedVersion == null) {
            return null;
        }
        return new File(new File(directory, extractedVersion.versionedToken()), nugetArtifact.artifactName());
    }

    private void provideUnpackedFile(File destination, File file) throws TransferFailedException, IOException, ResourceDoesNotExistException {
        if (file.exists()) {
            if (destination.exists() && !destination.delete()) {
                throw new TransferFailedException("cannot delete file " + destination.getAbsolutePath());
            }
        } else {
            throw new ResourceDoesNotExistException("no compatible artifact found in nuget package");
        }
        destination.getParentFile().mkdirs();
        Files.createLink(destination.toPath(), file.toPath());
    }

    private void transFormToPom(File sourceFile, File destination) throws TransferFailedException {
        try (InputStream source = AbstractNugetWagon.class.getResourceAsStream("/nuspec-to-pom.xsl");){
            Xml.transformFile((File)sourceFile, (Source)new StreamSource(source), (File)destination, (boolean)false, (Xml.ParameterSetter)new TargetFrameworkParameterSetter(this.getFrameworkProvider().getFrameworkVersion().versionedFullName()));
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
    }

    public void put(File source, String destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        throw new UnsupportedOperationException("nuget wagon is read-only");
    }

    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        throw new UnsupportedOperationException("nuget wagon is read-only");
    }

    public boolean supportsDirectoryCopy() {
        return false;
    }

    public Repository getRepository() {
        return this.getDelegate().getRepository();
    }

    public void connect(Repository source) throws ConnectionException, AuthenticationException {
        this.adaptRepository(source);
        this.getDelegate().connect(source);
    }

    private void adaptRepository(Repository source) {
        source.setUrl(source.getUrl().replaceFirst("nuget://", "https://"));
    }

    public void connect(Repository source, ProxyInfo proxyInfo) throws ConnectionException, AuthenticationException {
        this.adaptRepository(source);
        this.getDelegate().connect(source, proxyInfo);
    }

    public void connect(Repository source, ProxyInfoProvider proxyInfoProvider) throws ConnectionException, AuthenticationException {
        this.adaptRepository(source);
        this.getDelegate().connect(source, proxyInfoProvider);
    }

    public void connect(Repository source, AuthenticationInfo authenticationInfo) throws ConnectionException, AuthenticationException {
        this.adaptRepository(source);
        this.getDelegate().connect(source, authenticationInfo);
    }

    public void connect(Repository source, AuthenticationInfo authenticationInfo, ProxyInfo proxyInfo) throws ConnectionException, AuthenticationException {
        this.adaptRepository(source);
        this.getDelegate().connect(source, authenticationInfo);
    }

    public void connect(Repository source, AuthenticationInfo authenticationInfo, ProxyInfoProvider proxyInfoProvider) throws ConnectionException, AuthenticationException {
        this.adaptRepository(source);
        this.getDelegate().connect(source, authenticationInfo, proxyInfoProvider);
    }

    public void openConnection() throws ConnectionException, AuthenticationException {
        this.getDelegate().openConnection();
    }

    public void disconnect() throws ConnectionException {
        this.getDelegate().disconnect();
    }

    public void setTimeout(int timeoutValue) {
        this.getDelegate().setTimeout(timeoutValue);
    }

    public int getTimeout() {
        return this.getDelegate().getTimeout();
    }

    public void setReadTimeout(int timeoutValue) {
        this.getDelegate().setReadTimeout(timeoutValue);
    }

    public int getReadTimeout() {
        return this.getDelegate().getReadTimeout();
    }

    public void addSessionListener(SessionListener listener) {
        this.getDelegate().addSessionListener(listener);
    }

    public void removeSessionListener(SessionListener listener) {
        this.getDelegate().removeSessionListener(listener);
    }

    public boolean hasSessionListener(SessionListener listener) {
        return this.getDelegate().hasSessionListener(listener);
    }

    public void addTransferListener(TransferListener listener) {
        this.getDelegate().addTransferListener(listener);
    }

    public void removeTransferListener(TransferListener listener) {
        this.getDelegate().removeTransferListener(listener);
    }

    public boolean hasTransferListener(TransferListener listener) {
        return this.getDelegate().hasTransferListener(listener);
    }

    public boolean isInteractive() {
        return this.getDelegate().isInteractive();
    }

    public void setInteractive(boolean interactive) {
        this.getDelegate().setInteractive(interactive);
    }
}

