/*
 * Decompiled with CFR 0.152.
 */
package io.github.mightguy.spellcheck.symspell.common;

import io.github.mightguy.spellcheck.symspell.api.CharDistance;
import io.github.mightguy.spellcheck.symspell.api.StringDistance;

public class WeightedDamerauLevenshteinDistance
implements StringDistance {
    private double deletionWeight = 0.8f;
    private double insertionWeight = 1.01f;
    private double replaceWeight = 0.9f;
    private double transpositionWeight = 0.7f;
    private CharDistance charDistance;

    public WeightedDamerauLevenshteinDistance(double deletionWeight, double insertionWeight, double replaceWeight, double transpositionWeight, CharDistance charDistance) {
        this.deletionWeight = deletionWeight;
        this.insertionWeight = insertionWeight;
        this.replaceWeight = replaceWeight;
        this.transpositionWeight = transpositionWeight;
        this.charDistance = charDistance;
    }

    @Override
    public double getDistance(String source, String target) {
        int i;
        if (source.equals(target)) {
            return 0.0;
        }
        if (source.length() == 0) {
            return target.length();
        }
        if (target.length() == 0) {
            return source.length();
        }
        boolean useCharDistance = this.charDistance != null && source.length() == target.length();
        double[][] d = new double[target.length() + 1][source.length() + 1];
        for (i = target.length(); i >= 0; --i) {
            d[i][0] = (double)i * this.insertionWeight;
        }
        for (int j = source.length(); j >= 0; --j) {
            d[0][j] = (double)j * this.deletionWeight;
        }
        for (i = 1; i <= target.length(); ++i) {
            char target_i = target.charAt(i - 1);
            for (int j = 1; j <= source.length(); ++j) {
                char source_j = source.charAt(j - 1);
                double cost = this.getReplaceCost(target_i, source_j, useCharDistance);
                double min = this.min(d[i - 1][j] + this.insertionWeight, d[i][j - 1] + this.deletionWeight, d[i - 1][j - 1] + cost);
                if (this.isTransposition(i, j, source, target)) {
                    min = Math.min(min, d[i - 2][j - 2] + this.transpositionWeight);
                }
                d[i][j] = min;
            }
        }
        return d[target.length()][source.length()];
    }

    @Override
    public double getDistance(String w1, String w2, double maxEditDistance) {
        double distance = this.getDistance(w1, w2);
        if (distance > maxEditDistance) {
            return -1.0;
        }
        return distance;
    }

    private double min(double a, double b, double c) {
        return Math.min(a, Math.min(b, c));
    }

    private double min(double a, double b, double c, double d) {
        return Math.min(a, Math.min(b, Math.min(c, d)));
    }

    private boolean isTransposition(int i, int j, String source, String target) {
        return i > 2 && j > 2 && source.charAt(j - 2) == target.charAt(i - 1) && target.charAt(i - 2) == source.charAt(j - 1);
    }

    private double getReplaceCost(char aI, char bJ, boolean useCharDistance) {
        if (aI != bJ && useCharDistance) {
            return this.replaceWeight * this.charDistance.distance(aI, bJ);
        }
        if (aI != bJ) {
            return this.replaceWeight;
        }
        return 0.0;
    }
}

