/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.soapui.assertions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.microcks.util.soapui.assertions.AssertionStatus;
import io.github.microcks.util.soapui.assertions.ExchangeContext;
import io.github.microcks.util.soapui.assertions.RequestResponseExchange;
import io.github.microcks.util.soapui.assertions.WildcardMatchingAssertion;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPathContentAssertion
extends WildcardMatchingAssertion {
    private static Logger log = LoggerFactory.getLogger(JsonPathContentAssertion.class);
    public static final String PATH_PARAM = "path";
    public static final String EXPECTED_CONTENT_PARAM = "content";
    private String path;
    private String expectedContent;
    private String errorMessage;

    @Override
    public void configure(Map<String, String> configParams) {
        super.configure(configParams);
        this.path = configParams.get(PATH_PARAM);
        this.expectedContent = configParams.get(EXPECTED_CONTENT_PARAM);
    }

    @Override
    public AssertionStatus assertResponse(RequestResponseExchange exchange, ExchangeContext context) {
        log.debug("Asserting JsonPath on {}, expecting: {}", (Object)this.path, (Object)this.expectedContent);
        if (this.path == null) {
            this.errorMessage = "Missing path for JsonPath assertion";
            return AssertionStatus.FAILED;
        }
        if (this.expectedContent == null) {
            this.errorMessage = "Missing content for JsonPath assertion";
            return AssertionStatus.FAILED;
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode rootNode = mapper.readTree((Reader)new StringReader(exchange.responseContent()));
            JsonNode evaluatedNode = rootNode.at(this.path);
            String result = evaluatedNode.asText();
            if (this.allowWildcards) {
                if (!this.isSimilar(this.expectedContent, result)) {
                    this.errorMessage = "Comparison failed for path [" + this.path + "], expecting [" + this.expectedContent + "], actual was [" + result + "]";
                    return AssertionStatus.FAILED;
                }
            } else if (!this.expectedContent.equals(result)) {
                this.errorMessage = "Comparison failed for path [" + this.path + "], expecting [" + this.expectedContent + "], actual was [" + result + "]";
                return AssertionStatus.FAILED;
            }
        }
        catch (Exception e) {
            log.warn("Exception while compiling/evaluating JsonPointer", (Throwable)e);
            this.errorMessage = "Exception while compiling/evaluating JoinPointer: " + this.path;
            return AssertionStatus.FAILED;
        }
        return AssertionStatus.VALID;
    }

    @Override
    public List<String> getErrorMessages() {
        return List.of(this.errorMessage);
    }
}

