/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.config;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.springframework.http.server.observation.DefaultServerRequestObservationConvention;
import org.springframework.http.server.observation.ServerRequestObservationContext;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerMapping;

@Component
public class MicrometerConfiguration
extends DefaultServerRequestObservationConvention {
    public KeyValues getLowCardinalityKeyValues(ServerRequestObservationContext context) {
        return super.getLowCardinalityKeyValues(context).and((Iterable)this.additionalTags(context));
    }

    protected KeyValues additionalTags(ServerRequestObservationContext context) {
        KeyValues keyValues = KeyValues.empty();
        Map pathVariables = (Map)((HttpServletRequest)context.getCarrier()).getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        if (pathVariables != null) {
            String service = (String)pathVariables.get("service");
            String version = (String)pathVariables.get("version");
            if (service != null) {
                keyValues = keyValues.and(new KeyValue[]{KeyValue.of((String)"service", (String)service)});
            }
            if (version != null) {
                keyValues = keyValues.and(new KeyValue[]{KeyValue.of((String)"version", (String)version)});
            }
        }
        return keyValues;
    }
}

