/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.config;

import io.github.microcks.util.ai.AICopilot;
import io.github.microcks.util.ai.OpenAICopilot;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(value="ai-copilot")
public class AICopilotConfiguration {
    private static Logger log = LoggerFactory.getLogger(AICopilotConfiguration.class);
    private boolean enabled = false;
    private String implementation;
    private Map<String, String> openai;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setImplementation(String implementation) {
        this.implementation = implementation;
    }

    public void setOpenai(Map<String, String> openai) {
        this.openai = openai;
    }

    @Bean
    public AICopilot aiCopilotImplementation() {
        if (this.enabled && this.implementation != null) {
            log.info("AICopilot is enabled with implementation '{}'", (Object)this.implementation);
            if ("openai".equals(this.implementation)) {
                if (Arrays.stream(OpenAICopilot.getMandatoryConfigKeys()).allMatch(key -> this.openai.containsKey(key))) {
                    return new OpenAICopilot(this.openai);
                }
                log.warn("At least one mandatory configuration is missing for OpenAI AICopilot implementation");
                log.warn("Mandatory configuration keys are: {}", (Object[])OpenAICopilot.getMandatoryConfigKeys());
            }
        }
        log.info("AICopilot is disabled");
        return null;
    }
}

