/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util;

import io.github.microcks.domain.Secret;
import io.github.microcks.util.HTTPDownloader;
import io.github.microcks.util.RelativeReferenceURLBuilder;
import io.github.microcks.util.SimpleReferenceURLBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceResolver {
    private static Logger log = LoggerFactory.getLogger(ReferenceResolver.class);
    private String baseRepositoryUrl;
    private Secret repositorySecret;
    private boolean disableSSLValidation;
    private RelativeReferenceURLBuilder urlBuilder;
    private Map<String, File> resolvedReferences = new HashMap<String, File>();

    public ReferenceResolver(String baseRepositoryUrl, Secret repositorySecret, boolean disableSSLValidation) {
        this.repositorySecret = repositorySecret;
        this.disableSSLValidation = disableSSLValidation;
        this.baseRepositoryUrl = baseRepositoryUrl.endsWith("/") ? baseRepositoryUrl.substring(0, baseRepositoryUrl.length() - 1) : baseRepositoryUrl;
        this.urlBuilder = new SimpleReferenceURLBuilder();
    }

    public ReferenceResolver(String baseRepositoryUrl, Secret repositorySecret, boolean disableSSLValidation, RelativeReferenceURLBuilder urlBuilder) {
        this.repositorySecret = repositorySecret;
        this.disableSSLValidation = disableSSLValidation;
        this.baseRepositoryUrl = baseRepositoryUrl.endsWith("/") ? baseRepositoryUrl.substring(0, baseRepositoryUrl.length() - 1) : baseRepositoryUrl;
        this.urlBuilder = urlBuilder;
    }

    public String getHttpReferenceContent(String relativePath, String encoding) throws IOException {
        File referenceFile = this.resolvedReferences.get(relativePath);
        if (referenceFile == null) {
            String remoteUrl = relativePath;
            if (!relativePath.startsWith("http")) {
                remoteUrl = this.urlBuilder.buildRemoteURL(this.baseRepositoryUrl, relativePath);
            }
            log.info("Downloading a reference file at {}", (Object)remoteUrl);
            referenceFile = HTTPDownloader.handleHTTPDownloadToFile(remoteUrl, this.repositorySecret, this.disableSSLValidation);
            this.resolvedReferences.put(relativePath, referenceFile);
        }
        return Files.readString(referenceFile.toPath(), Charset.forName(encoding));
    }

    public Map<String, File> getResolvedReferences() {
        return this.resolvedReferences;
    }

    public void cleanResolvedReferences() {
        for (File referenceFile : this.resolvedReferences.values()) {
            referenceFile.delete();
        }
        this.resolvedReferences.clear();
    }
}

