/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.soapui.assertions;

import io.github.microcks.util.soapui.assertions.AssertionStatus;
import io.github.microcks.util.soapui.assertions.ExchangeContext;
import io.github.microcks.util.soapui.assertions.RequestResponseExchange;
import io.github.microcks.util.soapui.assertions.SoapUIAssertion;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotSoapFaultAssertion
implements SoapUIAssertion {
    private static Logger log = LoggerFactory.getLogger(NotSoapFaultAssertion.class);
    private static final Pattern FAULT_CAPTURE_PATTERN = Pattern.compile("(.*):Body>(\\s*)<((\\w+):|)Fault(.*)(/)?>(.*)", 32);
    private String errorMessage;

    @Override
    public void configure(Map<String, String> configParams) {
    }

    @Override
    public AssertionStatus assertResponse(RequestResponseExchange exchange, ExchangeContext context) {
        log.debug("Asserting response is not a SOAP Fault");
        String responseContent = exchange.responseContent();
        if (responseContent.contains(":Fault") || responseContent.contains("<Fault")) {
            log.debug("Found some Fault in body");
            Matcher matcher = FAULT_CAPTURE_PATTERN.matcher(responseContent);
            if (matcher.find()) {
                log.debug("RegExp is matching, that's a fault!");
                this.errorMessage = "Response is a SOAP Fault";
                return AssertionStatus.FAILED;
            }
        }
        return AssertionStatus.VALID;
    }

    @Override
    public List<String> getErrorMessages() {
        return List.of(this.errorMessage);
    }
}

