/*
 * Decompiled with CFR 0.152.
 */
package io.github.michaldo.nashorn_maven_plugin;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="eval", requiresProject=false, threadSafe=true)
public class EvalMojo
extends AbstractMojo {
    @Parameter(required=true, property="script")
    private String script;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Component
    private MavenProject project;
    @Component
    private MojoExecution mojoExecution;
    @Component
    private MavenSession mavenSession;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            return;
        }
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager(ClassLoader.getSystemClassLoader());
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("nashorn");
        scriptEngine.put("$project", this.project);
        scriptEngine.put("$mojo", this.mojoExecution);
        scriptEngine.put("$session", this.mavenSession);
        scriptEngine.put("$plugin", this.mojoExecution.getMojoDescriptor().getPluginDescriptor());
        scriptEngine.put("$settings", this.mavenSession.getSettings());
        scriptEngine.put("$localRepository", this.mavenSession.getLocalRepository());
        scriptEngine.put("$reactorProjects", this.mavenSession.getProjects());
        scriptEngine.put("$repositorySystemSession", this.mavenSession.getRepositorySession());
        scriptEngine.put("$executedProject", this.project.getExecutionProject());
        scriptEngine.put("$basedir", this.project.getBasedir());
        String jsCode = "(function(){" + this.script + "})()";
        try {
            scriptEngine.eval(jsCode);
        }
        catch (ScriptException se) {
            throw new MojoExecutionException(jsCode, (Exception)se);
        }
    }
}

