/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.utils;

import android.os.SystemClock;
import com.sankuai.waimai.router.core.Debugger;

public abstract class LazyInitHelper {
    private final String mTag;
    private boolean mHasInit = false;

    public LazyInitHelper(String tag) {
        this.mTag = tag;
    }

    public void lazyInit() {
        this.performInit();
    }

    public void ensureInit() {
        this.performInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performInit() {
        if (!this.mHasInit) {
            LazyInitHelper lazyInitHelper = this;
            synchronized (lazyInitHelper) {
                if (!this.mHasInit) {
                    long ts = 0L;
                    boolean enableLog = Debugger.isEnableLog();
                    if (enableLog) {
                        ts = SystemClock.uptimeMillis();
                    }
                    try {
                        this.doInit();
                        this.mHasInit = true;
                    }
                    catch (Throwable t) {
                        Debugger.fatal(t);
                    }
                    if (enableLog) {
                        Debugger.i("%s init cost %s ms", this.mTag, SystemClock.uptimeMillis() - ts);
                    }
                }
            }
        }
    }

    protected abstract void doInit();
}

