/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.regex;

import androidx.annotation.NonNull;
import com.sankuai.waimai.router.components.RouterComponents;
import com.sankuai.waimai.router.components.UriTargetTools;
import com.sankuai.waimai.router.core.ChainedHandler;
import com.sankuai.waimai.router.core.Debugger;
import com.sankuai.waimai.router.core.UriCallback;
import com.sankuai.waimai.router.core.UriHandler;
import com.sankuai.waimai.router.core.UriInterceptor;
import com.sankuai.waimai.router.core.UriRequest;
import com.sankuai.waimai.router.regex.IRegexAnnotationInit;
import com.sankuai.waimai.router.regex.RegexWrapperHandler;
import com.sankuai.waimai.router.utils.LazyInitHelper;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegexAnnotationHandler
extends ChainedHandler {
    private final LazyInitHelper mInitHelper = new LazyInitHelper("RegexAnnotationHandler"){

        @Override
        protected void doInit() {
            RegexAnnotationHandler.this.initAnnotationConfig();
        }
    };

    public void lazyInit() {
        this.mInitHelper.lazyInit();
    }

    protected void initAnnotationConfig() {
        RouterComponents.loadAnnotation(this, IRegexAnnotationInit.class);
    }

    public void register(String regex, Object target, boolean exported, int priority, UriInterceptor ... interceptors) {
        UriHandler innerHandler;
        Pattern pattern = this.compile(regex);
        if (pattern != null && (innerHandler = UriTargetTools.parse(target, exported, interceptors)) != null) {
            RegexWrapperHandler handler = new RegexWrapperHandler(pattern, priority, innerHandler);
            this.addChildHandler(handler, priority);
        }
    }

    @Override
    public void handle(@NonNull UriRequest request, @NonNull UriCallback callback) {
        this.mInitHelper.ensureInit();
        super.handle(request, callback);
    }

    private Pattern compile(String regex) {
        if (regex != null) {
            try {
                return Pattern.compile(regex);
            }
            catch (PatternSyntaxException e) {
                Debugger.fatal(e);
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "RegexAnnotationHandler";
    }
}

