/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.fragment.v4;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.sankuai.waimai.router.core.Debugger;
import com.sankuai.waimai.router.core.UriRequest;
import com.sankuai.waimai.router.fragment.AbsFragmentTransactionUriRequest;
import com.sankuai.waimai.router.fragment.StartFragmentAction;

public class FragmentTransactionUriRequest
extends AbsFragmentTransactionUriRequest {
    private final FragmentManager mFragmentManager;

    public FragmentTransactionUriRequest(@NonNull FragmentActivity activity, String uri) {
        super((Context)activity, uri);
        this.mFragmentManager = activity.getSupportFragmentManager();
    }

    public FragmentTransactionUriRequest(@NonNull Fragment fragment, String uri) {
        super(fragment.getContext(), uri);
        this.mFragmentManager = fragment.getChildFragmentManager();
    }

    public FragmentTransactionUriRequest(@NonNull Context context, FragmentManager fragmentManager, String uri) {
        super(context, uri);
        this.mFragmentManager = fragmentManager;
    }

    @Override
    protected StartFragmentAction getStartFragmentAction() {
        return new BuildStartFragmentAction(this.mFragmentManager, this.mContainerViewId, this.mType, this.mAllowingStateLoss, this.mTag);
    }

    static class BuildStartFragmentAction
    implements StartFragmentAction {
        private final FragmentManager mFragmentManager;
        private final int mContainerViewId;
        private final int mStartType;
        private final boolean mAllowingStateLoss;
        private final String mTag;

        BuildStartFragmentAction(@NonNull FragmentManager fragmentManager, @IdRes int containerViewId, int startType, boolean allowingStateLoss, String tag) {
            this.mFragmentManager = fragmentManager;
            this.mContainerViewId = containerViewId;
            this.mStartType = startType;
            this.mAllowingStateLoss = allowingStateLoss;
            this.mTag = tag;
        }

        @Override
        public boolean startFragment(@NonNull UriRequest request, @NonNull Bundle bundle) throws ActivityNotFoundException, SecurityException {
            String fragmentClassName = request.getStringField("FRAGMENT_CLASS_NAME");
            if (TextUtils.isEmpty((CharSequence)fragmentClassName)) {
                Debugger.fatal("FragmentTransactionHandler.handleInternal()\u5e94\u8fd4\u56de\u7684\u5e26\u6709ClassName", new Object[0]);
                return false;
            }
            if (this.mContainerViewId == 0) {
                Debugger.fatal("FragmentTransactionHandler.handleInternal()mContainerViewId", new Object[0]);
                return false;
            }
            try {
                Fragment fragment = Fragment.instantiate((Context)request.getContext(), (String)fragmentClassName, (Bundle)bundle);
                if (fragment == null) {
                    return false;
                }
                FragmentTransaction transaction = this.mFragmentManager.beginTransaction();
                switch (this.mStartType) {
                    case 1: {
                        transaction.add(this.mContainerViewId, fragment, this.mTag);
                        break;
                    }
                    case 2: {
                        transaction.replace(this.mContainerViewId, fragment, this.mTag);
                    }
                }
                if (this.mAllowingStateLoss) {
                    transaction.commitAllowingStateLoss();
                } else {
                    transaction.commit();
                }
                return true;
            }
            catch (Exception e) {
                Debugger.e("FragmentTransactionUriRequest", e);
                return false;
            }
        }
    }
}

